/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.NodeFields;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVMLongDoubleNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMNegatedForeignObject;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMCMathsIntrinsicsFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMFloatStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValue;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

public abstract class LLVMCMathsIntrinsics {
    public static LLVMBuiltin.TypedBuiltinFactory getSqrtFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.vector1(LLVMCMathsIntrinsicsFactory.LLVMSqrtNodeGen::create, LLVMCMathsIntrinsicsFactory.LLVMSqrtVectorNodeGen::create);
            }
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("sqrt", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP80));
            }
            case F128: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("sqrt", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP128));
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getLogFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.simple1(LLVMCMathsIntrinsicsFactory.LLVMLogNodeGen::create);
            }
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("log", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP80));
            }
            case F128: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("log", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP128));
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getLog2Factory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.simple1(LLVMCMathsIntrinsicsFactory.LLVMLog2NodeGen::create);
            }
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("log2", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP80));
            }
            case F128: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("log2", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP128));
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getLog10Factory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.simple1(LLVMCMathsIntrinsicsFactory.LLVMLog10NodeGen::create);
            }
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("log10", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP80));
            }
            case F128: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("log10", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP128));
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getRintFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.simple1(LLVMCMathsIntrinsicsFactory.LLVMRintNodeGen::create);
            }
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("rint", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP80));
            }
            case F128: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("rint", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP128));
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getCeilFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.simple1(LLVMCMathsIntrinsicsFactory.LLVMCeilNodeGen::create);
            }
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("ceil", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP80));
            }
            case F128: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("ceil", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP128));
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getFloorFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.simple1(LLVMCMathsIntrinsicsFactory.LLVMFloorNodeGen::create);
            }
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("floor", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP80));
            }
            case F128: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("floor", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP128));
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getExpFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.simple1(LLVMCMathsIntrinsicsFactory.LLVMExpNodeGen::create);
            }
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("exp", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP80));
            }
            case F128: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("exp", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP128));
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getExp2Factory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.simple1(LLVMCMathsIntrinsicsFactory.LLVMExp2NodeGen::create);
            }
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("exp2", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP80));
            }
            case F128: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("exp2", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP128));
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getSinFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.simple1(LLVMCMathsIntrinsicsFactory.LLVMSinNodeGen::create);
            }
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("sin", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP80));
            }
            case F128: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("sin", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP128));
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getCosFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.simple1(LLVMCMathsIntrinsicsFactory.LLVMCosNodeGen::create);
            }
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("cos", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP80));
            }
            case F128: {
                return LLVMBuiltin.TypedBuiltinFactory.simple(args -> LLVMLongDoubleNode.createUnary("cos", args[1], LLVMLongDoubleNode.LongDoubleKinds.FP128));
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getRoundFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.simple1(LLVMCMathsIntrinsicsFactory.LLVMRoundNodeGen::create);
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getMinnumFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.simple2(LLVMCMathsIntrinsicsFactory.LLVMMinnumNodeGen::create);
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getMaxnumFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.simple2(LLVMCMathsIntrinsicsFactory.LLVMMaxnumNodeGen::create);
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getCopySignFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: 
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple2(LLVMCMathsIntrinsicsFactory.LLVMCopySignNodeGen::create);
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getAbsFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case I8: 
            case I16: 
            case I32: 
            case I64: {
                return LLVMBuiltin.TypedBuiltinFactory.simple1(LLVMCMathsIntrinsicsFactory.LLVMAbsNodeGen::create);
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getFAbsFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: 
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.vector1(LLVMCMathsIntrinsicsFactory.LLVMFAbsNodeGen::create, LLVMCMathsIntrinsicsFactory.LLVMFAbsVectorNodeGen::create);
            }
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple1(LLVMCMathsIntrinsicsFactory.LLVMFAbsNodeGen::create);
            }
        }
        return null;
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    @NodeFields(value={@NodeField(name="vectorLength", type=int.class), @NodeField(name="operator", type=LLVMMinMaxOperator.class)})
    public static abstract class LLVMVectorMinMaxNode
    extends LLVMAbstractMinMaxNode {
        protected abstract int getVectorLength();

        @Specialization
        protected boolean doI1Scalar(boolean a, boolean b) {
            return this.getOperator().compare(a, b);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doI1Vector(LLVMI1Vector a, LLVMI1Vector b) {
            assert (a.getLength() == this.getVectorLength());
            assert (b.getLength() == this.getVectorLength());
            boolean[] result = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = this.getOperator().compare(a.getValue(i), b.getValue(i));
            }
            return LLVMI1Vector.create(result);
        }

        @Specialization
        protected byte doI8Scalar(byte a, byte b) {
            return this.compare(a, b);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doI8Vector(LLVMI8Vector a, LLVMI8Vector b) {
            assert (a.getLength() == this.getVectorLength());
            assert (b.getLength() == this.getVectorLength());
            byte[] result = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                byte aValue = a.getValue(i);
                byte bValue = b.getValue(i);
                result[i] = this.compare(aValue, bValue);
            }
            return LLVMI8Vector.create(result);
        }

        @Specialization
        protected short doI16Vector(short a, short b) {
            return this.compare(a, b);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doI16Vector(LLVMI16Vector a, LLVMI16Vector b) {
            assert (a.getLength() == this.getVectorLength());
            assert (b.getLength() == this.getVectorLength());
            short[] result = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                short aValue = a.getValue(i);
                short bValue = b.getValue(i);
                result[i] = this.compare(aValue, bValue);
            }
            return LLVMI16Vector.create(result);
        }

        @Specialization
        protected int doI32Vector(int a, int b) {
            return this.getOperator().compare(a, b);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doI32Vector(LLVMI32Vector a, LLVMI32Vector b) {
            assert (a.getLength() == this.getVectorLength());
            assert (b.getLength() == this.getVectorLength());
            int[] result = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int aValue = a.getValue(i);
                int bValue = b.getValue(i);
                result[i] = this.getOperator().compare(aValue, bValue);
            }
            return LLVMI32Vector.create(result);
        }

        @Specialization
        protected long doI64Vector(long a, long b) {
            return this.getOperator().compare(a, b);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doI64Vector(LLVMI64Vector a, LLVMI64Vector b) {
            assert (a.getLength() == this.getVectorLength());
            assert (b.getLength() == this.getVectorLength());
            long[] result = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long aValue = a.getValue(i);
                long bValue = b.getValue(i);
                result[i] = this.getOperator().compare(aValue, bValue) >= 0L ? aValue : bValue;
            }
            return LLVMI64Vector.create(result);
        }

        @Specialization
        protected float doFloatVector(float a, float b) {
            return this.getOperator().compare(a, b);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doFloatVector(LLVMFloatVector a, LLVMFloatVector b) {
            assert (a.getLength() == this.getVectorLength());
            assert (b.getLength() == this.getVectorLength());
            float[] result = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = this.getOperator().compare(a.getValue(i), b.getValue(i));
            }
            return LLVMFloatVector.create(result);
        }

        @Specialization
        protected double doDoubleVector(double a, double b) {
            return this.getOperator().compare(a, b);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doDoubleVector(LLVMDoubleVector a, LLVMDoubleVector b) {
            assert (a.getLength() == this.getVectorLength());
            assert (b.getLength() == this.getVectorLength());
            double[] result = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = this.getOperator().compare(a.getValue(i), b.getValue(i));
            }
            return LLVMDoubleVector.create(result);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    @NodeField(name="operator", type=LLVMMinMaxOperator.class)
    public static abstract class LLVMScalarMinMaxNode
    extends LLVMAbstractMinMaxNode {
        @Specialization
        protected boolean doI1Scalar(boolean a, boolean b) {
            return this.getOperator().compare(a, b);
        }

        @Specialization
        protected byte doI8Scalar(byte a, byte b) {
            return this.compare(a, b);
        }

        @Specialization
        protected short doI16Vector(short a, short b) {
            return this.compare(a, b);
        }

        @Specialization
        protected int doI32Vector(int a, int b) {
            return this.getOperator().compare(a, b);
        }

        @Specialization
        protected long doI64Vector(long a, long b) {
            return this.getOperator().compare(a, b);
        }

        @Specialization
        protected float doFloatVector(float a, float b) {
            return this.getOperator().compare(a, b);
        }

        @Specialization
        protected double doDoubleVector(double a, double b) {
            return this.getOperator().compare(a, b);
        }

        @Specialization
        protected LLVMPointer doPointer(LLVMPointer a, LLVMPointer b, @Cached ToComparableValue aComp, @Cached ToComparableValue bComp) {
            return this.getOperator().compare(a, aComp.executeWithTarget(a), b, bComp.executeWithTarget(b));
        }
    }

    public static abstract class LLVMAbstractMinMaxNode
    extends LLVMBuiltin {
        protected abstract LLVMMinMaxOperator getOperator();

        protected byte compare(byte a, byte b) {
            return (byte)this.getOperator().compare(a, b);
        }

        protected short compare(short a, short b) {
            return (short)this.getOperator().compare(a, b);
        }
    }

    public static final class LLVMSminOperator
    extends LLVMMinMaxOperator {
        public static final LLVMSminOperator INSTANCE = new LLVMSminOperator();

        @Override
        protected boolean compare(boolean a, boolean b) {
            return a && b;
        }

        @Override
        protected int compare(int a, int b) {
            return Math.min(a, b);
        }

        @Override
        protected long compare(long a, long b) {
            return Math.min(a, b);
        }

        @Override
        protected float compare(float a, float b) {
            return Math.min(a, b);
        }

        @Override
        protected double compare(double a, double b) {
            return Math.min(a, b);
        }

        @Override
        protected LLVMPointer compare(LLVMPointer a, long aCmp, LLVMPointer b, long bCmp) {
            return aCmp <= bCmp ? a : b;
        }
    }

    public static final class LLVMSmaxOperator
    extends LLVMMinMaxOperator {
        public static final LLVMSmaxOperator INSTANCE = new LLVMSmaxOperator();

        @Override
        protected boolean compare(boolean a, boolean b) {
            return a || b;
        }

        @Override
        protected int compare(int a, int b) {
            return Math.max(a, b);
        }

        @Override
        protected long compare(long a, long b) {
            return Math.max(a, b);
        }

        @Override
        protected float compare(float a, float b) {
            return Math.max(a, b);
        }

        @Override
        protected double compare(double a, double b) {
            return Math.max(a, b);
        }

        @Override
        protected LLVMPointer compare(LLVMPointer a, long aCmp, LLVMPointer b, long bCmp) {
            return aCmp >= bCmp ? a : b;
        }
    }

    public static final class LLVMUminOperator
    extends LLVMMinMaxOperator {
        public static final LLVMUminOperator INSTANCE = new LLVMUminOperator();

        @Override
        protected boolean compare(boolean a, boolean b) {
            return a && b;
        }

        @Override
        protected int compare(int a, int b) {
            return Integer.compareUnsigned(a, b) <= 0 ? a : b;
        }

        @Override
        protected long compare(long a, long b) {
            return Long.compareUnsigned(a, b) <= 0 ? a : b;
        }

        @Override
        protected float compare(float a, float b) {
            return Math.min(a, b);
        }

        @Override
        protected double compare(double a, double b) {
            return Math.min(a, b);
        }

        @Override
        protected LLVMPointer compare(LLVMPointer a, long aCmp, LLVMPointer b, long bCmp) {
            return Long.compareUnsigned(aCmp, bCmp) <= 0 ? a : b;
        }
    }

    public static final class LLVMUmaxOperator
    extends LLVMMinMaxOperator {
        public static final LLVMUmaxOperator INSTANCE = new LLVMUmaxOperator();

        @Override
        protected boolean compare(boolean a, boolean b) {
            return a || b;
        }

        @Override
        protected int compare(int a, int b) {
            return Integer.compareUnsigned(a, b) >= 0 ? a : b;
        }

        @Override
        protected long compare(long a, long b) {
            return Long.compareUnsigned(a, b) >= 0 ? a : b;
        }

        @Override
        protected float compare(float a, float b) {
            return Math.max(a, b);
        }

        @Override
        protected double compare(double a, double b) {
            return Math.max(a, b);
        }

        @Override
        protected LLVMPointer compare(LLVMPointer a, long aCmp, LLVMPointer b, long bCmp) {
            return Long.compareUnsigned(aCmp, bCmp) >= 0 ? a : b;
        }
    }

    static abstract class LLVMMinMaxOperator {
        LLVMMinMaxOperator() {
        }

        protected abstract boolean compare(boolean var1, boolean var2);

        protected abstract int compare(int var1, int var2);

        protected abstract long compare(long var1, long var3);

        protected abstract float compare(float var1, float var2);

        protected abstract double compare(double var1, double var3);

        protected abstract LLVMPointer compare(LLVMPointer var1, long var2, LLVMPointer var4, long var5);
    }

    @NodeChildren(value={@NodeChild(value="magnitude", type=LLVMExpressionNode.class), @NodeChild(value="sign", type=LLVMExpressionNode.class)})
    public static abstract class LLVMCopySign
    extends LLVMBuiltin {
        @Specialization
        protected float doFloat(float magnitude, float sign) {
            return Math.copySign(magnitude, sign);
        }

        @Specialization
        protected double doDouble(double magnitude, double sign) {
            return Math.copySign(magnitude, sign);
        }

        @Specialization
        protected LLVM80BitFloat doLLVM80BitFloat(LLVM80BitFloat magnitude, LLVM80BitFloat sign) {
            if (magnitude.getSign() != sign.getSign()) {
                return magnitude.negate();
            }
            return magnitude;
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMATan2
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value1, double value2) {
            return Math.atan2(value1, value2);
        }

        @Specialization
        protected float doIntrinsic(float value1, float value2) {
            return (float)Math.atan2(value1, value2);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMATan
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.atan(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.atan(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMTanh
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.tanh(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.tanh(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMTan
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.tan(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.tan(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMACos
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.acos(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.acos(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMCosh
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.cosh(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.cosh(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMCos
    extends LLVMBuiltin {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.cos(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.cos(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMASin
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.asin(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.asin(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMSinh
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.sinh(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.sinh(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMSin
    extends LLVMBuiltin {
        @Specialization
        protected double doIntrinsic(double value) {
            return Math.sin(value);
        }

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.sin(value);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMPow
    extends LLVMBuiltin {
        @Specialization
        protected float doFloat(float val, int pow) {
            return (float)Math.pow(val, pow);
        }

        @Specialization
        protected float doFloat(float val, float pow) {
            return (float)Math.pow(val, pow);
        }

        @Specialization
        protected double doDouble(double a, int b) {
            return Math.pow(a, b);
        }

        @Specialization
        protected double doDouble(double a, double b) {
            return Math.pow(a, b);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMFmod
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double numer, double denom) {
            return numer % denom;
        }

        @Specialization
        protected float doIntrinsic(float numer, float denom) {
            return numer % denom;
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMModf
    extends LLVMIntrinsic {
        @Specialization
        protected double doIntrinsic(double value, LLVMPointer integralAddr, @Cached LLVMDoubleStoreNode store) {
            double fractional = value % 1.0;
            double integral = value - fractional;
            store.executeWithTarget(integralAddr, integral);
            return fractional;
        }

        @Specialization
        protected float doIntrinsic(float value, LLVMPointer integralAddr, @Cached LLVMFloatStoreNode store) {
            float fractional = value % 1.0f;
            float integral = value - fractional;
            store.executeWithTarget(integralAddr, integral);
            return fractional;
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMLdexp
    extends LLVMIntrinsic {
        @Specialization
        protected float doIntrinsic(float value, int exp) {
            return value * (float)Math.pow(2.0, exp);
        }

        @Specialization
        protected double doIntrinsic(double value, int exp) {
            return value * Math.pow(2.0, exp);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMExp2
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.pow(2.0, value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.pow(2.0, value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMExpm1
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.expm1(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.expm1(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMExp
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.exp(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.exp(value);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMMaxnum
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value1, float value2) {
            if (Float.isNaN(value1)) {
                return value2;
            }
            if (Float.isNaN(value2)) {
                return value1;
            }
            return Math.max(value1, value2);
        }

        @Specialization
        protected double doIntrinsic(double value1, double value2) {
            if (Double.isNaN(value1)) {
                return value2;
            }
            if (Double.isNaN(value2)) {
                return value1;
            }
            return Math.max(value1, value2);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMMinnum
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value1, float value2) {
            if (Float.isNaN(value1)) {
                return value2;
            }
            if (Float.isNaN(value2)) {
                return value1;
            }
            return Math.min(value1, value2);
        }

        @Specialization
        protected double doIntrinsic(double value1, double value2) {
            if (Double.isNaN(value1)) {
                return value2;
            }
            if (Double.isNaN(value2)) {
                return value1;
            }
            return Math.min(value1, value2);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMFAbsVectorNode
    extends LLVMBuiltin {
        private final int vectorLength;

        LLVMFAbsVectorNode(int vectorLength) {
            this.vectorLength = vectorLength;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doVector(LLVMDoubleVector value) {
            assert (value.getLength() == this.vectorLength);
            double[] result = new double[this.vectorLength];
            for (int i = 0; i < this.vectorLength; ++i) {
                result[i] = Math.abs(value.getValue(i));
            }
            return LLVMDoubleVector.create(result);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doVector(LLVMFloatVector value) {
            assert (value.getLength() == this.vectorLength);
            float[] result = new float[this.vectorLength];
            for (int i = 0; i < this.vectorLength; ++i) {
                result[i] = Math.abs(value.getValue(i));
            }
            return LLVMFloatVector.create(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMFAbs
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return Math.abs(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.abs(value);
        }

        @Specialization
        protected LLVM80BitFloat doIntrinsic(LLVM80BitFloat value) {
            return value.abs();
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMAbs
    extends LLVMIntrinsic {
        @Specialization
        protected byte doByte(byte value) {
            return (byte)Math.abs(value);
        }

        @Specialization
        protected short doShort(short value) {
            return (short)Math.abs(value);
        }

        @Specialization
        protected int doInt(int value) {
            return Math.abs(value);
        }

        @Specialization
        protected long doLong(long value) {
            return Math.abs(value);
        }

        @Specialization
        protected LLVMNativePointer doNative(LLVMNativePointer value) {
            return LLVMNativePointer.create(this.doLong(value.asNative()));
        }

        @Specialization
        protected LLVMManagedPointer doManaged(LLVMManagedPointer value, @Cached ConditionProfile negated) {
            if (negated.profile(value.getObject() instanceof LLVMNegatedForeignObject)) {
                LLVMNegatedForeignObject obj = (LLVMNegatedForeignObject)value.getObject();
                assert (!(obj.getForeign() instanceof LLVMNegatedForeignObject));
                return LLVMManagedPointer.create(obj.getForeign(), -value.getOffset());
            }
            return value;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMRound
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return Math.round(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.round(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMFloor
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.floor(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.floor(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMCeil
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.ceil(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.ceil(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMRint
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.rint(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.rint(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMLog1p
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.log1p(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.log1p(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMLog10
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.log10(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.log10(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMLog2
    extends LLVMBuiltin {
        private static final double LOG_2 = Math.log(2.0);

        @Specialization
        protected float doIntrinsic(float value) {
            return (float)(Math.log(value) / LOG_2);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.log(value) / LOG_2;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMLog
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.log(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.log(value);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMSqrtVectorNode
    extends LLVMBuiltin {
        private final int vectorLength;

        LLVMSqrtVectorNode(int vectorLength) {
            this.vectorLength = vectorLength;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doVector(LLVMDoubleVector value) {
            assert (value.getLength() == this.vectorLength);
            double[] result = new double[this.vectorLength];
            for (int i = 0; i < this.vectorLength; ++i) {
                result[i] = Math.sqrt(value.getValue(i));
            }
            return LLVMDoubleVector.create(result);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doVector(LLVMFloatVector value) {
            assert (value.getLength() == this.vectorLength);
            float[] result = new float[this.vectorLength];
            for (int i = 0; i < this.vectorLength; ++i) {
                result[i] = (float)Math.sqrt(value.getValue(i));
            }
            return LLVMFloatVector.create(result);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMSqrt
    extends LLVMBuiltin {
        @Specialization
        protected float doIntrinsic(float value) {
            return (float)Math.sqrt(value);
        }

        @Specialization
        protected double doIntrinsic(double value) {
            return Math.sqrt(value);
        }
    }
}

