/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCatchSwitchNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMCatchSwitchNode.class)
public final class LLVMCatchSwitchNodeFactory {

    @GeneratedBy(value=LLVMCatchSwitchNode.CatchPadEntryNode.class)
    public static final class CatchPadEntryNodeGen
    extends LLVMCatchSwitchNode.CatchPadEntryNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode stack_;
        @Node.Child
        private LLVMExpressionNode thrownObject_;
        @Node.Child
        private LLVMExpressionNode throwInfo_;
        @Node.Child
        private LLVMExpressionNode imageBase_;
        @Node.Child
        private LLVMExpressionNode catchType_;
        @Node.Child
        private LLVMExpressionNode exceptionSlot_;
        @Node.Child
        private LLVMExpressionNode stackPointer_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private CatchPadEntryNodeGen(PointerType exceptionType, int attributes, LLVMExpressionNode stack, LLVMExpressionNode thrownObject, LLVMExpressionNode throwInfo, LLVMExpressionNode imageBase, LLVMExpressionNode catchType, LLVMExpressionNode exceptionSlot, LLVMExpressionNode stackPointer) {
            super(exceptionType, attributes);
            this.stack_ = stack;
            this.thrownObject_ = thrownObject;
            this.throwInfo_ = throwInfo;
            this.imageBase_ = imageBase;
            this.catchType_ = catchType;
            this.exceptionSlot_ = exceptionSlot;
            this.stackPointer_ = stackPointer;
        }

        @Override
        boolean execute(VirtualFrame frameValue, LLVMStack stackValue, LLVMPointer thrownObjectValue, LLVMPointer throwInfoValue, LLVMPointer imageBaseValue, long catchTypeValue) {
            int state_0 = this.state_0_;
            Object exceptionSlotValue_ = this.exceptionSlot_.executeGeneric(frameValue);
            Object stackPointerValue_ = this.stackPointer_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(stackValue, thrownObjectValue, throwInfoValue, imageBaseValue, catchTypeValue, exceptionSlotValue_, stackPointerValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(exceptionSlotValue_)) {
                LLVMPointer exceptionSlotValue__ = LLVMTypes.asPointer(exceptionSlotValue_);
                if (LLVMTypes.isPointer(stackPointerValue_)) {
                    LLVMPointer stackPointerValue__ = LLVMTypes.asPointer(stackPointerValue_);
                    return this.doExecute(stackValue, thrownObjectValue, throwInfoValue, imageBaseValue, catchTypeValue, exceptionSlotValue__, stackPointerValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(stackValue, thrownObjectValue, throwInfoValue, imageBaseValue, catchTypeValue, exceptionSlotValue_, stackPointerValue_);
        }

        private boolean executeAndSpecialize(Object stackValue, Object thrownObjectValue, Object throwInfoValue, Object imageBaseValue, Object catchTypeValue, Object exceptionSlotValue, Object stackPointerValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (stackValue instanceof LLVMStack) {
                LLVMStack stackValue_ = (LLVMStack)stackValue;
                if (LLVMTypes.isPointer(thrownObjectValue)) {
                    LLVMPointer thrownObjectValue_ = LLVMTypes.asPointer(thrownObjectValue);
                    if (LLVMTypes.isPointer(throwInfoValue)) {
                        LLVMPointer throwInfoValue_ = LLVMTypes.asPointer(throwInfoValue);
                        if (LLVMTypes.isPointer(imageBaseValue)) {
                            LLVMPointer imageBaseValue_ = LLVMTypes.asPointer(imageBaseValue);
                            if (catchTypeValue instanceof Long) {
                                long catchTypeValue_ = (Long)catchTypeValue;
                                if (LLVMTypes.isPointer(exceptionSlotValue)) {
                                    LLVMPointer exceptionSlotValue_ = LLVMTypes.asPointer(exceptionSlotValue);
                                    if (LLVMTypes.isPointer(stackPointerValue)) {
                                        LLVMPointer stackPointerValue_ = LLVMTypes.asPointer(stackPointerValue);
                                        this.state_0_ = state_0 |= 2;
                                        return this.doExecute(stackValue_, thrownObjectValue_, throwInfoValue_, imageBaseValue_, catchTypeValue_, exceptionSlotValue_, stackPointerValue_);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.stack_, this.thrownObject_, this.throwInfo_, this.imageBase_, this.catchType_, this.exceptionSlot_, this.stackPointer_}, new Object[]{stackValue, thrownObjectValue, throwInfoValue, imageBaseValue, catchTypeValue, exceptionSlotValue, stackPointerValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMCatchSwitchNode.CatchPadEntryNode create(PointerType exceptionType, int attributes, LLVMExpressionNode stack, LLVMExpressionNode thrownObject, LLVMExpressionNode throwInfo, LLVMExpressionNode imageBase, LLVMExpressionNode catchType, LLVMExpressionNode exceptionSlot, LLVMExpressionNode stackPointer) {
            return new CatchPadEntryNodeGen(exceptionType, attributes, stack, thrownObject, throwInfo, imageBase, catchType, exceptionSlot, stackPointer);
        }
    }

    @GeneratedBy(value=LLVMCatchSwitchNode.LLVMCatchSwitchImpl.class)
    public static final class LLVMCatchSwitchImplNodeGen
    extends LLVMCatchSwitchNode.LLVMCatchSwitchImpl
    implements GenerateAOT.Provider {
        private LLVMCatchSwitchImplNodeGen(int exceptionSlot, int[] targetBlocks, int unwindBlock, LLVMExpressionNode getStack, LLVMStatementNode[] phiNodes) {
            super(exceptionSlot, targetBlocks, unwindBlock, getStack, phiNodes);
        }

        @Override
        public Object executeCondition(VirtualFrame frameValue) {
            return this.doCondition(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMCatchSwitchNode.LLVMCatchSwitchImpl create(int exceptionSlot, int[] targetBlocks, int unwindBlock, LLVMExpressionNode getStack, LLVMStatementNode[] phiNodes) {
            return new LLVMCatchSwitchImplNodeGen(exceptionSlot, targetBlocks, unwindBlock, getStack, phiNodes);
        }
    }
}

