/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChild(value="value", type=LLVMExpressionNode.class)
@NodeField(name="slot", type=int.class)
public abstract class LLVMAMD64WriteAddressRegisterNode
extends LLVMStatementNode {
    public abstract int getSlot();

    @Specialization
    protected void doI8(VirtualFrame frame, byte value) {
        frame.getFrameDescriptor().setSlotKind(this.getSlot(), FrameSlotKind.Long);
        frame.setLong(this.getSlot(), (long)value);
    }

    @Specialization
    protected void doI16(VirtualFrame frame, short value) {
        frame.getFrameDescriptor().setSlotKind(this.getSlot(), FrameSlotKind.Long);
        frame.setLong(this.getSlot(), (long)value);
    }

    @Specialization
    protected void doI32(VirtualFrame frame, int value) {
        frame.getFrameDescriptor().setSlotKind(this.getSlot(), FrameSlotKind.Long);
        frame.setLong(this.getSlot(), (long)value);
    }

    @Specialization
    protected void doI64(VirtualFrame frame, long value) {
        frame.getFrameDescriptor().setSlotKind(this.getSlot(), FrameSlotKind.Long);
        frame.setLong(this.getSlot(), value);
    }

    @Specialization
    protected void doAddress(VirtualFrame frame, LLVMPointer value) {
        frame.getFrameDescriptor().setSlotKind(this.getSlot(), FrameSlotKind.Object);
        frame.setObject(this.getSlot(), (Object)value);
    }
}

