/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMAMD64RegisterToLongNode
extends LLVMNode {
    public abstract long execute(VirtualFrame var1, int var2);

    @Specialization(guards={"isLong(frame, slot)"})
    protected long readLong(VirtualFrame frame, int slot) {
        return frame.getLong(slot);
    }

    @Specialization(guards={"isAddress(frame, slot)"})
    protected long readAddress(VirtualFrame frame, int slot) {
        return LLVMNativePointer.cast(frame.getObject(slot)).asNative();
    }

    protected boolean isLong(VirtualFrame frame, int slot) {
        return frame.getFrameDescriptor().getSlotKind(slot) == FrameSlotKind.Long;
    }

    protected boolean isAddress(VirtualFrame frame, int slot) {
        return frame.getFrameDescriptor().getSlotKind(slot) == FrameSlotKind.Object;
    }
}

