/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteBooleanNode;

public abstract class LLVMAMD64StoreFlags
extends LLVMStatementNode {
    @Node.Child
    protected LLVMAMD64WriteBooleanNode cf;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode pf;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode af;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode zf;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode sf;

    public LLVMAMD64StoreFlags(LLVMAMD64WriteBooleanNode cf, LLVMAMD64WriteBooleanNode pf, LLVMAMD64WriteBooleanNode af, LLVMAMD64WriteBooleanNode zf, LLVMAMD64WriteBooleanNode sf) {
        this.cf = cf;
        this.pf = pf;
        this.af = af;
        this.zf = zf;
        this.sf = sf;
    }

    protected static boolean set(long value, long flag) {
        return (value & (long)(1 << (int)flag)) != 0L;
    }

    @NodeChild(value="flags", type=LLVMExpressionNode.class)
    public static abstract class LLVMAMD64WriteFlagswNode
    extends LLVMAMD64StoreFlags {
        @Node.Child
        protected LLVMAMD64WriteBooleanNode of;

        public LLVMAMD64WriteFlagswNode(LLVMAMD64WriteBooleanNode cf, LLVMAMD64WriteBooleanNode pf, LLVMAMD64WriteBooleanNode af, LLVMAMD64WriteBooleanNode zf, LLVMAMD64WriteBooleanNode sf, LLVMAMD64WriteBooleanNode of) {
            super(cf, pf, af, zf, sf);
            this.of = of;
        }

        @Specialization
        protected void doObject(VirtualFrame frame, short flags) {
            this.cf.execute(frame, LLVMAMD64WriteFlagswNode.set(flags, 0L));
            this.pf.execute(frame, LLVMAMD64WriteFlagswNode.set(flags, 2L));
            this.af.execute(frame, LLVMAMD64WriteFlagswNode.set(flags, 4L));
            this.zf.execute(frame, LLVMAMD64WriteFlagswNode.set(flags, 6L));
            this.sf.execute(frame, LLVMAMD64WriteFlagswNode.set(flags, 7L));
            this.of.execute(frame, LLVMAMD64WriteFlagswNode.set(flags, 11L));
        }
    }

    @NodeChild(value="flags", type=LLVMExpressionNode.class)
    public static abstract class LLVMAMD64SahfNode
    extends LLVMAMD64StoreFlags {
        public LLVMAMD64SahfNode(LLVMAMD64WriteBooleanNode cf, LLVMAMD64WriteBooleanNode pf, LLVMAMD64WriteBooleanNode af, LLVMAMD64WriteBooleanNode zf, LLVMAMD64WriteBooleanNode sf) {
            super(cf, pf, af, zf, sf);
        }

        @Specialization
        protected void doObject(VirtualFrame frame, byte flags) {
            this.cf.execute(frame, LLVMAMD64SahfNode.set(flags, 0L));
            this.pf.execute(frame, LLVMAMD64SahfNode.set(flags, 2L));
            this.af.execute(frame, LLVMAMD64SahfNode.set(flags, 4L));
            this.zf.execute(frame, LLVMAMD64SahfNode.set(flags, 6L));
            this.sf.execute(frame, LLVMAMD64SahfNode.set(flags, 7L));
        }
    }
}

