/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ContextThreadLocal;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;

public final class LLVMThreadingStack {
    private final long stackSize;
    private final Thread mainThread;
    @CompilerDirectives.CompilationFinal
    private LLVMStack mainThreadStack;

    public LLVMThreadingStack(Thread mainTread, long stackSize) {
        this.mainThread = mainTread;
        this.stackSize = stackSize;
    }

    public LLVMStack getStack(LLVMLanguage language) {
        LLVMStack s = LLVMThreadingStack.getCurrentStack(language);
        if (s == null) {
            s = this.createNewStack();
        }
        return s;
    }

    public LLVMStack getStack(Node node) {
        LLVMStack s = LLVMThreadingStack.getCurrentStack(node);
        if (s == null) {
            s = this.createNewStack();
        }
        return s;
    }

    public LLVMStack getStackProfiled(Thread thread, ConditionProfile profile, Node node) {
        if (profile.profile(thread == this.mainThread)) {
            assert (this.mainThreadStack != null);
            return this.mainThreadStack;
        }
        LLVMStack s = LLVMThreadingStack.getCurrentStack(node);
        if (s == null) {
            s = this.createNewStack();
        }
        return s;
    }

    private static LLVMStack getCurrentStack(Node node) {
        return ((LLVMLanguage.LLVMThreadLocalValue)LLVMLanguage.get((Node)node).contextThreadLocal.get()).getLLVMStack();
    }

    private static LLVMStack getCurrentStack(LLVMLanguage language) {
        return ((LLVMLanguage.LLVMThreadLocalValue)language.contextThreadLocal.get()).getLLVMStack();
    }

    @CompilerDirectives.TruffleBoundary
    private LLVMStack createNewStack() {
        LLVMStack s = new LLVMStack(this.stackSize, LLVMLanguage.getContext());
        Thread currentThread = Thread.currentThread();
        if (currentThread == this.mainThread) {
            this.mainThreadStack = s;
        }
        ((LLVMLanguage.LLVMThreadLocalValue)LLVMLanguage.get(null).contextThreadLocal.get()).setLLVMStack(s);
        return s;
    }

    @CompilerDirectives.TruffleBoundary
    public void freeStack(LLVMMemory memory, Thread thread) {
        if (this.mainThread != Thread.currentThread()) {
            LLVMThreadingStack.free(memory, thread);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void freeMainStack(LLVMMemory memory) {
        this.mainThreadStack = null;
        LLVMThreadingStack.free(memory, this.mainThread);
    }

    private static void free(LLVMMemory memory, Thread thread) {
        LLVMStack s;
        ContextThreadLocal<LLVMLanguage.LLVMThreadLocalValue> context = LLVMLanguage.get(null).contextThreadLocal;
        LLVMLanguage.LLVMThreadLocalValue value = (LLVMLanguage.LLVMThreadLocalValue)context.get(thread);
        if (value != null && (s = value.removeLLVMStack()) != null) {
            s.free(memory);
        }
    }
}

