/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.values;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.time.DateTimeException;
import java.time.ZoneId;

@CompilerDirectives.ValueType
@ExportLibrary(value=InteropLibrary.class)
public final class LLVMTimeZoneValue
implements TruffleObject {
    private final ZoneId zoneId;

    public LLVMTimeZoneValue(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public static LLVMTimeZoneValue ofString(String zone) throws DateTimeException {
        return new LLVMTimeZoneValue(ZoneId.of(zone));
    }

    @CompilerDirectives.TruffleBoundary
    public String getId() {
        return this.zoneId.getId();
    }

    @ExportMessage
    public ZoneId asTimeZone() {
        return this.zoneId;
    }

    @ExportMessage
    public static boolean isTimeZone(LLVMTimeZoneValue receiver) {
        return true;
    }
}

