/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.values;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotAsDateTimeNode;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;

@CompilerDirectives.ValueType
@ExportLibrary(value=InteropLibrary.class)
public final class LLVMInstantValue
implements TruffleObject {
    private final Instant instant;

    public LLVMInstantValue(Instant instant) {
        this.instant = instant;
    }

    public static LLVMInstantValue ofEpochSecond(long epochSecond) throws DateTimeException {
        return new LLVMInstantValue(Instant.ofEpochSecond(epochSecond));
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public LocalDate asDate() throws DateTimeException {
        return LocalDate.ofInstant(this.instant, LLVMInstantValue.asTimeZone(this));
    }

    @ExportMessage
    public static boolean isDate(LLVMInstantValue instant) {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public LocalTime asTime() {
        return LocalTime.ofInstant(this.instant, LLVMInstantValue.asTimeZone(this));
    }

    @ExportMessage
    public static boolean isTime(LLVMInstantValue instant) {
        return true;
    }

    @ExportMessage
    public static ZoneId asTimeZone(LLVMInstantValue instant) {
        return LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsTimeZoneNode.UTC;
    }

    @ExportMessage
    public static boolean isTimeZone(LLVMInstantValue instant) {
        return true;
    }

    @ExportMessage
    public Instant asInstant() {
        return this.instant;
    }
}

