/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNodeGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMAsForeignNode
extends LLVMNode {
    public abstract Object execute(VirtualFrame var1);

    public abstract Object execute(LLVMManagedPointer var1);

    public static LLVMAsForeignNode create() {
        return LLVMAsForeignNodeGen.StrictAsForeignNodeGen.create(null);
    }

    public static LLVMAsForeignNode getUncached() {
        return LLVMAsForeignNodeGen.StrictAsForeignNodeGen.getUncached();
    }

    public static LLVMAsForeignNode create(LLVMExpressionNode arg) {
        return LLVMAsForeignNodeGen.StrictAsForeignNodeGen.create(arg);
    }

    public static LLVMAsForeignNode createOptional() {
        return LLVMAsForeignNodeGen.OptionalAsForeignNodeGen.create(null);
    }

    @Specialization(guards={"foreigns.isForeign(pointer)"})
    Object doForeign(Object pointer, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns) {
        return foreigns.asForeign(pointer);
    }

    @GenerateUncached
    static abstract class StrictAsForeignNode
    extends LLVMAsForeignNode {
        StrictAsForeignNode() {
        }

        @Fallback
        Object doFail(Object pointer) {
            throw new LLVMPolyglotException(this, "Pointer does not point to a polyglot value");
        }
    }

    static abstract class OptionalAsForeignNode
    extends LLVMAsForeignNode {
        OptionalAsForeignNode() {
        }

        @Fallback
        Object doNonForeign(Object pointer) {
            return null;
        }
    }
}

