/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.instruments.trace;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import java.util.Arrays;

final class LLVMTraceNodeFactory
implements ExecutionEventNodeFactory {
    LLVMTraceNodeFactory() {
    }

    public ExecutionEventNode create(EventContext eventContext) {
        CompilerAsserts.neverPartOfCompilation();
        if (eventContext.hasTag(StandardTags.RootTag.class)) {
            assert (eventContext.getInstrumentedNode() != null);
            RootNode rootNode = eventContext.getInstrumentedNode().getRootNode();
            assert (rootNode != null);
            SourceSection sourceSection = rootNode.getSourceSection();
            return new RootTrace(rootNode.getName(), LLVMTraceNodeFactory.toTraceLine(sourceSection, false));
        }
        if (eventContext.hasTag(StandardTags.StatementTag.class)) {
            return new StatementTrace(LLVMTraceNodeFactory.toTraceLine(eventContext.getInstrumentedSourceSection(), true));
        }
        throw new IllegalStateException("Unknown node for tracing: " + eventContext.getInstrumentedNode());
    }

    @CompilerDirectives.TruffleBoundary
    private static String toTraceLine(SourceSection sourceSection, boolean includeText) {
        StringBuilder builder = new StringBuilder();
        builder.append(sourceSection.getSource().getName());
        if (sourceSection.hasLines()) {
            builder.append(':');
            builder.append(sourceSection.getStartLine());
        } else {
            builder.append(":?");
        }
        if (includeText && sourceSection.hasCharIndex() && sourceSection.getCharLength() > 0) {
            builder.append(" -> ");
            builder.append(sourceSection.getCharacters());
        }
        return builder.toString();
    }

    private static final class RootTrace
    extends TraceNode {
        private final String enterPrefix;
        private final String exitPrefix;
        private final String exceptionPrefix;

        @CompilerDirectives.TruffleBoundary
        RootTrace(String functionName, String sourceSection) {
            this.enterPrefix = String.format("Entering function %s at %s with arguments: ", functionName, sourceSection);
            this.exitPrefix = "Leaving " + functionName;
            this.exceptionPrefix = "Exceptionally leaving " + functionName;
        }

        @CompilerDirectives.TruffleBoundary
        private void traceFunctionArgs(Object[] arguments) {
            RootTrace.trace(this.enterPrefix + Arrays.toString(arguments));
        }

        protected void onEnter(VirtualFrame frame) {
            this.traceFunctionArgs(frame.getArguments());
        }

        protected void onReturnValue(VirtualFrame frame, Object result) {
            RootTrace.trace(this.exitPrefix);
        }

        protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
            RootTrace.trace(this.exceptionPrefix);
        }
    }

    private static final class StatementTrace
    extends TraceNode {
        private final String location;

        StatementTrace(String location) {
            this.location = location;
        }

        protected void onEnter(VirtualFrame frame) {
            StatementTrace.trace(this.location);
        }
    }

    private static abstract class TraceNode
    extends ExecutionEventNode {
        TraceNode() {
        }

        @CompilerDirectives.TruffleBoundary
        static void trace(String message) {
            LLVMContext.traceIRLog(String.format("(Thread #%d) %s", Thread.currentThread().getId(), message));
        }
    }
}

