/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.global;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.provider.EagerExportProvider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObjectGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMGlobalContainer.class)
public final class LLVMGlobalContainerGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private LLVMGlobalContainerGen() {
    }

    private static void init() {
    }

    static {
        LibraryExport.register(LLVMGlobalContainer.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new LLVMManagedReadLibraryExports(), new LLVMManagedWriteLibraryExports(), new LLVMAsForeignLibraryExports()});
    }

    @GeneratedBy(value=LLVMGlobalContainer.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMGlobalContainer.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMInternalTruffleObjectGen.InteropLibraryExports.Uncached {
            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).isPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).asPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public void toNative(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((LLVMGlobalContainer)receiver).toNative();
            }
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Cached
        extends LLVMInternalTruffleObjectGen.InteropLibraryExports.Cached {
            protected Cached(Object receiver) {
                super(receiver);
            }

            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).isPointer();
            }

            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).asPointer();
            }

            public void toNative(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((LLVMGlobalContainer)receiver).toNative();
            }
        }
    }

    @GeneratedBy(value=LLVMGlobalContainer.class)
    private static final class LLVMManagedReadLibraryExports
    extends LibraryExport<LLVMManagedReadLibrary> {
        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, LLVMGlobalContainer.class, false, true, 1);
        }

        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected LLVMManagedReadLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer || receiver instanceof LibraryExport);
            return new Cached();
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMManagedReadLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                return LLVMGlobalContainer.ReadI8.readManaged(arg0Value, arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readI16(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                return LLVMGlobalContainer.ReadI16.readManaged(arg0Value, arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readI32(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                return LLVMGlobalContainer.ReadI32.readManaged(arg0Value, arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                return LLVMGlobalContainer.ReadFloat.readManaged(arg0Value, arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                return LLVMGlobalContainer.ReadDouble.readManaged(arg0Value, arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadGenericI64.readNative(arg0Value, arg1Value, this);
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    return LLVMGlobalContainer.ReadGenericI64.readI64Managed(arg0Value, arg1Value);
                }
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    return LLVMGlobalContainer.ReadGenericI64.readFallback(arg0Value, arg1Value, this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadPointer.readNative(arg0Value, arg1Value, this);
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    return LLVMGlobalContainer.ReadPointer.readManaged(arg0Value, arg1Value, LLVMToPointerNodeGen.getUncached());
                }
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    return LLVMGlobalContainer.ReadPointer.readFallback(arg0Value, arg1Value, this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isReadable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).isAccessible();
            }
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Cached
        extends LLVMManagedReadLibrary
        implements GenerateAOT.Provider {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private LLVMToPointerNode toPointer;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            @Override
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.readI8AndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 6) != 0) {
                    if ((state_0 & 2) != 0 && arg0Value.isPointer()) {
                        Cached location__ = this;
                        return LLVMGlobalContainer.ReadI8.readNative(arg0Value, arg1Value, location__);
                    }
                    if ((state_0 & 4) != 0) {
                        Cached location__1 = this;
                        return LLVMGlobalContainer.ReadI8.readManaged(arg0Value, arg1Value, location__1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI8AndSpecialize(arg0Value, arg1Value);
            }

            private byte readI8AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                Cached location__ = null;
                if ((state_0 & 4) == 0 && arg0Value.isPointer()) {
                    location__ = this;
                    this.state_0_ = state_0 |= 2;
                    return LLVMGlobalContainer.ReadI8.readNative(arg0Value, arg1Value, location__);
                }
                Cached location__1 = null;
                location__1 = this;
                state_0 &= 0xFFFFFFFD;
                this.state_0_ = state_0 |= 4;
                return LLVMGlobalContainer.ReadI8.readManaged(arg0Value, arg1Value, location__1);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 6) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                LLVMToPointerNode toPointer_;
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ &= 0xFFFFFFFD;
                this.state_0_ |= 4;
                this.state_0_ |= 0x10;
                this.state_0_ |= 0x40;
                this.state_0_ |= 0x100;
                this.state_0_ |= 0x400;
                this.state_0_ |= 0x800;
                this.state_0_ |= 0x2000;
                this.state_0_ |= 0x4000;
                this.state_0_ |= 0x8000;
                LLVMToPointerNode toPointer__shared = this.toPointer;
                if (toPointer__shared != null) {
                    toPointer_ = toPointer__shared;
                } else {
                    toPointer_ = (LLVMToPointerNode)this.insert(LLVMToPointerNodeGen.create());
                    if (toPointer_ == null) {
                        throw new IllegalStateException("Specialization 'readManaged(LLVMGlobalContainer, long, LLVMToPointerNode)' contains a shared cache with name 'toPointer' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.toPointer == null) {
                    VarHandle.storeStoreFence();
                    this.toPointer = toPointer_;
                }
                assert (NodeUtil.assertRecursion((Node)this.toPointer, (int)1));
                ((GenerateAOT.Provider)this.toPointer).prepareForAOT(language, root);
                this.state_0_ |= 0x20000;
                this.state_0_ |= 0x40000;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
                this.toPointer = null;
            }

            @Override
            public short readI16(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.readI16AndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x18) != 0) {
                    if ((state_0 & 8) != 0 && arg0Value.isPointer()) {
                        Cached location__ = this;
                        return LLVMGlobalContainer.ReadI16.readNative(arg0Value, arg1Value, location__);
                    }
                    if ((state_0 & 0x10) != 0) {
                        Cached location__1 = this;
                        return LLVMGlobalContainer.ReadI16.readManaged(arg0Value, arg1Value, location__1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI16AndSpecialize(arg0Value, arg1Value);
            }

            private short readI16AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                Cached location__ = null;
                if ((state_0 & 0x10) == 0 && arg0Value.isPointer()) {
                    location__ = this;
                    this.state_0_ = state_0 |= 8;
                    return LLVMGlobalContainer.ReadI16.readNative(arg0Value, arg1Value, location__);
                }
                Cached location__1 = null;
                location__1 = this;
                state_0 &= 0xFFFFFFF7;
                this.state_0_ = state_0 |= 0x10;
                return LLVMGlobalContainer.ReadI16.readManaged(arg0Value, arg1Value, location__1);
            }

            @Override
            public int readI32(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.readI32AndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x60) != 0) {
                    if ((state_0 & 0x20) != 0 && arg0Value.isPointer()) {
                        Cached location__ = this;
                        return LLVMGlobalContainer.ReadI32.readNative(arg0Value, arg1Value, location__);
                    }
                    if ((state_0 & 0x40) != 0) {
                        Cached location__1 = this;
                        return LLVMGlobalContainer.ReadI32.readManaged(arg0Value, arg1Value, location__1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI32AndSpecialize(arg0Value, arg1Value);
            }

            private int readI32AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                Cached location__ = null;
                if ((state_0 & 0x40) == 0 && arg0Value.isPointer()) {
                    location__ = this;
                    this.state_0_ = state_0 |= 0x20;
                    return LLVMGlobalContainer.ReadI32.readNative(arg0Value, arg1Value, location__);
                }
                Cached location__1 = null;
                location__1 = this;
                state_0 &= 0xFFFFFFDF;
                this.state_0_ = state_0 |= 0x40;
                return LLVMGlobalContainer.ReadI32.readManaged(arg0Value, arg1Value, location__1);
            }

            @Override
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.readFloatAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x180) != 0) {
                    if ((state_0 & 0x80) != 0 && arg0Value.isPointer()) {
                        Cached location__ = this;
                        return LLVMGlobalContainer.ReadFloat.readNative(arg0Value, arg1Value, location__);
                    }
                    if ((state_0 & 0x100) != 0) {
                        Cached location__1 = this;
                        return LLVMGlobalContainer.ReadFloat.readManaged(arg0Value, arg1Value, location__1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readFloatAndSpecialize(arg0Value, arg1Value);
            }

            private float readFloatAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                Cached location__ = null;
                if ((state_0 & 0x100) == 0 && arg0Value.isPointer()) {
                    location__ = this;
                    this.state_0_ = state_0 |= 0x80;
                    return LLVMGlobalContainer.ReadFloat.readNative(arg0Value, arg1Value, location__);
                }
                Cached location__1 = null;
                location__1 = this;
                state_0 &= 0xFFFFFF7F;
                this.state_0_ = state_0 |= 0x100;
                return LLVMGlobalContainer.ReadFloat.readManaged(arg0Value, arg1Value, location__1);
            }

            @Override
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.readDoubleAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x600) != 0) {
                    if ((state_0 & 0x200) != 0 && arg0Value.isPointer()) {
                        Cached location__ = this;
                        return LLVMGlobalContainer.ReadDouble.readNative(arg0Value, arg1Value, location__);
                    }
                    if ((state_0 & 0x400) != 0) {
                        Cached location__1 = this;
                        return LLVMGlobalContainer.ReadDouble.readManaged(arg0Value, arg1Value, location__1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readDoubleAndSpecialize(arg0Value, arg1Value);
            }

            private double readDoubleAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                Cached location__ = null;
                if ((state_0 & 0x400) == 0 && arg0Value.isPointer()) {
                    location__ = this;
                    this.state_0_ = state_0 |= 0x200;
                    return LLVMGlobalContainer.ReadDouble.readNative(arg0Value, arg1Value, location__);
                }
                Cached location__1 = null;
                location__1 = this;
                state_0 &= 0xFFFFFDFF;
                this.state_0_ = state_0 |= 0x400;
                return LLVMGlobalContainer.ReadDouble.readManaged(arg0Value, arg1Value, location__1);
            }

            @Override
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.readGenericI64AndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x7800) != 0) {
                    if ((state_0 & 0x800) != 0 && arg0Value.isPointer()) {
                        Cached location__ = this;
                        return LLVMGlobalContainer.ReadGenericI64.readNative(arg0Value, arg1Value, location__);
                    }
                    if ((state_0 & 0x1000) != 0) {
                        assert (DSLSupport.assertIdempotence((boolean)LLVMLanguage.isSingleContext((Node)this)));
                        if (!arg0Value.isPointer() && arg1Value == 0L) {
                            return LLVMGlobalContainer.ReadGenericI64.readI64ManagedSingleContext(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0x2000) != 0 && !arg0Value.isPointer() && arg1Value == 0L) {
                        return LLVMGlobalContainer.ReadGenericI64.readI64Managed(arg0Value, arg1Value);
                    }
                    if ((state_0 & 0x4000) != 0 && !arg0Value.isPointer() && arg1Value != 0L) {
                        Cached location__1 = this;
                        return LLVMGlobalContainer.ReadGenericI64.readFallback(arg0Value, arg1Value, location__1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readGenericI64AndSpecialize(arg0Value, arg1Value);
            }

            private Object readGenericI64AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                Cached location__ = null;
                if (arg0Value.isPointer()) {
                    location__ = this;
                    this.state_0_ = state_0 |= 0x800;
                    return LLVMGlobalContainer.ReadGenericI64.readNative(arg0Value, arg1Value, location__);
                }
                if ((state_0 & 0x2000) == 0 && LLVMLanguage.isSingleContext((Node)this) && !arg0Value.isPointer() && arg1Value == 0L) {
                    this.state_0_ = state_0 |= 0x1000;
                    return LLVMGlobalContainer.ReadGenericI64.readI64ManagedSingleContext(arg0Value, arg1Value);
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    state_0 &= 0xFFFFEFFF;
                    this.state_0_ = state_0 |= 0x2000;
                    return LLVMGlobalContainer.ReadGenericI64.readI64Managed(arg0Value, arg1Value);
                }
                Cached location__1 = null;
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    location__1 = this;
                    this.state_0_ = state_0 |= 0x4000;
                    return LLVMGlobalContainer.ReadGenericI64.readFallback(arg0Value, arg1Value, location__1);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.readPointerAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x78000) != 0) {
                    LLVMToPointerNode toPointer_1;
                    LLVMToPointerNode toPointer_;
                    if ((state_0 & 0x8000) != 0 && arg0Value.isPointer()) {
                        Cached location__ = this;
                        return LLVMGlobalContainer.ReadPointer.readNative(arg0Value, arg1Value, location__);
                    }
                    if ((state_0 & 0x10000) != 0 && (toPointer_ = this.toPointer) != null) {
                        assert (DSLSupport.assertIdempotence((boolean)LLVMLanguage.isSingleContext((Node)this)));
                        if (!arg0Value.isPointer() && arg1Value == 0L) {
                            return LLVMGlobalContainer.ReadPointer.readManagedSingleContext(arg0Value, arg1Value, toPointer_);
                        }
                    }
                    if ((state_0 & 0x20000) != 0 && (toPointer_1 = this.toPointer) != null && !arg0Value.isPointer() && arg1Value == 0L) {
                        return LLVMGlobalContainer.ReadPointer.readManaged(arg0Value, arg1Value, toPointer_1);
                    }
                    if ((state_0 & 0x40000) != 0 && !arg0Value.isPointer() && arg1Value != 0L) {
                        Cached location__1 = this;
                        return LLVMGlobalContainer.ReadPointer.readFallback(arg0Value, arg1Value, location__1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readPointerAndSpecialize(arg0Value, arg1Value);
            }

            private LLVMPointer readPointerAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                Cached location__ = null;
                if (arg0Value.isPointer()) {
                    location__ = this;
                    this.state_0_ = state_0 |= 0x8000;
                    return LLVMGlobalContainer.ReadPointer.readNative(arg0Value, arg1Value, location__);
                }
                if ((state_0 & 0x20000) == 0 && LLVMLanguage.isSingleContext((Node)this) && !arg0Value.isPointer() && arg1Value == 0L) {
                    LLVMToPointerNode toPointer_;
                    LLVMToPointerNode toPointer__shared = this.toPointer;
                    if (toPointer__shared != null) {
                        toPointer_ = toPointer__shared;
                    } else {
                        toPointer_ = (LLVMToPointerNode)this.insert(LLVMToPointerNodeGen.create());
                        if (toPointer_ == null) {
                            throw new IllegalStateException("Specialization 'readManagedSingleContext(LLVMGlobalContainer, long, LLVMToPointerNode)' contains a shared cache with name 'toPointer' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.toPointer == null) {
                        VarHandle.storeStoreFence();
                        this.toPointer = toPointer_;
                    }
                    this.state_0_ = state_0 |= 0x10000;
                    return LLVMGlobalContainer.ReadPointer.readManagedSingleContext(arg0Value, arg1Value, toPointer_);
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    LLVMToPointerNode toPointer_1;
                    LLVMToPointerNode toPointer_1_shared = this.toPointer;
                    if (toPointer_1_shared != null) {
                        toPointer_1 = toPointer_1_shared;
                    } else {
                        toPointer_1 = (LLVMToPointerNode)this.insert(LLVMToPointerNodeGen.create());
                        if (toPointer_1 == null) {
                            throw new IllegalStateException("Specialization 'readManaged(LLVMGlobalContainer, long, LLVMToPointerNode)' contains a shared cache with name 'toPointer' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.toPointer == null) {
                        VarHandle.storeStoreFence();
                        this.toPointer = toPointer_1;
                    }
                    state_0 &= 0xFFFEFFFF;
                    this.state_0_ = state_0 |= 0x20000;
                    return LLVMGlobalContainer.ReadPointer.readManaged(arg0Value, arg1Value, toPointer_1);
                }
                Cached location__1 = null;
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    location__1 = this;
                    this.state_0_ = state_0 |= 0x40000;
                    return LLVMGlobalContainer.ReadPointer.readFallback(arg0Value, arg1Value, location__1);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            public boolean isReadable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                return ((LLVMGlobalContainer)receiver).isAccessible();
            }
        }
    }

    @GeneratedBy(value=LLVMGlobalContainer.class)
    private static final class LLVMManagedWriteLibraryExports
    extends LibraryExport<LLVMManagedWriteLibrary> {
        private LLVMManagedWriteLibraryExports() {
            super(LLVMManagedWriteLibrary.class, LLVMGlobalContainer.class, false, true, 2);
        }

        protected LLVMManagedWriteLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected LLVMManagedWriteLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer || receiver instanceof LibraryExport);
            return new Cached();
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMManagedWriteLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                LLVMGlobalContainer.WriteI8.writeManaged(arg0Value, arg1Value, arg2Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                LLVMGlobalContainer.WriteI16.writeManaged(arg0Value, arg1Value, arg2Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                LLVMGlobalContainer.WriteI32.writeManaged(arg0Value, arg1Value, arg2Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                LLVMGlobalContainer.WriteFloat.writeManaged(arg0Value, arg1Value, arg2Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                LLVMGlobalContainer.WriteDouble.writeManaged(arg0Value, arg1Value, arg2Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI64.writeNative(arg0Value, arg1Value, arg2Value, this);
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    LLVMGlobalContainer.WriteI64.writeManaged(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    LLVMGlobalContainer.WriteI64.writeFallback(arg0Value, arg1Value, arg2Value, this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, LLVMNativePointerSupportFactory.ToNativePointerNodeGen.getUncached());
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    LLVMGlobalContainer.WriteGenericI64.writeI64Managed(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    LLVMGlobalContainer.WriteGenericI64.writeFallback(arg0Value, arg1Value, arg2Value, LLVMNativePointerSupportFactory.ToNativePointerNodeGen.getUncached());
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isWritable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).isAccessible();
            }
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Cached
        extends LLVMManagedWriteLibrary
        implements GenerateAOT.Provider {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private LLVMNativePointerSupport.ToNativePointerNode toNative;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            @Override
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    this.writeI8AndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 6) != 0) {
                    if ((state_0 & 2) != 0 && arg0Value.isPointer()) {
                        Cached location__ = this;
                        LLVMGlobalContainer.WriteI8.writeNative(arg0Value, arg1Value, arg2Value, location__);
                        return;
                    }
                    if ((state_0 & 4) != 0) {
                        Cached location__1 = this;
                        LLVMGlobalContainer.WriteI8.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI8AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI8AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, byte arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                Cached location__ = null;
                if ((state_0 & 4) == 0 && arg0Value.isPointer()) {
                    location__ = this;
                    this.state_0_ = state_0 |= 2;
                    LLVMGlobalContainer.WriteI8.writeNative(arg0Value, arg1Value, arg2Value, location__);
                    return;
                }
                Cached location__1 = null;
                location__1 = this;
                state_0 &= 0xFFFFFFFD;
                this.state_0_ = state_0 |= 4;
                LLVMGlobalContainer.WriteI8.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 6) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                LLVMNativePointerSupport.ToNativePointerNode toNative_;
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ &= 0xFFFFFFFD;
                this.state_0_ |= 4;
                this.state_0_ |= 0x10;
                this.state_0_ |= 0x40;
                this.state_0_ |= 0x100;
                this.state_0_ |= 0x400;
                this.state_0_ |= 0x800;
                this.state_0_ |= 0x2000;
                this.state_0_ |= 0x4000;
                LLVMNativePointerSupport.ToNativePointerNode toNative__shared = this.toNative;
                if (toNative__shared != null) {
                    toNative_ = toNative__shared;
                } else {
                    toNative_ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                    if (toNative_ == null) {
                        throw new IllegalStateException("Specialization 'writeNative(LLVMGlobalContainer, long, Object, ToNativePointerNode)' contains a shared cache with name 'toNative' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.toNative == null) {
                    VarHandle.storeStoreFence();
                    this.toNative = toNative_;
                }
                assert (NodeUtil.assertRecursion((Node)this.toNative, (int)1));
                ((GenerateAOT.Provider)this.toNative).prepareForAOT(language, root);
                this.state_0_ |= 0x8000;
                this.state_0_ |= 0x20000;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
                this.toNative = null;
            }

            @Override
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    this.writeI16AndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0x18) != 0) {
                    if ((state_0 & 8) != 0 && arg0Value.isPointer()) {
                        Cached location__ = this;
                        LLVMGlobalContainer.WriteI16.writeNative(arg0Value, arg1Value, arg2Value, location__);
                        return;
                    }
                    if ((state_0 & 0x10) != 0) {
                        Cached location__1 = this;
                        LLVMGlobalContainer.WriteI16.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI16AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI16AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, short arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                Cached location__ = null;
                if ((state_0 & 0x10) == 0 && arg0Value.isPointer()) {
                    location__ = this;
                    this.state_0_ = state_0 |= 8;
                    LLVMGlobalContainer.WriteI16.writeNative(arg0Value, arg1Value, arg2Value, location__);
                    return;
                }
                Cached location__1 = null;
                location__1 = this;
                state_0 &= 0xFFFFFFF7;
                this.state_0_ = state_0 |= 0x10;
                LLVMGlobalContainer.WriteI16.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
            }

            @Override
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    this.writeI32AndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0x60) != 0) {
                    if ((state_0 & 0x20) != 0 && arg0Value.isPointer()) {
                        Cached location__ = this;
                        LLVMGlobalContainer.WriteI32.writeNative(arg0Value, arg1Value, arg2Value, location__);
                        return;
                    }
                    if ((state_0 & 0x40) != 0) {
                        Cached location__1 = this;
                        LLVMGlobalContainer.WriteI32.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI32AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI32AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, int arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                Cached location__ = null;
                if ((state_0 & 0x40) == 0 && arg0Value.isPointer()) {
                    location__ = this;
                    this.state_0_ = state_0 |= 0x20;
                    LLVMGlobalContainer.WriteI32.writeNative(arg0Value, arg1Value, arg2Value, location__);
                    return;
                }
                Cached location__1 = null;
                location__1 = this;
                state_0 &= 0xFFFFFFDF;
                this.state_0_ = state_0 |= 0x40;
                LLVMGlobalContainer.WriteI32.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
            }

            @Override
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    this.writeFloatAndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0x180) != 0) {
                    if ((state_0 & 0x80) != 0 && arg0Value.isPointer()) {
                        Cached location__ = this;
                        LLVMGlobalContainer.WriteFloat.writeNative(arg0Value, arg1Value, arg2Value, location__);
                        return;
                    }
                    if ((state_0 & 0x100) != 0) {
                        Cached location__1 = this;
                        LLVMGlobalContainer.WriteFloat.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeFloatAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeFloatAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, float arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                Cached location__ = null;
                if ((state_0 & 0x100) == 0 && arg0Value.isPointer()) {
                    location__ = this;
                    this.state_0_ = state_0 |= 0x80;
                    LLVMGlobalContainer.WriteFloat.writeNative(arg0Value, arg1Value, arg2Value, location__);
                    return;
                }
                Cached location__1 = null;
                location__1 = this;
                state_0 &= 0xFFFFFF7F;
                this.state_0_ = state_0 |= 0x100;
                LLVMGlobalContainer.WriteFloat.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
            }

            @Override
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    this.writeDoubleAndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0x600) != 0) {
                    if ((state_0 & 0x200) != 0 && arg0Value.isPointer()) {
                        Cached location__ = this;
                        LLVMGlobalContainer.WriteDouble.writeNative(arg0Value, arg1Value, arg2Value, location__);
                        return;
                    }
                    if ((state_0 & 0x400) != 0) {
                        Cached location__1 = this;
                        LLVMGlobalContainer.WriteDouble.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeDoubleAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeDoubleAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, double arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                Cached location__ = null;
                if ((state_0 & 0x400) == 0 && arg0Value.isPointer()) {
                    location__ = this;
                    this.state_0_ = state_0 |= 0x200;
                    LLVMGlobalContainer.WriteDouble.writeNative(arg0Value, arg1Value, arg2Value, location__);
                    return;
                }
                Cached location__1 = null;
                location__1 = this;
                state_0 &= 0xFFFFFDFF;
                this.state_0_ = state_0 |= 0x400;
                LLVMGlobalContainer.WriteDouble.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
            }

            @Override
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    this.writeI64AndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0x7800) != 0) {
                    if ((state_0 & 0x800) != 0 && arg0Value.isPointer()) {
                        Cached location__ = this;
                        LLVMGlobalContainer.WriteI64.writeNative(arg0Value, arg1Value, arg2Value, location__);
                        return;
                    }
                    if ((state_0 & 0x1000) != 0) {
                        assert (DSLSupport.assertIdempotence((boolean)LLVMLanguage.isSingleContext((Node)this)));
                        if (!arg0Value.isPointer() && arg1Value == 0L) {
                            LLVMGlobalContainer.WriteI64.writeManagedSingleContext(arg0Value, arg1Value, arg2Value);
                            return;
                        }
                    }
                    if ((state_0 & 0x2000) != 0 && !arg0Value.isPointer() && arg1Value == 0L) {
                        LLVMGlobalContainer.WriteI64.writeManaged(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                    if ((state_0 & 0x4000) != 0 && !arg0Value.isPointer() && arg1Value != 0L) {
                        Cached location__1 = this;
                        LLVMGlobalContainer.WriteI64.writeFallback(arg0Value, arg1Value, arg2Value, location__1);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI64AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI64AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, long arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                Cached location__ = null;
                if (arg0Value.isPointer()) {
                    location__ = this;
                    this.state_0_ = state_0 |= 0x800;
                    LLVMGlobalContainer.WriteI64.writeNative(arg0Value, arg1Value, arg2Value, location__);
                    return;
                }
                if ((state_0 & 0x2000) == 0 && LLVMLanguage.isSingleContext((Node)this) && !arg0Value.isPointer() && arg1Value == 0L) {
                    this.state_0_ = state_0 |= 0x1000;
                    LLVMGlobalContainer.WriteI64.writeManagedSingleContext(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    state_0 &= 0xFFFFEFFF;
                    this.state_0_ = state_0 |= 0x2000;
                    LLVMGlobalContainer.WriteI64.writeManaged(arg0Value, arg1Value, arg2Value);
                    return;
                }
                Cached location__1 = null;
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    location__1 = this;
                    this.state_0_ = state_0 |= 0x4000;
                    LLVMGlobalContainer.WriteI64.writeFallback(arg0Value, arg1Value, arg2Value, location__1);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    this.writeGenericI64AndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0x78000) != 0) {
                    LLVMNativePointerSupport.ToNativePointerNode toNative_1;
                    LLVMNativePointerSupport.ToNativePointerNode toNative_;
                    if ((state_0 & 0x8000) != 0 && (toNative_ = this.toNative) != null && arg0Value.isPointer()) {
                        LLVMGlobalContainer.WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, toNative_);
                        return;
                    }
                    if ((state_0 & 0x10000) != 0) {
                        assert (DSLSupport.assertIdempotence((boolean)LLVMLanguage.isSingleContext((Node)this)));
                        if (!arg0Value.isPointer() && arg1Value == 0L) {
                            LLVMGlobalContainer.WriteGenericI64.writeI64ManagedSingleContext(arg0Value, arg1Value, arg2Value);
                            return;
                        }
                    }
                    if ((state_0 & 0x20000) != 0 && !arg0Value.isPointer() && arg1Value == 0L) {
                        LLVMGlobalContainer.WriteGenericI64.writeI64Managed(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                    if ((state_0 & 0x40000) != 0 && (toNative_1 = this.toNative) != null && !arg0Value.isPointer() && arg1Value != 0L) {
                        LLVMGlobalContainer.WriteGenericI64.writeFallback(arg0Value, arg1Value, arg2Value, toNative_1);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeGenericI64AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeGenericI64AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg0Value.isPointer()) {
                    LLVMNativePointerSupport.ToNativePointerNode toNative_;
                    LLVMNativePointerSupport.ToNativePointerNode toNative__shared = this.toNative;
                    if (toNative__shared != null) {
                        toNative_ = toNative__shared;
                    } else {
                        toNative_ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                        if (toNative_ == null) {
                            throw new IllegalStateException("Specialization 'writeNative(LLVMGlobalContainer, long, Object, ToNativePointerNode)' contains a shared cache with name 'toNative' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.toNative == null) {
                        VarHandle.storeStoreFence();
                        this.toNative = toNative_;
                    }
                    this.state_0_ = state_0 |= 0x8000;
                    LLVMGlobalContainer.WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, toNative_);
                    return;
                }
                if ((state_0 & 0x20000) == 0 && LLVMLanguage.isSingleContext((Node)this) && !arg0Value.isPointer() && arg1Value == 0L) {
                    this.state_0_ = state_0 |= 0x10000;
                    LLVMGlobalContainer.WriteGenericI64.writeI64ManagedSingleContext(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    state_0 &= 0xFFFEFFFF;
                    this.state_0_ = state_0 |= 0x20000;
                    LLVMGlobalContainer.WriteGenericI64.writeI64Managed(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    LLVMNativePointerSupport.ToNativePointerNode toNative_1;
                    LLVMNativePointerSupport.ToNativePointerNode toNative_1_shared = this.toNative;
                    if (toNative_1_shared != null) {
                        toNative_1 = toNative_1_shared;
                    } else {
                        toNative_1 = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                        if (toNative_1 == null) {
                            throw new IllegalStateException("Specialization 'writeFallback(LLVMGlobalContainer, long, Object, ToNativePointerNode)' contains a shared cache with name 'toNative' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.toNative == null) {
                        VarHandle.storeStoreFence();
                        this.toNative = toNative_1;
                    }
                    this.state_0_ = state_0 |= 0x40000;
                    LLVMGlobalContainer.WriteGenericI64.writeFallback(arg0Value, arg1Value, arg2Value, toNative_1);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            public boolean isWritable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                return ((LLVMGlobalContainer)receiver).isAccessible();
            }
        }
    }

    @GeneratedBy(value=LLVMGlobalContainer.class)
    private static final class LLVMAsForeignLibraryExports
    extends LibraryExport<LLVMAsForeignLibrary> {
        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private LLVMAsForeignLibraryExports() {
            super(LLVMAsForeignLibrary.class, LLVMGlobalContainer.class, false, true, 3);
        }

        protected LLVMAsForeignLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            Uncached uncached = UNCACHED;
            return uncached;
        }

        protected LLVMAsForeignLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer || receiver instanceof LibraryExport);
            return CACHE;
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMAsForeignLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMGlobalContainer.isForeign((LLVMGlobalContainer)receiver);
            }
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Cached
        extends LLVMAsForeignLibrary {
            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            public boolean isAdoptable() {
                return false;
            }

            @Override
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMGlobalContainer.isForeign((LLVMGlobalContainer)receiver);
            }
        }
    }

    @GeneratedBy(value=LLVMGlobalContainer.class)
    public static final class LLVMAsForeignLibraryEagerProvider
    implements EagerExportProvider {
        public void ensureRegistered() {
            LLVMGlobalContainerGen.init();
        }

        public String getLibraryClassName() {
            return "com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary";
        }
    }

    @GeneratedBy(value=LLVMGlobalContainer.class)
    public static final class LLVMManagedWriteLibraryEagerProvider
    implements EagerExportProvider {
        public void ensureRegistered() {
            LLVMGlobalContainerGen.init();
        }

        public String getLibraryClassName() {
            return "com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary";
        }
    }

    @GeneratedBy(value=LLVMGlobalContainer.class)
    public static final class LLVMManagedReadLibraryEagerProvider
    implements EagerExportProvider {
        public void ensureRegistered() {
            LLVMGlobalContainerGen.init();
        }

        public String getLibraryClassName() {
            return "com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary";
        }
    }
}

