/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceArrayLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceBasicType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceDecoratorType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourcePointerType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStructLikeType;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public final class DebugExprType {
    private static EnumMap<Kind, DebugExprType> map = new EnumMap(Kind.class);
    private static HashMap<String, DebugExprType> structMap = new HashMap();
    private final Kind kind;
    private DebugExprType innerType;
    private int nElems;

    public static DebugExprType commonType(DebugExprType t1, DebugExprType t2) {
        if (t1 == t2) {
            return t1;
        }
        if (t1 == DebugExprType.getVoidType() || t2 == DebugExprType.getVoidType()) {
            return DebugExprType.getVoidType();
        }
        if (t1.isFloatingType() && t2.isFloatingType()) {
            return DebugExprType.getFloatType(Math.max(t1.getBitSize(), t2.getBitSize()));
        }
        if (t1.isIntegerType() && t2.isIntegerType()) {
            if (t1.isUnsigned() != t2.isUnsigned()) {
                return DebugExprType.getIntType(Math.max(t1.getBitSize(), t2.getBitSize()), false);
            }
            return DebugExprType.getIntType(Math.max(t1.getBitSize(), t2.getBitSize()), !t1.isUnsigned());
        }
        if (t1.isIntegerType() && t2.isFloatingType()) {
            return t2;
        }
        if (t1.isFloatingType() && t2.isIntegerType()) {
            return t1;
        }
        return DebugExprType.getVoidType();
    }

    public static DebugExprType getBoolType() {
        if (map.containsKey((Object)Kind.BOOL)) {
            return map.get((Object)Kind.BOOL);
        }
        DebugExprType t = new DebugExprType(Kind.BOOL, null);
        map.put(Kind.BOOL, t);
        return t;
    }

    public static DebugExprType getFloatType(long sizeInBits) {
        Kind kind = Kind.VOID;
        if (sizeInBits <= 32L) {
            kind = Kind.FLOAT;
        } else if (sizeInBits <= 64L) {
            kind = Kind.DOUBLE;
        } else if (sizeInBits <= 128L) {
            kind = Kind.LONG_DOUBLE;
        }
        if (map.containsKey((Object)kind)) {
            return map.get((Object)kind);
        }
        DebugExprType t = new DebugExprType(kind, null);
        map.put(kind, t);
        return t;
    }

    public static DebugExprType getIntType(long sizeInBits, boolean signed) {
        Kind kind = Kind.VOID;
        if (sizeInBits > 0L) {
            if (sizeInBits == 1L) {
                kind = Kind.BOOL;
            } else if (sizeInBits <= 8L) {
                kind = signed ? Kind.SIGNED_CHAR : Kind.UNSIGNED_CHAR;
            } else if (sizeInBits <= 16L) {
                kind = signed ? Kind.SIGNED_SHORT : Kind.UNSIGNED_SHORT;
            } else if (sizeInBits <= 32L) {
                kind = signed ? Kind.SIGNED_INT : Kind.UNSIGNED_INT;
            } else if (sizeInBits <= 64L) {
                Kind kind2 = kind = signed ? Kind.SIGNED_LONG : Kind.UNSIGNED_LONG;
            }
        }
        if (map.containsKey((Object)kind)) {
            return map.get((Object)kind);
        }
        DebugExprType t = new DebugExprType(kind, null);
        map.put(kind, t);
        return t;
    }

    public static DebugExprType getStructType(String ident) {
        if (structMap.containsKey(ident)) {
            return structMap.get(ident);
        }
        DebugExprType t = new DebugExprType(Kind.STRUCT, null);
        structMap.put(ident, t);
        return t;
    }

    public static DebugExprType getTypeFromLLVMType(Type llvmType) {
        if (llvmType instanceof PrimitiveType) {
            return DebugExprType.getTypeFromPrimitiveType((PrimitiveType)llvmType);
        }
        if (llvmType instanceof PointerType) {
            PointerType pointerType = (PointerType)llvmType;
            return new DebugExprType(Kind.POINTER, DebugExprType.getTypeFromLLVMType(pointerType.getPointeeType()));
        }
        if (llvmType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)llvmType;
            return new DebugExprType(Kind.ARRAY, DebugExprType.getTypeFromLLVMType(arrayType.getElementType()));
        }
        if (llvmType instanceof StructureType) {
            return new DebugExprType(Kind.STRUCT, null);
        }
        return DebugExprType.getVoidType();
    }

    private static DebugExprType getTypeFromPrimitiveType(PrimitiveType type) {
        switch (type.getPrimitiveKind()) {
            case I1: {
                return DebugExprType.getBoolType();
            }
            case I8: {
                return DebugExprType.getIntType(8L, true);
            }
            case I16: {
                return DebugExprType.getIntType(16L, true);
            }
            case I32: {
                return DebugExprType.getIntType(32L, true);
            }
            case I64: {
                return DebugExprType.getIntType(64L, true);
            }
            case HALF: 
            case FLOAT: {
                return DebugExprType.getFloatType(32L);
            }
            case DOUBLE: {
                return DebugExprType.getFloatType(64L);
            }
            case F128: 
            case X86_FP80: 
            case PPC_FP128: {
                return DebugExprType.getFloatType(128L);
            }
        }
        return DebugExprType.getVoidType();
    }

    @CompilerDirectives.TruffleBoundary
    public static DebugExprType getTypeFromSymbolTableMetaObject(Object metaObj) {
        if (metaObj instanceof LLVMSourceBasicType) {
            LLVMSourceBasicType basicType = (LLVMSourceBasicType)metaObj;
            LLVMSourceBasicType.Kind typeKind = basicType.getKind();
            long typeSize = basicType.getSize();
            switch (typeKind) {
                case BOOLEAN: {
                    return DebugExprType.getIntType(1L, false);
                }
                case SIGNED: {
                    return DebugExprType.getIntType(typeSize, true);
                }
                case UNSIGNED: {
                    return DebugExprType.getIntType(typeSize, false);
                }
                case SIGNED_CHAR: {
                    return DebugExprType.getIntType(8L, true);
                }
                case UNSIGNED_CHAR: {
                    return DebugExprType.getIntType(8L, false);
                }
                case FLOATING: {
                    return DebugExprType.getFloatType(typeSize);
                }
            }
            return DebugExprType.getVoidType();
        }
        if (metaObj instanceof LLVMSourceArrayLikeType) {
            LLVMSourceArrayLikeType arrayType = (LLVMSourceArrayLikeType)metaObj;
            DebugExprType innerType = DebugExprType.getTypeFromSymbolTableMetaObject(arrayType.getElementType(0L));
            return new DebugExprType(Kind.ARRAY, innerType, arrayType.getElementCount());
        }
        if (metaObj instanceof LLVMSourceDecoratorType) {
            return DebugExprType.getTypeFromSymbolTableMetaObject(((LLVMSourceDecoratorType)metaObj).getActualType());
        }
        if (metaObj instanceof LLVMSourceStructLikeType) {
            return new DebugExprType(Kind.STRUCT, null);
        }
        if (metaObj instanceof LLVMSourcePointerType) {
            LLVMSourcePointerType pointerType = (LLVMSourcePointerType)metaObj;
            DebugExprType baseType = DebugExprType.getTypeFromSymbolTableMetaObject(pointerType.getBaseType());
            return new DebugExprType(Kind.POINTER, baseType);
        }
        return DebugExprType.getVoidType();
    }

    public static DebugExprType getVoidType() {
        if (map.containsKey((Object)Kind.VOID)) {
            return map.get((Object)Kind.VOID);
        }
        DebugExprType t = new DebugExprType(Kind.VOID, null);
        map.put(Kind.VOID, t);
        return t;
    }

    private DebugExprType(Kind kind, DebugExprType innerType) {
        this(kind, innerType, -1);
    }

    private DebugExprType(Kind kind, DebugExprType innerType, int nElems) {
        this.kind = kind;
        this.innerType = innerType;
        this.nElems = nElems;
    }

    public boolean canBeCastTo(DebugExprType other) {
        switch (this.kind) {
            case VOID: {
                return false;
            }
            case BOOL: {
                return other.isIntegerType();
            }
            case UNSIGNED_CHAR: 
            case SIGNED_CHAR: 
            case UNSIGNED_SHORT: 
            case SIGNED_SHORT: 
            case UNSIGNED_INT: 
            case SIGNED_INT: 
            case UNSIGNED_LONG: 
            case SIGNED_LONG: {
                return other.isIntegerType() || other.isFloatingType();
            }
            case FLOAT: 
            case DOUBLE: 
            case LONG_DOUBLE: {
                return other.isIntegerType() || other.isFloatingType();
            }
            case POINTER: {
                return other.isPointer();
            }
            case ARRAY: {
                return other.kind == Kind.ARRAY && this.innerType.canBeCastTo(other.innerType) && this.nElems == other.nElems;
            }
            case STRUCT: {
                return false;
            }
            case FUNCTION: {
                return false;
            }
        }
        return false;
    }

    public DebugExprType createArrayType(int length) {
        return new DebugExprType(Kind.ARRAY, this, length);
    }

    public DebugExprType createPointer() {
        return new DebugExprType(Kind.POINTER, this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DebugExprType) {
            return this.equalsType((DebugExprType)obj);
        }
        return false;
    }

    public boolean equalsType(DebugExprType o) {
        if (o.kind != this.kind) {
            return false;
        }
        switch (this.kind) {
            case VOID: 
            case BOOL: 
            case UNSIGNED_CHAR: 
            case SIGNED_CHAR: 
            case UNSIGNED_SHORT: 
            case SIGNED_SHORT: 
            case UNSIGNED_INT: 
            case SIGNED_INT: 
            case UNSIGNED_LONG: 
            case SIGNED_LONG: 
            case FLOAT: 
            case DOUBLE: 
            case LONG_DOUBLE: {
                return true;
            }
            case POINTER: 
            case ARRAY: {
                return this.innerType.equals(o.innerType) && this.nElems == o.nElems;
            }
        }
        return super.equals(o);
    }

    public int getBitSize() {
        switch (this.kind) {
            case VOID: {
                return 0;
            }
            case BOOL: {
                return 1;
            }
            case UNSIGNED_CHAR: 
            case SIGNED_CHAR: {
                return 8;
            }
            case UNSIGNED_SHORT: 
            case SIGNED_SHORT: {
                return 16;
            }
            case UNSIGNED_INT: 
            case SIGNED_INT: {
                return 32;
            }
            case UNSIGNED_LONG: 
            case SIGNED_LONG: {
                return 64;
            }
            case FLOAT: {
                return 32;
            }
            case DOUBLE: {
                return 64;
            }
            case LONG_DOUBLE: {
                return 128;
            }
        }
        return 0;
    }

    public DebugExprType getInnerType() {
        return this.innerType;
    }

    public Type getLLVMRuntimeType() {
        switch (this.kind) {
            case VOID: {
                return VoidType.INSTANCE;
            }
            case BOOL: {
                return PrimitiveType.I1;
            }
            case UNSIGNED_CHAR: 
            case SIGNED_CHAR: {
                return PrimitiveType.I8;
            }
            case UNSIGNED_SHORT: 
            case SIGNED_SHORT: {
                return PrimitiveType.I16;
            }
            case UNSIGNED_INT: 
            case SIGNED_INT: {
                return PrimitiveType.I32;
            }
            case UNSIGNED_LONG: 
            case SIGNED_LONG: {
                return PrimitiveType.I64;
            }
            case FLOAT: {
                return PrimitiveType.FLOAT;
            }
            case DOUBLE: {
                return PrimitiveType.DOUBLE;
            }
            case LONG_DOUBLE: {
                return PrimitiveType.X86_FP80;
            }
            case POINTER: {
                return new PointerType(this.innerType.getLLVMRuntimeType());
            }
            case ARRAY: {
                if (this.nElems >= 0) {
                    return new ArrayType(this.innerType.getLLVMRuntimeType(), this.nElems);
                }
                return new PointerType(this.innerType.getLLVMRuntimeType());
            }
        }
        return VoidType.INSTANCE;
    }

    public int hashCode() {
        if (this.innerType != null) {
            return this.kind.hashCode() ^ this.innerType.hashCode();
        }
        return this.kind.hashCode();
    }

    public boolean isFloatingType() {
        switch (this.kind) {
            case FLOAT: 
            case DOUBLE: 
            case LONG_DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isIntegerType() {
        switch (this.kind) {
            case BOOL: 
            case UNSIGNED_CHAR: 
            case SIGNED_CHAR: 
            case UNSIGNED_SHORT: 
            case SIGNED_SHORT: 
            case UNSIGNED_INT: 
            case SIGNED_INT: 
            case UNSIGNED_LONG: 
            case SIGNED_LONG: {
                return true;
            }
        }
        return false;
    }

    public boolean isPointer() {
        return this.kind == Kind.POINTER;
    }

    public boolean isUnsigned() {
        switch (this.kind) {
            case UNSIGNED_CHAR: 
            case UNSIGNED_SHORT: 
            case UNSIGNED_INT: 
            case UNSIGNED_LONG: {
                return true;
            }
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public Object parse(Object member) {
        switch (this.kind) {
            case BOOL: {
                return Boolean.parseBoolean(member.toString());
            }
            case UNSIGNED_CHAR: 
            case SIGNED_CHAR: {
                return member.toString();
            }
            case UNSIGNED_SHORT: {
                return Short.toUnsignedInt(Short.parseShort(member.toString()));
            }
            case SIGNED_SHORT: {
                return Short.parseShort(member.toString());
            }
            case UNSIGNED_INT: {
                return Integer.toUnsignedLong(Integer.parseInt(member.toString()));
            }
            case SIGNED_INT: {
                return Integer.parseInt(member.toString());
            }
            case UNSIGNED_LONG: 
            case SIGNED_LONG: {
                return Long.parseLong(member.toString());
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(member.toString()));
            }
            case DOUBLE: 
            case LONG_DOUBLE: {
                return Double.parseDouble(member.toString());
            }
            case POINTER: 
            case ARRAY: 
            case STRUCT: {
                return member;
            }
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        switch (this.kind) {
            case VOID: 
            case BOOL: 
            case UNSIGNED_CHAR: 
            case SIGNED_CHAR: 
            case UNSIGNED_SHORT: 
            case SIGNED_SHORT: 
            case UNSIGNED_INT: 
            case SIGNED_INT: 
            case UNSIGNED_LONG: 
            case SIGNED_LONG: 
            case FLOAT: 
            case DOUBLE: 
            case LONG_DOUBLE: {
                return this.kind.name().toLowerCase();
            }
            case POINTER: {
                return this.innerType.toString() + "*";
            }
            case ARRAY: {
                return this.innerType.toString() + "[" + (Serializable)(this.nElems >= 0 ? Integer.valueOf(this.nElems) : "") + "]";
            }
            case STRUCT: {
                for (Map.Entry<String, DebugExprType> e : structMap.entrySet()) {
                    if (e.getValue() != this) continue;
                    return this.kind.name() + " " + e.getKey();
                }
                return this.kind.name().toLowerCase();
            }
            case FUNCTION: {
                return this.kind.name().toLowerCase();
            }
        }
        return super.toString();
    }

    public static enum Kind {
        VOID,
        BOOL,
        UNSIGNED_CHAR,
        SIGNED_CHAR,
        UNSIGNED_SHORT,
        SIGNED_SHORT,
        UNSIGNED_INT,
        SIGNED_INT,
        UNSIGNED_LONG,
        SIGNED_LONG,
        FLOAT,
        DOUBLE,
        LONG_DOUBLE,
        POINTER,
        ARRAY,
        STRUCT,
        FUNCTION;

    }
}

