/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprTypeofNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.MemberAccessible;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourcePointerType;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObject;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

public abstract class DebugExprPointerCastNode
extends LLVMExpressionNode
implements MemberAccessible {
    @Node.Child
    private LLVMExpressionNode pointerNode;
    @Node.Child
    private DebugExprTypeofNode typeNode;

    public DebugExprPointerCastNode(LLVMExpressionNode pointerNode, DebugExprTypeofNode typeNode) {
        this.pointerNode = pointerNode;
        this.typeNode = typeNode;
    }

    @Specialization
    Object doCast(VirtualFrame frame) {
        Object executedPointerNode = this.pointerNode.executeGeneric(frame);
        return this.getMember(executedPointerNode, frame);
    }

    @Override
    public DebugExprType getType(VirtualFrame frame) {
        return this.typeNode.getType(frame);
    }

    private Object getMember(Object executedPointerNode, VirtualFrame frame) {
        if (executedPointerNode == null) {
            throw DebugExprException.create(this, "debugObject to dereference is null", new Object[0]);
        }
        if (!this.typeNode.getLLVMSourceType(frame).isPointer()) {
            throw DebugExprException.create(this, "%s is no pointer", executedPointerNode);
        }
        try {
            LLVMSourcePointerType llvmSourcePointerType = (LLVMSourcePointerType)this.typeNode.getLLVMSourceType(frame);
            LLVMDebugObject llvmPointerObject = (LLVMDebugObject)executedPointerNode;
            Object llvmPointerValue = llvmPointerObject.getValue();
            LLVMDebugValue.Builder builder = CommonNodeFactory.createDebugValueBuilder();
            LLVMDebugValue pointerValue = builder.build(llvmPointerValue);
            return LLVMDebugObject.create(llvmSourcePointerType, 0L, pointerValue, null);
        }
        catch (ClassCastException e) {
            throw DebugExprException.create(this, "%s cannot be casted to pointer ", executedPointerNode);
        }
    }

    @Override
    public Object getMember(VirtualFrame frame) {
        if (this.pointerNode instanceof MemberAccessible) {
            MemberAccessible ma = (MemberAccessible)((Object)this.pointerNode);
            Object member = ma.getMember(frame);
            return this.getMember(member, frame);
        }
        throw DebugExprException.create(this, "member %s is not accessible", new Object[]{this.pointerNode});
    }
}

