/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;

public abstract class LibraryLocator {
    private static final Level LOADER_LOGGING_LEVEL = Level.FINER;
    private static final boolean isLoggingEnabled = LLVMContext.loaderLogger().isLoggable(LOADER_LOGGING_LEVEL);

    @CompilerDirectives.TruffleBoundary
    public final TruffleFile locateFile(LLVMContext context, String lib, Object reason) {
        Object ret = this.locate(context, lib, reason);
        if (ret instanceof TruffleFile) {
            return (TruffleFile)ret;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public final Source locateSource(LLVMContext context, String lib, Object reason) throws IOException {
        Source.SourceBuilder builder;
        Object ret = this.locate(context, lib, reason);
        if (ret instanceof Source.SourceBuilder) {
            builder = (Source.SourceBuilder)ret;
        } else if (ret instanceof TruffleFile) {
            TruffleFile file = (TruffleFile)ret;
            builder = Source.newBuilder((String)"llvm", (TruffleFile)file);
        } else {
            assert (ret == null);
            return null;
        }
        return builder.build();
    }

    private Object locate(LLVMContext context, String lib, Object reason) {
        if (LibraryLocator.loggingEnabled()) {
            LibraryLocator.traceLoader(context, "");
        }
        LibraryLocator.traceFind(context, lib, reason);
        return this.locateLibrary(context, lib, reason);
    }

    protected abstract Object locateLibrary(LLVMContext var1, String var2, Object var3);

    public static void traceFind(LLVMContext context, Object lib, Object reason) {
        if (LibraryLocator.loggingEnabled()) {
            LibraryLocator.traceLoader(context, "find external library=%s; needed by %s", lib, reason);
        }
    }

    public static void traceTry(LLVMContext context, Object file) {
        if (LibraryLocator.loggingEnabled()) {
            LibraryLocator.traceLoader(context, "  trying file=%s", file);
        }
    }

    public static void traceDelegateNative(LLVMContext context, Object file) {
        if (LibraryLocator.loggingEnabled()) {
            LibraryLocator.traceLoader(context, "  delegating to native=%s", file);
        }
    }

    public static void traceLoadNative(LLVMContext context, Object file) {
        if (LibraryLocator.loggingEnabled()) {
            LibraryLocator.traceLoader(context, "load library natively=%s", file);
        }
    }

    public static void traceSearchPath(LLVMContext context, List<?> paths) {
        if (LibraryLocator.loggingEnabled()) {
            LibraryLocator.traceLoader(context, " search path=%s", paths);
        }
    }

    public static void traceSearchPath(LLVMContext context, List<?> paths, Object reason) {
        if (LibraryLocator.loggingEnabled()) {
            LibraryLocator.traceLoader(context, " search path=%s (local path from %s)", paths, reason);
        }
    }

    public static void traceParseBitcode(LLVMContext context, Object path) {
        if (LibraryLocator.loggingEnabled()) {
            LibraryLocator.traceLoader(context, "parse bitcode=%s", path);
        }
    }

    public static void traceAlreadyLoaded(LLVMContext context, Object path) {
        if (LibraryLocator.loggingEnabled()) {
            LibraryLocator.traceLoader(context, "library already located: %s", path);
        }
    }

    public static void traceStaticInits(LLVMContext context, Object prefix, Object module) {
        LibraryLocator.traceStaticInits(context, prefix, module, "");
    }

    public static void traceStaticInits(LLVMContext context, Object prefix, Object module, Object details) {
        if (LibraryLocator.loggingEnabled()) {
            LibraryLocator.traceLoader(context, "calling %s: %s %s", prefix, module, details);
        }
    }

    public static boolean loggingEnabled() {
        return isLoggingEnabled;
    }

    @CompilerDirectives.TruffleBoundary
    private static void traceLoader(LLVMContext context, String str) {
        LLVMContext.loaderLogger().log(LOADER_LOGGING_LEVEL, String.format("lli(%x): %s", LibraryLocator.prefix(context), str));
    }

    @CompilerDirectives.TruffleBoundary
    private static void traceLoader(LLVMContext context, String format, Object arg0) {
        LLVMContext.loaderLogger().log(LOADER_LOGGING_LEVEL, String.format("lli(%x): " + format, LibraryLocator.prefix(context), arg0));
    }

    @CompilerDirectives.TruffleBoundary
    private static void traceLoader(LLVMContext context, String format, Object arg0, Object arg1) {
        LLVMContext.loaderLogger().log(LOADER_LOGGING_LEVEL, String.format("lli(%x): " + format, LibraryLocator.prefix(context), arg0, arg1));
    }

    @CompilerDirectives.TruffleBoundary
    private static void traceLoader(LLVMContext context, String format, Object arg0, Object arg1, Object arg2) {
        LLVMContext.loaderLogger().log(LOADER_LOGGING_LEVEL, String.format("lli(%x): " + format, LibraryLocator.prefix(context), arg0, arg1, arg2));
    }

    private static int prefix(LLVMContext context) {
        return System.identityHashCode(context);
    }
}

