/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.llvm.runtime.ArithmeticOperation;
import com.oracle.truffle.llvm.runtime.CompareOperator;
import com.oracle.truffle.llvm.runtime.LLVMElemPtrSymbol;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMThreadLocalSymbol;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebugGlobalVariable;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebugThreadLocalGlobalVariable;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugManagedValue;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObject;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMSourceTypeFactory;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToAnyLLVMNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToDoubleNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToFP128NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToFP80NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToFloatNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI16NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI1NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI32NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI64NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI8NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointer;
import com.oracle.truffle.llvm.runtime.interop.convert.ToVoidLLVMNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMTo128BitFloatingNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMTo80BitFloatingNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToAddressNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToDoubleNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToFloatNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI16NodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI1NodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI32NodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI64NodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI8NodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToVarINodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToVectorNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToVectorZeroExtNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCallNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugSimpleObjectBuilder;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugTrapNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMToDebugDeclaration;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMToDebugValueNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVAArgNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMMetaLiteralNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMSimpleLiteralNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMVectorizedGetElementPtrNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVM128BitFloatLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVM80BitFloatLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDoubleLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDoubleLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMFloatLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMFloatLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI1LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI1LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMIVarBitLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMOffsetLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMStructLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMFloatStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMFloatStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI1StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI1StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAbstractCompareNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMArithmeticNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMArithmeticNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMCompareNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMPointerCompareNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMVectorArithmeticNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMVectorCompareNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessElemPtrSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessGlobalSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessThreadLocalSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMUnsupportedInstructionNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMWriteNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMWriteNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VariableBitWidthType;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class CommonNodeFactory {
    public static LLVMExpressionNode createLiteral(Object value, Type type) {
        if (type instanceof PointerType || type instanceof FunctionType) {
            if (LLVMNativePointer.isInstance(value)) {
                return LLVMSimpleLiteralNodeFactory.LLVMNativePointerLiteralNodeGen.create(LLVMNativePointer.cast(value));
            }
            if (LLVMManagedPointer.isInstance(value)) {
                return LLVMSimpleLiteralNodeFactory.LLVMManagedPointerLiteralNodeGen.create(LLVMManagedPointer.cast(value));
            }
            if (value instanceof LLVMGlobal || value instanceof LLVMFunction) {
                return LLVMAccessGlobalSymbolNodeGen.create((LLVMSymbol)value);
            }
            if (value instanceof LLVMElemPtrSymbol) {
                return LLVMAccessElemPtrSymbolNodeGen.create((LLVMElemPtrSymbol)value);
            }
            if (value instanceof LLVMThreadLocalSymbol) {
                return LLVMAccessThreadLocalSymbolNodeGen.create((LLVMThreadLocalSymbol)value);
            }
            throw new AssertionError(value.getClass());
        }
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI1LiteralNodeGen.create((Boolean)value);
                }
                case I8: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI8LiteralNodeGen.create((Byte)value);
                }
                case I16: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI16LiteralNodeGen.create((Short)value);
                }
                case I32: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI32LiteralNodeGen.create((Integer)value);
                }
                case I64: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI64LiteralNodeGen.create((Long)value);
                }
                case FLOAT: {
                    return LLVMSimpleLiteralNodeFactory.LLVMFloatLiteralNodeGen.create(((Float)value).floatValue());
                }
                case DOUBLE: {
                    return LLVMSimpleLiteralNodeFactory.LLVMDoubleLiteralNodeGen.create((Double)value);
                }
            }
            throw new AssertionError((Object)(value + " " + type));
        }
        if (type instanceof MetaType) {
            return LLVMMetaLiteralNodeGen.create(value);
        }
        throw new AssertionError((Object)(value + " " + type));
    }

    public static LLVMOffsetLoadNode createOffsetLoadNode(LLVMInteropType.ValueKind kind) {
        switch (kind) {
            case I1: {
                return LLVMI1LoadNode.LLVMI1OffsetLoadNode.create();
            }
            case I8: {
                return LLVMI8LoadNode.LLVMI8OffsetLoadNode.create();
            }
            case I16: {
                return LLVMI16LoadNode.LLVMI16OffsetLoadNode.create();
            }
            case I32: {
                return LLVMI32LoadNode.LLVMI32OffsetLoadNode.create();
            }
            case I64: {
                return LLVMI64LoadNode.LLVMI64OffsetLoadNode.create();
            }
            case FLOAT: {
                return LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.create();
            }
            case DOUBLE: {
                return LLVMDoubleLoadNode.LLVMDoubleOffsetLoadNode.create();
            }
            case POINTER: {
                return LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.create();
            }
        }
        throw new IllegalStateException("unexpected interop kind " + kind);
    }

    public static LLVMOffsetLoadNode getUncachedOffsetLoadNode(LLVMInteropType.ValueKind kind) {
        switch (kind) {
            case I1: {
                return LLVMI1LoadNodeGen.LLVMI1OffsetLoadNodeGen.getUncached();
            }
            case I8: {
                return LLVMI8LoadNodeGen.LLVMI8OffsetLoadNodeGen.getUncached();
            }
            case I16: {
                return LLVMI16LoadNodeGen.LLVMI16OffsetLoadNodeGen.getUncached();
            }
            case I32: {
                return LLVMI32LoadNodeGen.LLVMI32OffsetLoadNodeGen.getUncached();
            }
            case I64: {
                return LLVMI64LoadNodeGen.LLVMI64OffsetLoadNodeGen.getUncached();
            }
            case FLOAT: {
                return LLVMFloatLoadNodeGen.LLVMFloatOffsetLoadNodeGen.getUncached();
            }
            case DOUBLE: {
                return LLVMDoubleLoadNodeGen.LLVMDoubleOffsetLoadNodeGen.getUncached();
            }
            case POINTER: {
                return LLVMPointerLoadNodeGen.LLVMPointerOffsetLoadNodeGen.getUncached();
            }
        }
        throw new IllegalStateException("unexpected interop kind " + kind);
    }

    public static LLVMOffsetStoreNode createOffsetStoreNode(LLVMInteropType.ValueKind kind) {
        switch (kind) {
            case I1: {
                return LLVMI1StoreNode.LLVMI1OffsetStoreNode.create();
            }
            case I8: {
                return LLVMI8StoreNode.LLVMI8OffsetStoreNode.create();
            }
            case I16: {
                return LLVMI16StoreNode.LLVMI16OffsetStoreNode.create();
            }
            case I32: {
                return LLVMI32StoreNode.LLVMI32OffsetStoreNode.create();
            }
            case I64: {
                return LLVMI64StoreNode.LLVMI64OffsetStoreNode.create();
            }
            case FLOAT: {
                return LLVMFloatStoreNode.LLVMFloatOffsetStoreNode.create();
            }
            case DOUBLE: {
                return LLVMDoubleStoreNode.LLVMDoubleOffsetStoreNode.create();
            }
            case POINTER: {
                return LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.create();
            }
        }
        throw new IllegalStateException("unexpected interop kind " + kind);
    }

    public static LLVMOffsetStoreNode getUncachedOffsetStoreNode(LLVMInteropType.ValueKind kind) {
        switch (kind) {
            case I1: {
                return LLVMI1StoreNodeGen.LLVMI1OffsetStoreNodeGen.getUncached();
            }
            case I8: {
                return LLVMI8StoreNodeGen.LLVMI8OffsetStoreNodeGen.getUncached();
            }
            case I16: {
                return LLVMI16StoreNodeGen.LLVMI16OffsetStoreNodeGen.getUncached();
            }
            case I32: {
                return LLVMI32StoreNodeGen.LLVMI32OffsetStoreNodeGen.getUncached();
            }
            case I64: {
                return LLVMI64StoreNodeGen.LLVMI64OffsetStoreNodeGen.getUncached();
            }
            case FLOAT: {
                return LLVMFloatStoreNodeGen.LLVMFloatOffsetStoreNodeGen.getUncached();
            }
            case DOUBLE: {
                return LLVMDoubleStoreNodeGen.LLVMDoubleOffsetStoreNodeGen.getUncached();
            }
            case POINTER: {
                return LLVMPointerStoreNodeGen.LLVMPointerOffsetStoreNodeGen.getUncached();
            }
        }
        throw new IllegalStateException("unexpected interop kind " + kind);
    }

    public static Object toGenericDebuggerValue(Object llvmType, Object value, DataLayout dataLayout) {
        Object complexObject = CommonNodeFactory.asDebuggerIRValue(llvmType, value, dataLayout);
        if (complexObject != null) {
            return complexObject;
        }
        return LLVMDebugManagedValue.create(llvmType, value);
    }

    private static Object asDebuggerIRValue(Object llvmType, Object value, DataLayout dataLayout) {
        if (!(llvmType instanceof Type)) {
            return null;
        }
        Type type = (Type)llvmType;
        if (type instanceof MetaType) {
            return null;
        }
        LLVMSourceType sourceType = LLVMSourceTypeFactory.resolveType(type, dataLayout);
        if (sourceType == null) {
            return null;
        }
        if (value instanceof LLVMVector && ((LLVMVector)value).getLength() == 0) {
            return null;
        }
        if (value instanceof LLVMIVarBit && ((LLVMIVarBit)value).getBitSize() == 0) {
            return null;
        }
        LLVMDebugValue debugValue = CommonNodeFactory.createDebugValueBuilder().build(value);
        if (debugValue == LLVMDebugValue.UNAVAILABLE) {
            return null;
        }
        return LLVMDebugObject.create(sourceType, 0L, debugValue, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LLVMDebugObjectBuilder createDebugStaticValue(LLVMExpressionNode valueNode, boolean isGlobal) {
        LLVMDebugValue.Builder toDebugNode = CommonNodeFactory.createDebugValueBuilder();
        Object value = null;
        if (isGlobal) {
            assert (valueNode instanceof LLVMAccessSymbolNode);
            LLVMAccessSymbolNode node = (LLVMAccessSymbolNode)valueNode;
            LLVMSymbol symbol = node.getSymbol();
            if (symbol.isGlobalVariable()) {
                value = new LLVMDebugGlobalVariable(symbol.asGlobalVariable());
            } else {
                if (!symbol.isThreadLocalSymbol()) throw new IllegalStateException(symbol.getKind() + " symbol: " + symbol.getName());
                value = new LLVMDebugThreadLocalGlobalVariable(symbol.asThreadLocalSymbol());
            }
        } else {
            try {
                value = valueNode.executeGeneric(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (value == null) return LLVMDebugObjectBuilder.UNAVAILABLE;
        return LLVMDebugSimpleObjectBuilder.create(toDebugNode, value);
    }

    public static LLVMExpressionNode getTargetAddress(LLVMExpressionNode baseAddress, Type sourceType, Collection<Long> indices, NodeFactory nf, DataLayout dataLayout) {
        int indicesSize = indices.size();
        Long[] indicesArr = new Long[indicesSize];
        LLVMExpressionNode[] indexNodes = new LLVMExpressionNode[indicesSize];
        int i = indicesSize - 1;
        Iterator<Long> iterator = indices.iterator();
        while (iterator.hasNext()) {
            Long idx;
            indicesArr[i] = idx = iterator.next();
            indexNodes[i] = CommonNodeFactory.createLiteral(idx, PrimitiveType.I64);
            --i;
        }
        assert (i == -1);
        Object[] indexTypes = new PrimitiveType[indicesSize];
        Arrays.fill(indexTypes, PrimitiveType.I64);
        LLVMExpressionNode nestedGEPs = CommonNodeFactory.createNestedElementPointerNode(nf, dataLayout, indexNodes, indicesArr, (Type[])indexTypes, baseAddress, sourceType);
        return nestedGEPs;
    }

    public static LLVMExpressionNode createNestedElementPointerNode(NodeFactory nodeFactory, DataLayout dataLayout, LLVMExpressionNode[] indexNodes, Long[] indexConstants, Type[] indexTypes, LLVMExpressionNode curAddress, Type curType) {
        try {
            ElementPointerFactory factory = new ElementPointerFactory(nodeFactory, curAddress, curType);
            for (int i = 0; i < indexNodes.length; ++i) {
                LLVMExpressionNode indexNode;
                AggregateType aggregate;
                Type indexType = indexTypes[i];
                Long indexInteger = indexConstants[i];
                if (indexInteger == null) {
                    if (factory.currentType instanceof StructureType) {
                        throw new LLVMParserException("Indices on structs must be constant integers!");
                    }
                    aggregate = (AggregateType)factory.currentType;
                    long indexedTypeLength = aggregate.getOffsetOf(1L, dataLayout);
                    factory.currentType = aggregate.getElementType(1L);
                    factory.addIndex(indexedTypeLength, indexNodes[i], indexType);
                    continue;
                }
                aggregate = (AggregateType)factory.currentType;
                long addressOffset = aggregate.getOffsetOf(indexInteger, dataLayout);
                factory.currentType = aggregate.getElementType(indexInteger);
                if (addressOffset == 0L && i != indexNodes.length - 1) continue;
                if (indexType == PrimitiveType.I32) {
                    indexNode = CommonNodeFactory.createLiteral(1, PrimitiveType.I32);
                } else if (indexType == PrimitiveType.I64) {
                    indexNode = CommonNodeFactory.createLiteral(1L, PrimitiveType.I64);
                } else {
                    throw new AssertionError(indexType);
                }
                factory.addIndex(addressOffset, indexNode, indexType);
            }
            return factory.currentAddress;
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
    }

    public static LLVMExpressionNode createFrameRead(Type llvmType, int frameSlot) {
        if (llvmType instanceof PrimitiveType) {
            switch (((PrimitiveType)llvmType).getPrimitiveKind()) {
                case I1: {
                    return LLVMReadNode.LLVMI1ReadNode.create(frameSlot);
                }
                case I8: {
                    return LLVMReadNode.LLVMI8ReadNode.create(frameSlot);
                }
                case I16: {
                    return LLVMReadNode.LLVMI16ReadNode.create(frameSlot);
                }
                case I32: {
                    return LLVMReadNode.LLVMI32ReadNode.create(frameSlot);
                }
                case I64: {
                    return LLVMReadNodeFactory.LLVMI64ReadNodeGen.create(frameSlot);
                }
                case FLOAT: {
                    return LLVMReadNode.LLVMFloatReadNode.create(frameSlot);
                }
                case DOUBLE: {
                    return LLVMReadNode.LLVMDoubleReadNode.create(frameSlot);
                }
                case X86_FP80: {
                    return LLVMReadNode.LLVM80BitFloatReadNode.create(frameSlot);
                }
                case F128: {
                    return LLVMReadNode.LLVM128BitFloatReadNode.create(frameSlot);
                }
            }
        } else if (llvmType instanceof VectorType) {
            Type elemType = ((VectorType)llvmType).getElementType();
            if (elemType instanceof PrimitiveType) {
                switch (((PrimitiveType)elemType).getPrimitiveKind()) {
                    case I1: 
                    case I8: 
                    case I16: 
                    case I32: 
                    case I64: 
                    case FLOAT: 
                    case DOUBLE: {
                        return LLVMReadNode.LLVMObjectReadNode.create(frameSlot);
                    }
                }
            } else if (elemType instanceof PointerType || elemType instanceof FunctionType) {
                return LLVMReadNode.LLVMObjectReadNode.create(frameSlot);
            }
        } else {
            if (llvmType instanceof VariableBitWidthType) {
                return LLVMReadNode.LLVMIReadVarBitNode.create(frameSlot);
            }
            if (llvmType instanceof PointerType || llvmType instanceof FunctionType) {
                return LLVMReadNode.LLVMObjectReadNode.create(frameSlot);
            }
            if (llvmType instanceof StructureType || llvmType instanceof ArrayType) {
                return LLVMReadNode.LLVMObjectReadNode.create(frameSlot);
            }
            if (llvmType instanceof VoidType) {
                return LLVMUnsupportedInstructionNode.createExpression(LLVMUnsupportedException.UnsupportedReason.PARSER_ERROR_VOID_SLOT);
            }
            if (llvmType == MetaType.DEBUG) {
                return LLVMReadNode.LLVMDebugReadNode.create(frameSlot);
            }
        }
        throw new AssertionError((Object)(llvmType + " for " + frameSlot));
    }

    public static LLVMLoadNode createLoad(Type resolvedResultType, LLVMExpressionNode loadTarget) {
        if (resolvedResultType instanceof VectorType) {
            return CommonNodeFactory.createLoadVector((VectorType)resolvedResultType, loadTarget, ((VectorType)resolvedResultType).getNumberOfElementsInt());
        }
        int bits = resolvedResultType instanceof VariableBitWidthType ? ((VariableBitWidthType)resolvedResultType).getBitSizeInt() : 0;
        return CommonNodeFactory.createLoad(resolvedResultType, loadTarget, bits);
    }

    public static LLVMWriteNode createFrameWrite(Type llvmType, LLVMExpressionNode result, int slot) {
        if (llvmType instanceof VectorType) {
            return LLVMWriteNodeFactory.LLVMWriteVectorNodeGen.create(slot, result);
        }
        if (llvmType instanceof PrimitiveType) {
            switch (((PrimitiveType)llvmType).getPrimitiveKind()) {
                case I1: {
                    return LLVMWriteNodeFactory.LLVMWriteI1NodeGen.create(slot, result);
                }
                case I8: {
                    return LLVMWriteNodeFactory.LLVMWriteI8NodeGen.create(slot, result);
                }
                case I16: {
                    return LLVMWriteNodeFactory.LLVMWriteI16NodeGen.create(slot, result);
                }
                case I32: {
                    return LLVMWriteNodeFactory.LLVMWriteI32NodeGen.create(slot, result);
                }
                case I64: {
                    return LLVMWriteNodeFactory.LLVMWriteI64NodeGen.create(slot, result);
                }
                case FLOAT: {
                    return LLVMWriteNodeFactory.LLVMWriteFloatNodeGen.create(slot, result);
                }
                case DOUBLE: {
                    return LLVMWriteNodeFactory.LLVMWriteDoubleNodeGen.create(slot, result);
                }
                case X86_FP80: {
                    return LLVMWriteNodeFactory.LLVMWrite80BitFloatingNodeGen.create(slot, result);
                }
                case F128: {
                    return LLVMWriteNodeFactory.LLVMWrite128BitFloatingNodeGen.create(slot, result);
                }
            }
            throw new AssertionError(llvmType);
        }
        if (llvmType instanceof VariableBitWidthType) {
            return LLVMWriteNodeFactory.LLVMWriteIVarBitNodeGen.create(slot, result);
        }
        if (llvmType instanceof PointerType || llvmType instanceof FunctionType) {
            return LLVMWriteNodeFactory.LLVMWritePointerNodeGen.create(slot, result);
        }
        if (llvmType instanceof StructureType || llvmType instanceof ArrayType) {
            return LLVMWriteNodeFactory.LLVMWritePointerNodeGen.create(slot, result);
        }
        throw new AssertionError(llvmType);
    }

    public static LLVMExpressionNode createVaArg(Type type, LLVMExpressionNode source) {
        return LLVMVAArgNodeGen.create(type, source);
    }

    private static LLVMLoadNode createLoadVector(VectorType resultType, LLVMExpressionNode loadTarget, int size) {
        Type elemType = resultType.getElementType();
        if (elemType instanceof PrimitiveType) {
            switch (((PrimitiveType)elemType).getPrimitiveKind()) {
                case I1: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI1VectorNodeGen.create(loadTarget, size);
                }
                case I8: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI8VectorNodeGen.create(loadTarget, size);
                }
                case I16: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI16VectorNodeGen.create(loadTarget, size);
                }
                case I32: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI32VectorNodeGen.create(loadTarget, size);
                }
                case I64: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI64VectorNodeGen.create(loadTarget, size);
                }
                case FLOAT: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadFloatVectorNodeGen.create(loadTarget, size);
                }
                case DOUBLE: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadDoubleVectorNodeGen.create(loadTarget, size);
                }
            }
            throw new AssertionError((Object)(elemType + " vectors not supported"));
        }
        if (elemType instanceof PointerType || elemType instanceof FunctionType) {
            return LLVMLoadVectorNodeFactory.LLVMLoadPointerVectorNodeGen.create(loadTarget, size);
        }
        throw new AssertionError((Object)(elemType + " vectors not supported"));
    }

    private static LLVMLoadNode createLoad(Type resultType, LLVMExpressionNode loadTarget, int bits) {
        if (resultType instanceof PrimitiveType) {
            switch (((PrimitiveType)resultType).getPrimitiveKind()) {
                case I1: {
                    return LLVMI1LoadNodeGen.create(loadTarget);
                }
                case I8: {
                    return LLVMI8LoadNodeGen.create(loadTarget);
                }
                case I16: {
                    return LLVMI16LoadNodeGen.create(loadTarget);
                }
                case I32: {
                    return LLVMI32LoadNodeGen.create(loadTarget);
                }
                case I64: {
                    return LLVMI64LoadNodeGen.create(loadTarget);
                }
                case FLOAT: {
                    return LLVMFloatLoadNodeGen.create(loadTarget);
                }
                case DOUBLE: {
                    return LLVMDoubleLoadNodeGen.create(loadTarget);
                }
                case X86_FP80: {
                    return LLVM80BitFloatLoadNodeGen.create(loadTarget);
                }
                case F128: {
                    return LLVM128BitFloatLoadNodeGen.create(loadTarget);
                }
            }
            throw new AssertionError(resultType);
        }
        if (resultType instanceof VariableBitWidthType) {
            return LLVMIVarBitLoadNodeGen.create(loadTarget, bits);
        }
        if (resultType instanceof StructureType || resultType instanceof ArrayType) {
            return LLVMStructLoadNodeGen.create(loadTarget);
        }
        if (resultType instanceof PointerType || resultType instanceof FunctionType) {
            return LLVMPointerLoadNodeGen.create(loadTarget);
        }
        throw new AssertionError(resultType);
    }

    public static ForeignToLLVM createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType type) {
        switch (type) {
            case VOID: {
                return ToVoidLLVMNodeGen.create();
            }
            case ANY: {
                return ToAnyLLVMNodeGen.create();
            }
            case I1: {
                return ToI1NodeGen.create();
            }
            case I8: {
                return ToI8NodeGen.create();
            }
            case I16: {
                return ToI16NodeGen.create();
            }
            case I32: {
                return ToI32NodeGen.create();
            }
            case I64: {
                return ToI64NodeGen.create();
            }
            case FLOAT: {
                return ToFloatNodeGen.create();
            }
            case DOUBLE: {
                return ToDoubleNodeGen.create();
            }
            case FP80: {
                return ToFP80NodeGen.create();
            }
            case FP128: {
                return ToFP128NodeGen.create();
            }
            case POINTER: {
                return ToPointer.create();
            }
        }
        throw new IllegalStateException(type.toString());
    }

    public static ForeignToLLVM createForeignToLLVM(LLVMInteropType.Value type) {
        switch (type.kind) {
            case I1: {
                return ToI1NodeGen.create();
            }
            case I8: {
                return ToI8NodeGen.create();
            }
            case I16: {
                return ToI16NodeGen.create();
            }
            case I32: {
                return ToI32NodeGen.create();
            }
            case I64: {
                return ToI64NodeGen.create();
            }
            case FLOAT: {
                return ToFloatNodeGen.create();
            }
            case DOUBLE: {
                return ToDoubleNodeGen.create();
            }
            case FP80: {
                return ToFP80NodeGen.create();
            }
            case FP128: {
                return ToFP128NodeGen.create();
            }
            case POINTER: {
                return ToPointer.create(type.baseType);
            }
        }
        throw new IllegalStateException("unexpected interop kind " + type.kind);
    }

    public static LLVMExpressionNode createFunctionCall(LLVMExpressionNode functionNode, LLVMExpressionNode[] argNodes, FunctionType type) {
        return LLVMCallNode.create(type, functionNode, argNodes, true);
    }

    public static LLVMStatementNode createDebugTrap() {
        return LLVMDebugTrapNodeGen.create();
    }

    public static LLVMDebugValue.Builder createDebugDeclarationBuilder() {
        return LLVMToDebugDeclaration.getInstance();
    }

    public static LLVMDebugValue.Builder createDebugValueBuilder() {
        return LLVMToDebugValueNodeGen.getUncached();
    }

    public static LLVMExpressionNode createArithmeticOp(ArithmeticOperation op, Type type, LLVMExpressionNode left, LLVMExpressionNode right) {
        if (type instanceof VectorType) {
            VectorType vectorType = (VectorType)type;
            LLVMArithmeticNode arithmeticNode = CommonNodeFactory.createScalarArithmeticOp(op, vectorType.getElementType(), null, null);
            return LLVMVectorArithmeticNodeGen.create(vectorType.getNumberOfElementsInt(), arithmeticNode, left, right);
        }
        return CommonNodeFactory.createScalarArithmeticOp(op, type, left, right);
    }

    public static LLVMArithmeticNode createScalarArithmeticOp(ArithmeticOperation op, Type type, LLVMExpressionNode left, LLVMExpressionNode right) {
        assert (!(type instanceof VectorType));
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return LLVMArithmeticNodeFactory.LLVMI1ArithmeticNodeGen.create(op, left, right);
                }
                case I8: {
                    return LLVMArithmeticNodeFactory.LLVMI8ArithmeticNodeGen.create(op, left, right);
                }
                case I16: {
                    return LLVMArithmeticNodeFactory.LLVMI16ArithmeticNodeGen.create(op, left, right);
                }
                case I32: {
                    return LLVMArithmeticNodeFactory.LLVMI32ArithmeticNodeGen.create(op, left, right);
                }
                case I64: {
                    return LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode.create(op, left, right);
                }
                case FLOAT: {
                    return LLVMArithmeticNodeFactory.LLVMFloatArithmeticNodeGen.create(op, left, right);
                }
                case DOUBLE: {
                    return LLVMArithmeticNodeFactory.LLVMDoubleArithmeticNodeGen.create(op, left, right);
                }
                case X86_FP80: {
                    return LLVMArithmeticNodeFactory.LLVMFP80ArithmeticNodeGen.create(op, left, right);
                }
                case F128: {
                    return LLVMArithmeticNodeFactory.LLVMFP128ArithmeticNodeGen.create(op, left, right);
                }
            }
            throw new AssertionError(type);
        }
        if (type instanceof VariableBitWidthType) {
            return LLVMArithmeticNodeFactory.LLVMIVarBitArithmeticNodeGen.create(op, left, right);
        }
        throw new AssertionError(type);
    }

    public static LLVMExpressionNode createComparison(CompareOperator operator, Type type, LLVMExpressionNode lhs, LLVMExpressionNode rhs) {
        if (type instanceof VectorType) {
            VectorType vectorType = (VectorType)type;
            LLVMAbstractCompareNode comparison = CommonNodeFactory.createScalarComparison(operator, vectorType.getElementType(), null, null);
            return LLVMVectorCompareNodeGen.create(vectorType.getNumberOfElementsInt(), comparison, lhs, rhs);
        }
        return CommonNodeFactory.createScalarComparison(operator, type, lhs, rhs);
    }

    private static LLVMAbstractCompareNode createScalarComparison(CompareOperator operator, Type type, LLVMExpressionNode lhs, LLVMExpressionNode rhs) {
        assert (!(type instanceof VectorType));
        if (CommonNodeFactory.usePointerComparison(type)) {
            return CommonNodeFactory.createPointerComparison(operator, lhs, rhs);
        }
        return CommonNodeFactory.createPrimitiveComparison(operator, lhs, rhs);
    }

    private static LLVMAbstractCompareNode createPointerComparison(CompareOperator operator, LLVMExpressionNode lhs, LLVMExpressionNode rhs) {
        switch (operator) {
            case INT_EQUAL: {
                return LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.EQ, lhs, rhs);
            }
            case INT_NOT_EQUAL: {
                return LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.NEQ, lhs, rhs);
            }
            case INT_UNSIGNED_GREATER_THAN: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.ULE, lhs, rhs));
            }
            case INT_UNSIGNED_GREATER_OR_EQUAL: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.ULT, lhs, rhs));
            }
            case INT_UNSIGNED_LESS_THAN: {
                return LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.ULT, lhs, rhs);
            }
            case INT_UNSIGNED_LESS_OR_EQUAL: {
                return LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.ULE, lhs, rhs);
            }
            case INT_SIGNED_GREATER_THAN: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.SLE, lhs, rhs));
            }
            case INT_SIGNED_GREATER_OR_EQUAL: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.SLT, lhs, rhs));
            }
            case INT_SIGNED_LESS_THAN: {
                return LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.SLT, lhs, rhs);
            }
            case INT_SIGNED_LESS_OR_EQUAL: {
                return LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.SLE, lhs, rhs);
            }
        }
        throw new AssertionError((Object)operator);
    }

    private static LLVMAbstractCompareNode createPrimitiveComparison(CompareOperator operator, LLVMExpressionNode lhs, LLVMExpressionNode rhs) {
        switch (operator) {
            case FP_FALSE: {
                return LLVMCompareNodeFactory.LLVMFalseCmpNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED_EQUAL: {
                return LLVMCompareNodeFactory.LLVMOrderedEqNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED_GREATER_THAN: {
                return LLVMCompareNodeFactory.LLVMOrderedGtNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED_GREATER_OR_EQUAL: {
                return LLVMCompareNodeFactory.LLVMOrderedGeNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED_LESS_THAN: {
                return LLVMCompareNodeFactory.LLVMOrderedLtNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED_LESS_OR_EQUAL: {
                return LLVMCompareNodeFactory.LLVMOrderedLeNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED_NOT_EQUAL: {
                return LLVMCompareNodeFactory.LLVMOrderedNeNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED: {
                return LLVMCompareNodeFactory.LLVMOrderedNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED: {
                return LLVMCompareNodeFactory.LLVMUnorderedNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED_EQUAL: {
                return LLVMCompareNodeFactory.LLVMUnorderedEqNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED_GREATER_THAN: {
                return LLVMCompareNodeFactory.LLVMUnorderedGtNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED_GREATER_OR_EQUAL: {
                return LLVMCompareNodeFactory.LLVMUnorderedGeNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED_LESS_THAN: {
                return LLVMCompareNodeFactory.LLVMUnorderedLtNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED_LESS_OR_EQUAL: {
                return LLVMCompareNodeFactory.LLVMUnorderedLeNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED_NOT_EQUAL: {
                return LLVMCompareNodeFactory.LLVMUnorderedNeNodeGen.create(lhs, rhs);
            }
            case FP_TRUE: {
                return LLVMCompareNodeFactory.LLVMTrueCmpNodeGen.create(lhs, rhs);
            }
            case INT_EQUAL: {
                return LLVMCompareNodeFactory.LLVMEqNodeGen.create(lhs, rhs);
            }
            case INT_NOT_EQUAL: {
                return LLVMCompareNodeFactory.LLVMNeNodeGen.create(lhs, rhs);
            }
            case INT_UNSIGNED_GREATER_THAN: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMCompareNodeFactory.LLVMUnsignedLeNodeGen.create(lhs, rhs));
            }
            case INT_UNSIGNED_GREATER_OR_EQUAL: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMCompareNodeFactory.LLVMUnsignedLtNodeGen.create(lhs, rhs));
            }
            case INT_UNSIGNED_LESS_THAN: {
                return LLVMCompareNodeFactory.LLVMUnsignedLtNodeGen.create(lhs, rhs);
            }
            case INT_UNSIGNED_LESS_OR_EQUAL: {
                return LLVMCompareNodeFactory.LLVMUnsignedLeNodeGen.create(lhs, rhs);
            }
            case INT_SIGNED_GREATER_THAN: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMCompareNodeFactory.LLVMSignedLeNodeGen.create(lhs, rhs));
            }
            case INT_SIGNED_GREATER_OR_EQUAL: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMCompareNodeFactory.LLVMSignedLtNodeGen.create(lhs, rhs));
            }
            case INT_SIGNED_LESS_THAN: {
                return LLVMCompareNodeFactory.LLVMSignedLtNodeGen.create(lhs, rhs);
            }
            case INT_SIGNED_LESS_OR_EQUAL: {
                return LLVMCompareNodeFactory.LLVMSignedLeNodeGen.create(lhs, rhs);
            }
        }
        throw new RuntimeException("Missed a compare operator");
    }

    private static boolean usePointerComparison(Type type) {
        return type instanceof PointerType || type instanceof FunctionType || type instanceof PrimitiveType && ((PrimitiveType)type).getPrimitiveKind() == PrimitiveType.PrimitiveKind.I64;
    }

    public static LLVMExpressionNode createSimpleConstantNoArray(Object constant, Type type) {
        if (type instanceof VariableBitWidthType) {
            Number c = (Number)constant;
            try {
                if (Long.compareUnsigned(type.getBitSize(), 64L) <= 0) {
                    return LLVMSimpleLiteralNodeFactory.LLVMIVarBitLiteralNodeGen.create(LLVMIVarBit.fromLong(((VariableBitWidthType)type).getBitSizeInt(), c.longValue()));
                }
                return LLVMSimpleLiteralNodeFactory.LLVMIVarBitLiteralNodeGen.create(LLVMIVarBit.fromBigInteger(((VariableBitWidthType)type).getBitSizeInt(), (BigInteger)c));
            }
            catch (Type.TypeOverflowException e) {
                return Type.handleOverflowExpression(e);
            }
        }
        if (type instanceof PointerType || type instanceof FunctionType) {
            if (constant == null) {
                return LLVMSimpleLiteralNodeFactory.LLVMNativePointerLiteralNodeGen.create(LLVMNativePointer.create(0L));
            }
            throw new AssertionError((Object)("Not a Simple Constant: " + constant));
        }
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI1LiteralNodeGen.create((Boolean)constant);
                }
                case I8: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI8LiteralNodeGen.create((Byte)constant);
                }
                case I16: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI16LiteralNodeGen.create((Short)constant);
                }
                case I32: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI32LiteralNodeGen.create((Integer)constant);
                }
                case FLOAT: {
                    return LLVMSimpleLiteralNodeFactory.LLVMFloatLiteralNodeGen.create(((Float)constant).floatValue());
                }
                case DOUBLE: {
                    return LLVMSimpleLiteralNodeFactory.LLVMDoubleLiteralNodeGen.create((Double)constant);
                }
                case X86_FP80: {
                    if (constant == null) {
                        return LLVMSimpleLiteralNodeFactory.LLVM80BitFloatLiteralNodeGen.create(LLVM80BitFloat.fromLong(0L));
                    }
                    return LLVMSimpleLiteralNodeFactory.LLVM80BitFloatLiteralNodeGen.create(LLVM80BitFloat.fromBytesBigEndian((byte[])constant));
                }
                case F128: {
                    if (constant == null) {
                        return LLVMSimpleLiteralNodeFactory.LLVM128BitFloatLiteralNodeGen.create(LLVM128BitFloat.fromLong(0L));
                    }
                    return LLVMSimpleLiteralNodeFactory.LLVM128BitFloatLiteralNodeGen.create(LLVM128BitFloat.fromBytesBigEndian((byte[])constant));
                }
                case I64: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI64LiteralNodeGen.create((Long)constant);
                }
            }
            throw new AssertionError(type);
        }
        if (type == MetaType.DEBUG) {
            return LLVMSimpleLiteralNodeFactory.LLVMNativePointerLiteralNodeGen.create(LLVMNativePointer.createNull());
        }
        throw new AssertionError(type);
    }

    public static LLVMExpressionNode createBitcast(LLVMExpressionNode fromNode, Type targetType, Type fromType) {
        assert (targetType != null);
        if (targetType instanceof PrimitiveType) {
            return CommonNodeFactory.createBitcast(fromNode, ((PrimitiveType)targetType).getPrimitiveKind());
        }
        if (targetType instanceof PointerType || targetType instanceof FunctionType) {
            return LLVMToAddressNodeGen.create(fromNode);
        }
        if (targetType instanceof VariableBitWidthType) {
            return LLVMToVarINodeGen.LLVMBitcastToIVarNodeGen.create(fromNode, ((VariableBitWidthType)targetType).getBitSizeInt());
        }
        if (targetType instanceof VectorType) {
            VectorType fromVector;
            VectorType vectorType = (VectorType)targetType;
            Type elemType = vectorType.getElementType();
            int vectorLength = vectorType.getNumberOfElementsInt();
            if (elemType instanceof PrimitiveType) {
                switch (((PrimitiveType)elemType).getPrimitiveKind()) {
                    case I1: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToI1VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I8: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToI8VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I16: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToI16VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I32: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToI32VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I64: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToI64VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case FLOAT: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToFloatVectorNodeGen.create(fromNode, vectorLength);
                    }
                    case DOUBLE: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToDoubleVectorNodeGen.create(fromNode, vectorLength);
                    }
                }
            } else if (elemType instanceof PointerType && fromType instanceof VectorType && (fromVector = (VectorType)fromType).getNumberOfElements() == vectorType.getNumberOfElements() && fromVector.getElementType() instanceof PointerType) {
                return fromNode;
            }
        }
        throw CommonNodeFactory.unsupportedCast(targetType);
    }

    private static LLVMExpressionNode createBitcast(LLVMExpressionNode fromNode, PrimitiveType.PrimitiveKind kind) {
        switch (kind) {
            case I1: {
                return LLVMToI1NodeGen.LLVMBitcastToI1NodeGen.create(fromNode);
            }
            case I8: {
                return LLVMToI8NodeGen.LLVMBitcastToI8NodeGen.create(fromNode);
            }
            case I16: {
                return LLVMToI16NodeGen.LLVMBitcastToI16NodeGen.create(fromNode);
            }
            case I32: {
                return LLVMToI32NodeGen.LLVMBitcastToI32NodeGen.create(fromNode);
            }
            case I64: {
                return LLVMToI64NodeGen.LLVMBitcastToI64NodeGen.create(fromNode);
            }
            case FLOAT: {
                return LLVMToFloatNodeGen.LLVMBitcastToFloatNodeGen.create(fromNode);
            }
            case DOUBLE: {
                return LLVMToDoubleNodeGen.LLVMBitcastToDoubleNodeGen.create(fromNode);
            }
            case X86_FP80: {
                return LLVMTo80BitFloatingNodeGen.LLVMBitcastToLLVM80BitFloatNodeGen.create(fromNode);
            }
        }
        throw CommonNodeFactory.unsupportedCast(kind);
    }

    public static LLVMExpressionNode createUnsignedCast(LLVMExpressionNode fromNode, Type targetType) {
        if (targetType instanceof PrimitiveType) {
            return CommonNodeFactory.createUnsignedCast(fromNode, ((PrimitiveType)targetType).getPrimitiveKind());
        }
        if (targetType instanceof PointerType || targetType instanceof FunctionType) {
            return LLVMToAddressNodeGen.create(fromNode);
        }
        if (targetType instanceof VariableBitWidthType) {
            return LLVMToVarINodeGen.LLVMUnsignedCastToIVarNodeGen.create(fromNode, ((VariableBitWidthType)targetType).getBitSizeInt());
        }
        if (targetType instanceof VectorType) {
            VectorType vectorType = (VectorType)targetType;
            Type elemType = vectorType.getElementType();
            int vectorLength = vectorType.getNumberOfElementsInt();
            if (elemType instanceof PrimitiveType) {
                switch (((PrimitiveType)elemType).getPrimitiveKind()) {
                    case I1: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToI1VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I8: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToI8VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I16: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToI16VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I32: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToI32VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I64: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToI64VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case FLOAT: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToFloatVectorNodeGen.create(fromNode, vectorLength);
                    }
                    case DOUBLE: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToDoubleVectorNodeGen.create(fromNode, vectorLength);
                    }
                }
            } else if (elemType instanceof PointerType) {
                return LLVMToVectorNodeFactory.LLVMBitcastToPointerVectorNodeGen.create(fromNode, vectorLength);
            }
        }
        throw CommonNodeFactory.unsupportedCast(targetType);
    }

    public static LLVMExpressionNode createUnsignedCast(LLVMExpressionNode fromNode, PrimitiveType.PrimitiveKind kind) {
        switch (kind) {
            case I1: {
                return LLVMToI1NodeGen.LLVMSignedCastToI1NodeGen.create(fromNode);
            }
            case I8: {
                return LLVMToI8NodeGen.LLVMUnsignedCastToI8NodeGen.create(fromNode);
            }
            case I16: {
                return LLVMToI16NodeGen.LLVMUnsignedCastToI16NodeGen.create(fromNode);
            }
            case I32: {
                return LLVMToI32NodeGen.LLVMUnsignedCastToI32NodeGen.create(fromNode);
            }
            case I64: {
                return LLVMToI64NodeGen.LLVMUnsignedCastToI64NodeGen.create(fromNode);
            }
            case FLOAT: {
                return LLVMToFloatNodeGen.LLVMUnsignedCastToFloatNodeGen.create(fromNode);
            }
            case DOUBLE: {
                return LLVMToDoubleNodeGen.LLVMUnsignedCastToDoubleNodeGen.create(fromNode);
            }
            case X86_FP80: {
                return LLVMTo80BitFloatingNodeGen.LLVMUnsignedCastToLLVM80BitFloatNodeGen.create(fromNode);
            }
            case F128: {
                return LLVMTo128BitFloatingNodeGen.LLVMUnsignedCastToLLVM128BitFloatNodeGen.create(fromNode);
            }
        }
        throw CommonNodeFactory.unsupportedCast(kind);
    }

    public static LLVMExpressionNode createSignedCast(LLVMExpressionNode fromNode, Type targetType) {
        if (targetType instanceof PrimitiveType) {
            return CommonNodeFactory.createSignedCast(fromNode, ((PrimitiveType)targetType).getPrimitiveKind());
        }
        if (targetType instanceof VariableBitWidthType) {
            return LLVMToVarINodeGen.LLVMSignedCastToIVarNodeGen.create(fromNode, ((VariableBitWidthType)targetType).getBitSizeInt());
        }
        if (targetType instanceof VectorType) {
            VectorType vectorType = (VectorType)targetType;
            Type elemType = vectorType.getElementType();
            int vectorLength = vectorType.getNumberOfElementsInt();
            if (elemType instanceof PrimitiveType) {
                switch (((PrimitiveType)((VectorType)targetType).getElementType()).getPrimitiveKind()) {
                    case I1: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToI1VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I8: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToI8VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I16: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToI16VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I32: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToI32VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I64: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToI64VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case FLOAT: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToFloatVectorNodeGen.create(fromNode, vectorLength);
                    }
                    case DOUBLE: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToDoubleVectorNodeGen.create(fromNode, vectorLength);
                    }
                }
            }
        }
        throw CommonNodeFactory.unsupportedCast(targetType);
    }

    public static LLVMExpressionNode createSignedCast(LLVMExpressionNode fromNode, PrimitiveType.PrimitiveKind kind) {
        switch (kind) {
            case I1: {
                return LLVMToI1NodeGen.LLVMSignedCastToI1NodeGen.create(fromNode);
            }
            case I8: {
                return LLVMToI8NodeGen.LLVMSignedCastToI8NodeGen.create(fromNode);
            }
            case I16: {
                return LLVMToI16NodeGen.LLVMSignedCastToI16NodeGen.create(fromNode);
            }
            case I32: {
                return LLVMToI32NodeGen.LLVMSignedCastToI32NodeGen.create(fromNode);
            }
            case I64: {
                return LLVMToI64NodeGen.LLVMSignedCastToI64NodeGen.create(fromNode);
            }
            case FLOAT: {
                return LLVMToFloatNodeGen.LLVMSignedCastToFloatNodeGen.create(fromNode);
            }
            case DOUBLE: {
                return LLVMToDoubleNodeGen.LLVMSignedCastToDoubleNodeGen.create(fromNode);
            }
            case X86_FP80: {
                return LLVMTo80BitFloatingNodeGen.LLVMSignedCastToLLVM80BitFloatNodeGen.create(fromNode);
            }
            case F128: {
                return LLVMTo128BitFloatingNodeGen.LLVMSignedCastToLLVM128BitFloatNodeGen.create(fromNode);
            }
        }
        throw CommonNodeFactory.unsupportedCast(kind);
    }

    private static AssertionError unsupportedCast(Type targetType) {
        throw new LLVMParserException("Cannot cast to " + targetType);
    }

    private static AssertionError unsupportedCast(PrimitiveType.PrimitiveKind kind) {
        throw new LLVMParserException("Cannot cast to " + kind);
    }

    private static final class ElementPointerFactory {
        private final NodeFactory nodeFactory;
        private boolean wasVectorized;
        private int vectorLength;
        private LLVMExpressionNode currentAddress;
        private Type currentType;

        ElementPointerFactory(NodeFactory nodeFactory, LLVMExpressionNode currentAddress, Type currentType) {
            this.nodeFactory = nodeFactory;
            this.currentAddress = currentAddress;
            this.currentType = currentType;
            this.wasVectorized = currentType instanceof VectorType;
            if (this.wasVectorized) {
                VectorType vectorType = (VectorType)currentType;
                this.currentType = vectorType.getElementType();
                this.vectorLength = vectorType.getNumberOfElementsInt();
            }
        }

        public void addIndex(long indexedTypeLength, LLVMExpressionNode indexNode, Type indexType) {
            if (this.wasVectorized) {
                if (indexType instanceof VectorType) {
                    assert (this.vectorLength == ((VectorType)indexType).getNumberOfElementsInt());
                    this.currentAddress = this.nodeFactory.createVectorizedTypedElementPointer(indexedTypeLength, this.currentType, this.currentAddress, indexNode);
                } else {
                    this.currentAddress = this.nodeFactory.createVectorizedTypedElementPointer(indexedTypeLength, this.currentType, this.currentAddress, LLVMVectorizedGetElementPtrNodeGen.IndexVectorBroadcastNodeGen.create(this.vectorLength, indexNode));
                }
            } else if (indexType instanceof VectorType) {
                this.vectorLength = ((VectorType)indexType).getNumberOfElementsInt();
                this.wasVectorized = true;
                this.currentAddress = this.nodeFactory.createVectorizedTypedElementPointer(indexedTypeLength, this.currentType, LLVMVectorizedGetElementPtrNodeGen.ResultVectorBroadcastNodeGen.create(this.vectorLength, this.currentAddress), indexNode);
            } else {
                this.currentAddress = this.nodeFactory.createTypedElementPointer(indexedTypeLength, this.currentType, this.currentAddress, indexNode);
            }
        }
    }
}

