/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.llvm.runtime.DefaultLibraryLocator;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class CmdlineLibraryLocator
extends LibraryLocator {
    public static final CmdlineLibraryLocator INSTANCE = new CmdlineLibraryLocator();

    private CmdlineLibraryLocator() {
    }

    @Override
    public Object locateLibrary(LLVMContext context, String lib, Object reason) {
        TruffleFile file;
        Path libPath = Paths.get(lib, new String[0]);
        if (!libPath.isAbsolute() && (file = context.getEnv().getInternalTruffleFile(libPath.toUri())).exists(new LinkOption[0])) {
            return file;
        }
        return DefaultLibraryLocator.INSTANCE.locateLibrary(context, lib, reason);
    }
}

