/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class LandingpadInstruction
extends ValueInstruction {
    private SymbolImpl value;
    private final boolean isCleanup;
    private final long[] clauseTypes;
    private SymbolImpl[] clauseSymbols;

    private LandingpadInstruction(Type type, boolean isCleanup, long[] clauseTypes) {
        super(type);
        this.isCleanup = isCleanup;
        this.clauseTypes = clauseTypes;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getValue() {
        return this.value;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.value == original) {
            this.value = replacement;
        }
    }

    public boolean isCleanup() {
        return this.isCleanup;
    }

    public long[] getClauseTypes() {
        return this.clauseTypes;
    }

    public SymbolImpl[] getClauseSymbols() {
        return this.clauseSymbols;
    }

    public static LandingpadInstruction generate(SymbolTable symbols, Type type, boolean isCleanup, long[] clauseTypes, long[] clauseTODO) {
        LandingpadInstruction l = new LandingpadInstruction(type, isCleanup, clauseTypes);
        SymbolImpl[] s = new SymbolImpl[clauseTODO.length];
        for (int i = 0; i < clauseTODO.length; ++i) {
            s[i] = symbols.getForwardReferenced((int)clauseTODO[i], l);
        }
        l.clauseSymbols = s;
        return l;
    }
}

