/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.enums.AtomicOrdering;
import com.oracle.truffle.llvm.parser.model.enums.SynchronizationScope;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.AggregateType;

public final class CompareExchangeInstruction
extends ValueInstruction {
    private SymbolImpl ptr;
    private SymbolImpl cmp;
    private SymbolImpl replace;
    private final AtomicOrdering successOrdering;
    private final AtomicOrdering failureOrdering;
    private final SynchronizationScope synchronizationScope;
    private final boolean isWeak;
    private final boolean isVolatile;

    private CompareExchangeInstruction(AggregateType type, AtomicOrdering successOrdering, AtomicOrdering failureOrdering, SynchronizationScope synchronizationScope, boolean isWeak, boolean isVolatile) {
        super(type);
        this.successOrdering = successOrdering;
        this.failureOrdering = failureOrdering;
        this.synchronizationScope = synchronizationScope;
        this.isWeak = isWeak;
        this.isVolatile = isVolatile;
    }

    public SymbolImpl getPtr() {
        return this.ptr;
    }

    public SymbolImpl getCmp() {
        return this.cmp;
    }

    public SymbolImpl getReplace() {
        return this.replace;
    }

    public AggregateType getAggregateType() {
        return (AggregateType)super.getType();
    }

    public AtomicOrdering getSuccessOrdering() {
        return this.successOrdering;
    }

    public AtomicOrdering getFailureOrdering() {
        return this.failureOrdering;
    }

    public SynchronizationScope getSynchronizationScope() {
        return this.synchronizationScope;
    }

    public boolean isWeak() {
        return this.isWeak;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (original == this.ptr) {
            this.ptr = replacement;
        }
        if (original == this.cmp) {
            this.cmp = replacement;
        }
        if (original == this.replace) {
            this.replace = replacement;
        }
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public static CompareExchangeInstruction fromSymbols(SymbolTable symbols, AggregateType type, int ptr, int cmp, int replace, boolean isVolatile, long successOrderingId, long synchronizationScopeId, long failureOrderingId, boolean isWeak) {
        AtomicOrdering successOrdering = AtomicOrdering.decode(successOrderingId);
        SynchronizationScope synchronizationScope = SynchronizationScope.decode(synchronizationScopeId);
        AtomicOrdering failureOrdering = AtomicOrdering.getOrStrongestFailureOrdering(failureOrderingId, successOrdering);
        CompareExchangeInstruction cmpxchg = new CompareExchangeInstruction(type, successOrdering, failureOrdering, synchronizationScope, isWeak, isVolatile);
        cmpxchg.ptr = symbols.getForwardReferenced(ptr, cmpxchg);
        cmpxchg.cmp = symbols.getForwardReferenced(cmp, cmpxchg);
        cmpxchg.replace = symbols.getForwardReferenced(replace, cmpxchg);
        return cmpxchg;
    }
}

