/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDValue;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.IntegerConstant;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;

public final class MDSubrange
implements MDBaseNode {
    private MDBaseNode count = MDVoidNode.INSTANCE;
    private MDBaseNode lowerBound = MDVoidNode.INSTANCE;
    private MDBaseNode upperBound = MDVoidNode.INSTANCE;
    private MDBaseNode stride = MDVoidNode.INSTANCE;
    private static final int VERSION_SHIFT = 1;
    private static final int ARGINDEX_32_LOWERBOUND = 1;
    private static final int ARGINDEX_32_UPPERBOUND = 2;

    private MDSubrange() {
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public MDBaseNode getCount() {
        return this.count;
    }

    public MDBaseNode getLowerBound() {
        return this.lowerBound;
    }

    public MDBaseNode getUpperBound() {
        return this.upperBound;
    }

    public MDBaseNode getStride() {
        return this.stride;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        if (this.count == oldValue) {
            this.count = newValue;
        }
    }

    public static MDSubrange createNewFormat(RecordBuffer buffer, MetadataValueList md) {
        int version = (int)(buffer.read() >> 1);
        MDSubrange subrange = new MDSubrange();
        switch (version) {
            case 0: {
                subrange.count = MDValue.create(new IntegerConstant(PrimitiveType.I64, buffer.read()));
                subrange.lowerBound = MDValue.create(new IntegerConstant(PrimitiveType.I64, ParseUtil.unrotateSign(buffer.read())));
                break;
            }
            case 1: {
                subrange.count = md.getNullable(buffer.read(), subrange);
                subrange.lowerBound = MDValue.create(new IntegerConstant(PrimitiveType.I64, ParseUtil.unrotateSign(buffer.read())));
                break;
            }
            case 2: {
                subrange.count = md.getNullable(buffer.read(), subrange);
                subrange.lowerBound = md.getNullable(buffer.read(), subrange);
                subrange.upperBound = md.getNullable(buffer.read(), subrange);
                subrange.stride = md.getNullable(buffer.read(), subrange);
                break;
            }
            default: {
                throw new LLVMParserException("Invalid record: Unsupported version of DISubrange");
            }
        }
        return subrange;
    }

    public static MDSubrange createOldFormat(long[] args, Metadata md) {
        long lowerBound = ParseUtil.asLong(args, 1, md);
        long upperBound = ParseUtil.asLong(args, 2, md);
        long size = upperBound - lowerBound + 1L;
        MDSubrange subrange = new MDSubrange();
        subrange.count = MDValue.create(new IntegerConstant(PrimitiveType.I64, size));
        subrange.lowerBound = MDValue.create(new IntegerConstant(PrimitiveType.I64, lowerBound));
        return subrange;
    }
}

