/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDName;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;

public final class MDImportedEntity
extends MDName
implements MDBaseNode {
    private final long tag;
    private final long line;
    private MDBaseNode scope;
    private MDBaseNode entity;
    private static final int ARGINDEX_TAG = 1;
    private static final int ARGINDEX_SCOPE = 2;
    private static final int ARGINDEX_ENTITY = 3;
    private static final int ARGINDEX_LINE = 4;
    private static final int ARGINDEX_NAME = 5;

    private MDImportedEntity(long tag, long line) {
        this.tag = tag;
        this.line = line;
        this.scope = MDVoidNode.INSTANCE;
        this.entity = MDVoidNode.INSTANCE;
    }

    public long getTag() {
        return this.tag;
    }

    public MDBaseNode getScope() {
        return this.scope;
    }

    public MDBaseNode getEntity() {
        return this.entity;
    }

    public long getLine() {
        return this.line;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.scope == oldValue) {
            this.scope = newValue;
        }
        if (this.entity == oldValue) {
            this.entity = newValue;
        }
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public static MDImportedEntity create38(long[] args, MetadataValueList md) {
        long tag = args[1];
        long line = args[4];
        MDImportedEntity importedEntity = new MDImportedEntity(tag, line);
        importedEntity.scope = md.getNullable(args[2], importedEntity);
        importedEntity.entity = md.getNullable(args[3], importedEntity);
        importedEntity.setName(md.getNullable(args[5], importedEntity));
        return importedEntity;
    }
}

