/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories;

import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.inlineasm.InlineAssemblyParserBase;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public abstract class PlatformCapabilityBase<S extends Enum<S>>
extends PlatformCapability<S> {
    protected final boolean loadCxxLibraries;
    private final InlineAssemblyParserBase inlineAssemblyParser;

    public PlatformCapabilityBase(Class<S> cls, boolean loadCxxLibraries, InlineAssemblyParserBase inlineAssemblyParser) {
        super(cls);
        this.loadCxxLibraries = loadCxxLibraries;
        this.inlineAssemblyParser = inlineAssemblyParser;
    }

    @Override
    public String[] getSulongDefaultLibraries() {
        if (this.loadCxxLibraries) {
            return new String[]{this.getLibsulongFilename(), this.getLibsulongxxFilename()};
        }
        return new String[]{this.getLibsulongFilename()};
    }

    public abstract String getLibsulongxxFilename();

    public abstract String getLibsulongFilename();

    public abstract String getCxxFilename();

    public abstract String getCxxAbiFilename();

    private boolean isLibrary(String filename, String library) {
        String startsWith = library.substring(0, library.length() - this.getLibrarySuffix().length());
        return filename.startsWith(startsWith);
    }

    private boolean isCxxLibrary(String filename) {
        return this.isLibrary(filename, this.getCxxFilename()) || this.isLibrary(filename, this.getCxxAbiFilename());
    }

    @Override
    public List<String> preprocessDependencies(LLVMContext ctx, String libraryName, boolean isInternal, List<String> dependencies) {
        ArrayList<String> newDeps = null;
        boolean libSulongXXAdded = false;
        if (isInternal && this.isCxxLibrary(libraryName)) {
            newDeps = new ArrayList<String>(dependencies);
            newDeps.add(this.getLibsulongxxFilename());
            libSulongXXAdded = true;
        }
        for (int i = 0; i < dependencies.size(); ++i) {
            String filename;
            Path namePath;
            String dep = dependencies.get(i);
            if (dep.startsWith("/usr/lib/libc++") && (namePath = Paths.get(dep, new String[0]).getFileName()) != null && this.isCxxLibrary(filename = namePath.toString())) {
                if (newDeps == null) {
                    newDeps = new ArrayList<String>(dependencies);
                }
                newDeps.set(i, filename);
                dep = filename;
            }
            if (libSulongXXAdded || !this.isCxxLibrary(dep)) continue;
            if (newDeps == null) {
                newDeps = new ArrayList<String>(dependencies);
            }
            newDeps.add(this.getLibsulongxxFilename());
            libSulongXXAdded = true;
        }
        if (newDeps != null) {
            return newDeps;
        }
        return dependencies;
    }

    @Override
    public InlineAssemblyParserBase getInlineAssemblyParser() {
        return this.inlineAssemblyParser;
    }
}

