/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMScopeChain;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMThreadLocalSymbol;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMDLOpen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public class AllocExternalSymbolNode
extends LLVMNode {
    private final NodeFactory nodeFactory;

    public AllocExternalSymbolNode(LLVMParserResult result) {
        this.nodeFactory = result.getRuntime().getNodeFactory();
    }

    public LLVMPointer execute(LLVMScopeChain localScope, LLVMScopeChain globalScope, NativeContextExtension nativeContextExtension, LLVMContext context, LLVMDLOpen.RTLDFlags rtldFlags, LLVMGlobal global) {
        NativeContextExtension.NativePointerIntoLibrary pointer;
        LLVMPointer fromScope = AllocExternalSymbolNode.getFromScope(localScope, globalScope, context, rtldFlags, global);
        if (fromScope != null) {
            return fromScope;
        }
        if (global.isExternalWeak()) {
            return LLVMNativePointer.createNull();
        }
        if (nativeContextExtension != null && (pointer = AllocExternalSymbolNode.getNativePointer(nativeContextExtension, global)) != null) {
            return LLVMNativePointer.create(pointer.getAddress());
        }
        return null;
    }

    public LLVMPointer execute(LLVMScopeChain localScope, LLVMScopeChain globalScope, LLVMIntrinsicProvider intrinsicProvider, NativeContextExtension nativeContextExtension, LLVMContext context, LLVMDLOpen.RTLDFlags rtldFlags, LLVMFunction function) {
        NativeContextExtension.NativeLookupResult nativeFunction;
        LLVMPointer fromScope = AllocExternalSymbolNode.getFromScope(localScope, globalScope, context, rtldFlags, function);
        if (fromScope != null) {
            return fromScope;
        }
        if (function.isExternalWeak()) {
            return LLVMNativePointer.createNull();
        }
        if (intrinsicProvider != null && intrinsicProvider.isIntrinsified(function.getName())) {
            LLVMFunctionCode functionCode = new LLVMFunctionCode(function);
            LLVMFunctionDescriptor functionDescriptor = context.createFunctionDescriptor(function, functionCode);
            functionDescriptor.getFunctionCode().define(intrinsicProvider, this.nodeFactory);
            return LLVMManagedPointer.create(functionDescriptor);
        }
        if (intrinsicProvider != null && !intrinsicProvider.isIntrinsified(function.getName()) && nativeContextExtension != null && (nativeFunction = AllocExternalSymbolNode.getNativeFunction(nativeContextExtension, function)) != null) {
            LLVMFunctionDescriptor functionDescriptor = context.createFunctionDescriptor(function, new LLVMFunctionCode(function));
            functionDescriptor.getFunctionCode().define(new LLVMFunctionCode.NativeFunction(nativeFunction.getObject()));
            function.setNFISymbol(nativeFunction.getObject());
            return LLVMManagedPointer.create(functionDescriptor);
        }
        return null;
    }

    public LLVMPointer execute(LLVMScopeChain localScope, LLVMScopeChain globalScope, LLVMContext context, LLVMDLOpen.RTLDFlags rtldFlags, LLVMThreadLocalSymbol threadLocalSymbol) {
        return AllocExternalSymbolNode.getFromScope(localScope, globalScope, context, rtldFlags, threadLocalSymbol);
    }

    private static LLVMPointer getFromScope(LLVMScopeChain localScope, LLVMScopeChain globalScope, LLVMContext context, LLVMDLOpen.RTLDFlags rtldFlags, LLVMSymbol symbol) {
        LLVMPointer pointerFromLocal = AllocExternalSymbolNode.lookupFromScope(localScope, symbol, context);
        if (pointerFromLocal != null && AllocExternalSymbolNode.isDefaultFlagActive(rtldFlags)) {
            return pointerFromLocal;
        }
        LLVMPointer pointerFromGlobal = AllocExternalSymbolNode.lookupFromScope(globalScope, symbol, context);
        if (pointerFromGlobal != null) {
            return pointerFromGlobal;
        }
        return pointerFromLocal;
    }

    @CompilerDirectives.TruffleBoundary
    private static NativeContextExtension.NativeLookupResult getNativeFunction(NativeContextExtension nativeContextExtension, LLVMSymbol symbol) {
        return nativeContextExtension.getNativeFunctionOrNull(symbol.getName());
    }

    @CompilerDirectives.TruffleBoundary
    private static NativeContextExtension.NativePointerIntoLibrary getNativePointer(NativeContextExtension nativeContextExtension, LLVMSymbol symbol) {
        return nativeContextExtension.getNativeHandle(symbol.getName());
    }

    @CompilerDirectives.TruffleBoundary
    private static LLVMPointer lookupFromScope(LLVMScopeChain scope, LLVMSymbol symbol, LLVMContext context) {
        LLVMSymbol resultSymbol = scope.get(symbol.getName());
        if (resultSymbol == null) {
            return null;
        }
        LLVMPointer pointer = context.getSymbol(LLVMAlias.resolveAlias(resultSymbol), BranchProfile.getUncached());
        context.registerSymbol(symbol, pointer);
        return pointer;
    }

    private static boolean isDefaultFlagActive(LLVMDLOpen.RTLDFlags rtldFlags) {
        return LLVMDLOpen.RTLDFlags.RTLD_OPEN_DEFAULT.isActive(rtldFlags);
    }
}

