// CheckStyle: start generated
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;

/**
 * Debug Info: <pre>
 *   Specialization {@link UnwrapPromiseNode#fulfilled}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link UnwrapPromiseNode#rejected}
 *     Activation probability: 0.33333
 *     With/without class size: 8/0 bytes
 *   Specialization {@link UnwrapPromiseNode#pending}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre>
 */
@GeneratedBy(UnwrapPromiseNode.class)
@SuppressWarnings("javadoc")
public final class UnwrapPromiseNodeGen extends UnwrapPromiseNode {

    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link UnwrapPromiseNode#fulfilled}
     *   1: SpecializationActive {@link UnwrapPromiseNode#rejected}
     *   2: SpecializationActive {@link UnwrapPromiseNode#pending}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private UnwrapPromiseNodeGen() {
    }

    @Override
    protected Object execute(JSPromiseObject arg0Value, int arg1Value, Object arg2Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0 /* is SpecializationActive[UnwrapPromiseNode.fulfilled(JSPromiseObject, int, Object)] || SpecializationActive[UnwrapPromiseNode.rejected(JSPromiseObject, int, Object)] || SpecializationActive[UnwrapPromiseNode.pending(JSPromiseObject, int, Object)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[UnwrapPromiseNode.fulfilled(JSPromiseObject, int, Object)] */) {
                if ((arg1Value == JSPromise.FULFILLED)) {
                    return UnwrapPromiseNode.fulfilled(arg0Value, arg1Value, arg2Value);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[UnwrapPromiseNode.rejected(JSPromiseObject, int, Object)] */) {
                if ((arg1Value == JSPromise.REJECTED)) {
                    return rejected(arg0Value, arg1Value, arg2Value);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[UnwrapPromiseNode.pending(JSPromiseObject, int, Object)] */) {
                if ((arg1Value == JSPromise.PENDING)) {
                    return UnwrapPromiseNode.pending(arg0Value, arg1Value, arg2Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Object executeAndSpecialize(JSPromiseObject arg0Value, int arg1Value, Object arg2Value) {
        int state_0 = this.state_0_;
        if ((arg1Value == JSPromise.FULFILLED)) {
            state_0 = state_0 | 0b1 /* add SpecializationActive[UnwrapPromiseNode.fulfilled(JSPromiseObject, int, Object)] */;
            this.state_0_ = state_0;
            return UnwrapPromiseNode.fulfilled(arg0Value, arg1Value, arg2Value);
        }
        if ((arg1Value == JSPromise.REJECTED)) {
            state_0 = state_0 | 0b10 /* add SpecializationActive[UnwrapPromiseNode.rejected(JSPromiseObject, int, Object)] */;
            this.state_0_ = state_0;
            return rejected(arg0Value, arg1Value, arg2Value);
        }
        if ((arg1Value == JSPromise.PENDING)) {
            state_0 = state_0 | 0b100 /* add SpecializationActive[UnwrapPromiseNode.pending(JSPromiseObject, int, Object)] */;
            this.state_0_ = state_0;
            return UnwrapPromiseNode.pending(arg0Value, arg1Value, arg2Value);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
    }

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException3LIL(Node thisNode_, Object arg0Value, int arg1Value, Object arg2Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value);
    }

    @NeverDefault
    public static UnwrapPromiseNode create() {
        return new UnwrapPromiseNodeGen();
    }

    @NeverDefault
    public static UnwrapPromiseNode getUncached() {
        return UnwrapPromiseNodeGen.UNCACHED;
    }

    @GeneratedBy(UnwrapPromiseNode.class)
    @DenyReplace
    private static final class Uncached extends UnwrapPromiseNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        protected Object execute(JSPromiseObject arg0Value, int arg1Value, Object arg2Value) {
            if ((arg1Value == JSPromise.FULFILLED)) {
                return UnwrapPromiseNode.fulfilled(arg0Value, arg1Value, arg2Value);
            }
            if ((arg1Value == JSPromise.REJECTED)) {
                return rejected(arg0Value, arg1Value, arg2Value);
            }
            if ((arg1Value == JSPromise.PENDING)) {
                return UnwrapPromiseNode.pending(arg0Value, arg1Value, arg2Value);
            }
            throw newUnsupportedSpecializationException3LIL(this, arg0Value, arg1Value, arg2Value);
        }

    }
}
