/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalManagementRegistration;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.management.HotSpotGraalRuntimeMBean;
import org.graalvm.compiler.serviceprovider.ServiceProvider;

@ServiceProvider(value=HotSpotGraalManagementRegistration.class)
public final class HotSpotGraalManagement
implements HotSpotGraalManagementRegistration {
    private HotSpotGraalRuntimeMBean bean;
    private volatile boolean needsRegistration = true;
    HotSpotGraalManagement nextDeferred;
    private static final RegistrationThread registration = new RegistrationThread();

    public void initialize(HotSpotGraalRuntime runtime, GraalHotSpotVMConfig config) {
        if (this.bean == null) {
            if (runtime.getManagement() != this) {
                throw new IllegalArgumentException("Cannot initialize a second management object for runtime " + runtime.getName());
            }
            try {
                String name = runtime.getName().replace(':', '_');
                ObjectName objectName = new ObjectName("org.graalvm.compiler.hotspot:type=" + name);
                this.bean = new HotSpotGraalRuntimeMBean(objectName, runtime);
                registration.add(this);
            }
            catch (MalformedObjectNameException err) {
                err.printStackTrace(TTY.out);
            }
        } else if (this.bean.getRuntime() != runtime) {
            throw new IllegalArgumentException("Cannot change the runtime a management interface is associated with");
        }
    }

    public ObjectName poll(boolean sync) {
        if (sync) {
            registration.poll();
        }
        if (this.bean == null || this.needsRegistration) {
            return null;
        }
        return this.bean.getObjectName();
    }

    static final class RegistrationThread
    extends Thread {
        private MBeanServer platformMBeanServer;
        private HotSpotGraalManagement deferred;
        private static final int POLL_INTERVAL_MS = 2000;

        RegistrationThread() {
            super("HotSpotGraalManagement Bean Registration");
            this.setPriority(1);
            this.setDaemon(true);
            this.start();
        }

        synchronized void add(HotSpotGraalManagement e) {
            if (this.deferred != null) {
                e.nextDeferred = this.deferred;
            }
            this.deferred = e;
            this.notify();
        }

        private void process() {
            HotSpotGraalManagement m = this.deferred;
            while (m != null) {
                HotSpotGraalRuntimeMBean bean = m.bean;
                if (m.needsRegistration && bean != null) {
                    try {
                        this.platformMBeanServer.registerMBean(bean, bean.getObjectName());
                    }
                    catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
                        e.printStackTrace(TTY.out);
                        m.bean = null;
                    }
                    m.needsRegistration = false;
                }
                m = m.nextDeferred;
            }
            this.deferred = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        RegistrationThread registrationThread = this;
                        synchronized (registrationThread) {
                            while (this.deferred == null) {
                                this.wait();
                            }
                        }
                        this.poll();
                        Thread.sleep(2000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace(TTY.out);
                    continue;
                }
                break;
            }
        }

        synchronized void poll() {
            if (this.platformMBeanServer == null) {
                try {
                    ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
                    if (!servers.isEmpty()) {
                        this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                        this.process();
                    }
                }
                catch (NoClassDefFoundError | SecurityException | UnsatisfiedLinkError | UnsupportedOperationException e) {
                    this.deferred = null;
                }
            } else {
                this.process();
            }
        }
    }
}

