/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.agent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graalvm.buildtools.agent.AgentMode;
import org.graalvm.buildtools.agent.DisabledAgentMode;

public class AgentConfiguration
implements Serializable {
    private final Collection<String> callerFilterFiles;
    private final Collection<String> accessFilterFiles;
    private final Boolean builtinCallerFilter;
    private final Boolean builtinHeuristicFilter;
    private final Boolean experimentalPredefinedClasses;
    private final Boolean experimentalUnsafeAllocationTracing;
    private final Boolean trackReflectionMetadata;
    private final AgentMode agentMode;

    public AgentConfiguration(AgentMode ... modes) {
        this.callerFilterFiles = null;
        this.accessFilterFiles = null;
        this.builtinCallerFilter = null;
        this.builtinHeuristicFilter = null;
        this.experimentalPredefinedClasses = null;
        this.experimentalUnsafeAllocationTracing = null;
        this.trackReflectionMetadata = null;
        this.agentMode = modes.length == 1 ? modes[0] : new DisabledAgentMode();
    }

    public AgentConfiguration(Collection<String> callerFilterFiles, Collection<String> accessFilterFiles, Boolean builtinCallerFilter, Boolean builtinHeuristicFilter, Boolean experimentalPredefinedClasses, Boolean experimentalUnsafeAllocationTracing, Boolean trackReflectionMetadata, AgentMode agentMode) {
        this.callerFilterFiles = callerFilterFiles;
        this.accessFilterFiles = accessFilterFiles;
        this.builtinCallerFilter = builtinCallerFilter;
        this.builtinHeuristicFilter = builtinHeuristicFilter;
        this.experimentalPredefinedClasses = experimentalPredefinedClasses;
        this.experimentalUnsafeAllocationTracing = experimentalUnsafeAllocationTracing;
        this.trackReflectionMetadata = trackReflectionMetadata;
        this.agentMode = agentMode;
    }

    public List<String> getAgentCommandLine() {
        ArrayList<String> cmdLine = new ArrayList<String>(this.agentMode.getAgentCommandLine());
        AgentConfiguration.appendOptionToValues("caller-filter-file=", this.callerFilterFiles, cmdLine);
        AgentConfiguration.appendOptionToValues("access-filter-file=", this.accessFilterFiles, cmdLine);
        this.addToCmd("builtin-caller-filter=", this.builtinCallerFilter, cmdLine);
        this.addToCmd("builtin-heuristic-filter=", this.builtinHeuristicFilter, cmdLine);
        this.addToCmd("experimental-class-define-support=", this.experimentalPredefinedClasses, cmdLine);
        this.addToCmd("experimental-unsafe-allocation-support=", this.experimentalUnsafeAllocationTracing, cmdLine);
        this.addToCmd("track-reflection-metadata=", this.trackReflectionMetadata, cmdLine);
        return cmdLine;
    }

    public Collection<String> getAgentFiles() {
        ArrayList<String> files = new ArrayList<String>(this.callerFilterFiles.size() + this.accessFilterFiles.size());
        files.addAll(this.callerFilterFiles);
        files.addAll(this.accessFilterFiles);
        files.addAll(this.agentMode.getInputFiles());
        return files;
    }

    public boolean isEnabled() {
        return !(this.agentMode instanceof DisabledAgentMode);
    }

    public static void appendOptionToValues(String option, Collection<String> values, Collection<String> target) {
        if (values != null) {
            values.stream().map(value -> option + value).forEach(target::add);
        }
    }

    public AgentMode getAgentMode() {
        return this.agentMode;
    }

    private void addToCmd(String option, Boolean value, List<String> cmdLine) {
        if (value != null) {
            cmdLine.add(option + value);
        }
    }
}

