/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graalvm.buildtools.utils.SharedConstants;

public class NativeImageUtils {
    public static final String ORACLE_GRAALVM_IDENTIFIER = "Oracle GraalVM";
    private static final Pattern requiredVersionPattern = Pattern.compile("^([0-9]+)(?:\\.([0-9]+)?)?(?:\\.([0-9]+)?)?$");
    private static final Pattern graalvmVersionPattern = Pattern.compile("^(GraalVM|native-image) ([0-9]+)\\.([0-9]+)\\.([0-9]+).*");
    private static final Pattern javaVersionPattern = Pattern.compile("^native-image ([0-9]+).*", 32);
    private static final Pattern javaVersionLegacyPattern = Pattern.compile(".* \\(Java Version ([0-9]+)\\.([0-9]+)\\.([0-9]+).*");
    private static final Pattern SAFE_SHELL_ARG = Pattern.compile("[A-Za-z0-9@%_\\-+=:,./]+");

    public static void maybeCreateConfigureUtilSymlink(File configureUtilFile, Path nativeImageExecutablePath) {
        if (!configureUtilFile.exists()) {
            Path target = configureUtilFile.toPath();
            Path source = nativeImageExecutablePath.getParent().getParent().resolve("lib/svm/bin/" + NativeImageUtils.nativeImageConfigureFileName());
            if (Files.exists(source, new LinkOption[0])) {
                try {
                    Files.createLink(target, source);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static String nativeImageConfigureFileName() {
        return "native-image-configure" + SharedConstants.GRAALVM_EXE_EXTENSION;
    }

    public static List<String> convertToArgsFile(List<String> cliArgs, Path outputDir) {
        return NativeImageUtils.convertToArgsFile(cliArgs, outputDir, Paths.get("", new String[0]));
    }

    public static List<String> convertToArgsFile(List<String> cliArgs, Path outputDir, Path projectDir) {
        try {
            boolean ignored = outputDir.toFile().mkdirs();
            File tmpFile = Files.createTempFile(outputDir, "native-image-", ".args", new FileAttribute[0]).toFile();
            cliArgs = cliArgs.stream().map(NativeImageUtils::escapeArg).collect(Collectors.toList());
            Files.write(tmpFile.toPath(), cliArgs, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
            Path resultingPath = tmpFile.toPath().toAbsolutePath();
            if (projectDir != null) {
                resultingPath = projectDir.toAbsolutePath().relativize(resultingPath);
            }
            return Collections.singletonList("@" + resultingPath);
        }
        catch (IOException e) {
            return Collections.unmodifiableList(cliArgs);
        }
    }

    public static String escapeArg(String arg) {
        if (!(((String)arg).startsWith("\\Q") && ((String)arg).endsWith("\\E") || !((String)(arg = ((String)arg).replace("\\", "\\\\"))).contains(" "))) {
            arg = "\"" + (String)arg + "\"";
        }
        return arg;
    }

    public static void checkVersion(String requiredVersion, String versionToCheck) {
        if (versionToCheck.contains("GraalVM Runtime Environment")) {
            return;
        }
        if (versionToCheck.startsWith("native-image") && versionToCheck.contains("dev") || versionToCheck.startsWith("GraalVM dev")) {
            return;
        }
        Matcher requiredMatcher = requiredVersionPattern.matcher(requiredVersion);
        if (!requiredMatcher.matches()) {
            throw new IllegalArgumentException("Invalid version " + requiredVersion + ", should be for example \"22\", \"22.3\" or \"22.3.0\".");
        }
        Matcher checkedMatcher = graalvmVersionPattern.matcher(versionToCheck.trim());
        if (!checkedMatcher.matches()) {
            throw new IllegalArgumentException("Version to check '" + versionToCheck + "' can't be parsed.");
        }
        int requiredMajor = Integer.parseInt(requiredMatcher.group(1));
        int checkedMajor = Integer.parseInt(checkedMatcher.group(2));
        if (checkedMajor < requiredMajor) {
            throw new IllegalStateException("GraalVM version " + requiredMajor + " is required but " + checkedMajor + " has been detected, please upgrade.");
        }
        if (checkedMajor > requiredMajor) {
            return;
        }
        if (requiredMatcher.group(2) != null) {
            int requiredMinor = Integer.parseInt(requiredMatcher.group(2));
            int checkedMinor = Integer.parseInt(checkedMatcher.group(3));
            if (checkedMinor < requiredMinor) {
                throw new IllegalStateException("GraalVM version " + requiredMajor + "." + requiredMinor + " is required but " + checkedMajor + "." + checkedMinor + " has been detected, please upgrade.");
            }
            if (checkedMinor > requiredMinor) {
                return;
            }
            if (requiredMatcher.group(3) != null) {
                int requiredPatch = Integer.parseInt(requiredMatcher.group(3));
                int checkedPatch = Integer.parseInt(checkedMatcher.group(4));
                if (checkedPatch < requiredPatch) {
                    throw new IllegalStateException("GraalVM version " + requiredMajor + "." + requiredMinor + "." + requiredPatch + " is required but " + checkedMajor + "." + checkedMinor + "." + checkedPatch + " has been detected, please upgrade.");
                }
            }
        }
    }

    public static int getMajorJDKVersion(String versionString) {
        String trimmedVersionString = versionString.trim();
        Matcher matcher = javaVersionPattern.matcher(versionString.trim());
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        Matcher legacyMatcher = javaVersionLegacyPattern.matcher(trimmedVersionString);
        if (legacyMatcher.matches()) {
            return Integer.parseInt(legacyMatcher.group(1));
        }
        return -1;
    }
}

