/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven.config.agent;

import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;
import org.graalvm.buildtools.agent.AgentMode;
import org.graalvm.buildtools.agent.ConditionalAgentMode;
import org.graalvm.buildtools.agent.DirectAgentMode;
import org.graalvm.buildtools.agent.StandardAgentMode;
import org.graalvm.buildtools.maven.config.agent.AgentOptionsConfiguration;
import org.graalvm.buildtools.maven.config.agent.MetadataCopyConfiguration;
import org.graalvm.buildtools.maven.config.agent.ModesConfiguration;

public class AgentConfiguration
extends org.graalvm.buildtools.agent.AgentConfiguration {
    @Parameter
    private boolean enabled;
    @Parameter(defaultValue="standard")
    private String defaultMode;
    @Parameter
    private ModesConfiguration modes;
    @Parameter
    private AgentOptionsConfiguration options;
    @Parameter
    private MetadataCopyConfiguration metadataCopy;

    public AgentConfiguration() {
        super(new AgentMode[0]);
    }

    public MetadataCopyConfiguration getMetadataCopyConfiguration() {
        if (this.metadataCopy != null) {
            return this.metadataCopy;
        }
        return new MetadataCopyConfiguration();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public AgentMode getAgentMode() {
        String directMode;
        Properties conditionalMode;
        if (this.defaultMode == null) {
            return new StandardAgentMode();
        }
        if (this.defaultMode.equalsIgnoreCase("standard")) {
            return new StandardAgentMode();
        }
        if (this.defaultMode.equalsIgnoreCase("conditional") && (conditionalMode = this.modes.getConditional()) != null) {
            return new ConditionalAgentMode(conditionalMode.getProperty("userCodeFilterPath"), conditionalMode.getProperty("extraFilterPath", ""), Boolean.parseBoolean(conditionalMode.getProperty("parallel")));
        }
        if (this.defaultMode.equalsIgnoreCase("direct") && (directMode = this.modes.getDirect()) != null) {
            return new DirectAgentMode(Arrays.stream(directMode.split(" ")).collect(Collectors.toList()));
        }
        throw new IllegalArgumentException("Default agent mode " + this.defaultMode + ", provided in pom.xml is not supported. Please choose one of the following modes: standard, conditional or direct");
    }

    public String getDefaultMode() {
        return this.defaultMode != null ? this.defaultMode : "standard";
    }

    public ModesConfiguration getModes() {
        return this.modes;
    }

    public AgentOptionsConfiguration getOptions() {
        return this.options;
    }
}

