/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.codehaus.plexus.logging.Logger;
import org.graalvm.buildtools.utils.NativeImageUtils;

public abstract class AbstractMergeAgentFilesMojo
extends AbstractMojo {
    @Component
    protected Logger logger;
    protected File mergerExecutable;

    protected void tryInstallMergeExecutable(Path nativeImageExecutablePath) {
        if (this.mergerExecutable != null && this.mergerExecutable.exists()) {
            return;
        }
        File nativeImageExecutable = nativeImageExecutablePath.toAbsolutePath().toFile();
        File mergerExecutable = new File(nativeImageExecutable.getParentFile(), NativeImageUtils.nativeImageConfigureFileName());
        if (!mergerExecutable.exists()) {
            this.getLog().info((CharSequence)("Installing native image merger to " + mergerExecutable));
            ProcessBuilder processBuilder = new ProcessBuilder(nativeImageExecutable.toString());
            processBuilder.command().add("--macro:native-image-configure-launcher");
            processBuilder.directory(mergerExecutable.getParentFile());
            processBuilder.inheritIO();
            try {
                Process installProcess = processBuilder.start();
                if (installProcess.waitFor() != 0) {
                    this.getLog().warn((CharSequence)"Installation of native image merging tool failed");
                }
                NativeImageUtils.maybeCreateConfigureUtilSymlink((File)mergerExecutable, (Path)nativeImageExecutablePath);
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        this.mergerExecutable = mergerExecutable;
    }
}

