/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven.sbom;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.graalvm.buildtools.maven.sbom.ArtifactAdapter;
import org.graalvm.buildtools.maven.sbom.ArtifactToPackageNameResolver;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public final class SBOMGenerator {
    public static final int requiredNativeImageVersion = 24;
    private final MavenProject mavenProject;
    private final MavenSession mavenSession;
    private final BuildPluginManager pluginManager;
    private final RepositorySystem repositorySystem;
    private final String mainClass;
    private final Logger logger;
    private static final String SBOM_FILE_FORMAT = "json";
    private static final String SBOM_FILENAME_WITHOUT_EXTENSION = "base_sbom";
    private final String outputDirectory;
    public static final String SBOM_FILENAME = "base_sbom.json";

    public SBOMGenerator(MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, RepositorySystem repositorySystem, String mainClass, Logger logger) {
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.pluginManager = pluginManager;
        this.repositorySystem = repositorySystem;
        this.mainClass = mainClass;
        this.logger = logger;
        this.outputDirectory = mavenProject.getBuild().getDirectory();
    }

    public static boolean checkAugmentedSBOMSupportedByJDKVersion(int detectedJdkVersion, boolean throwErrorIfNotSupported) throws IllegalArgumentException {
        if (detectedJdkVersion < 24) {
            if (throwErrorIfNotSupported) {
                throw new IllegalArgumentException(String.format("%s version %s is required to use configuration option %s but major JDK version %s has been detected.", "Oracle GraalVM", 24, "augmentedSBOM", detectedJdkVersion));
            }
            return false;
        }
        return true;
    }

    public void generate() throws MojoExecutionException {
        Path sbomPath = Paths.get(this.outputDirectory, SBOM_FILENAME);
        try {
            int loggingLevel = this.logger.getThreshold();
            this.logger.setThreshold(5);
            MojoExecutor.executeMojo((org.apache.maven.model.Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.cyclonedx"), (String)MojoExecutor.artifactId((String)"cyclonedx-maven-plugin"), (String)MojoExecutor.version((String)"2.8.1")), (String)MojoExecutor.goal((String)"makeAggregateBom"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputFormat"), (String)SBOM_FILE_FORMAT), MojoExecutor.element((String)MojoExecutor.name((String)"outputName"), (String)SBOM_FILENAME_WITHOUT_EXTENSION), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.outputDirectory), MojoExecutor.element((String)MojoExecutor.name((String)"skipNotDeployed"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"schemaVersion"), (String)"1.5")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
            this.logger.setThreshold(loggingLevel);
            if (!Files.exists(sbomPath, new LinkOption[0])) {
                return;
            }
            ArtifactToPackageNameResolver resolver = new ArtifactToPackageNameResolver(this.mavenProject, this.repositorySystem, this.mavenSession.getRepositorySession(), this.mainClass);
            Set<ArtifactAdapter> artifacts = resolver.getArtifactAdapters();
            this.augmentSBOM(sbomPath, artifacts);
        }
        catch (Exception exception) {
            SBOMGenerator.deleteFileIfExists(sbomPath);
            String errorMsg = String.format("Failed to create SBOM. Please try again and report this issue if it persists. To bypass this failure, disable SBOM generation by setting configuration option %s to false.", "augmentedSBOM");
            throw new MojoExecutionException(errorMsg, exception);
        }
    }

    private static void deleteFileIfExists(Path sbomPath) {
        try {
            Files.deleteIfExists(sbomPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void augmentSBOM(Path baseSBOMPath, Set<ArtifactAdapter> artifacts) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode sbomJson = (ObjectNode)objectMapper.readTree(Files.newInputStream(baseSBOMPath, new OpenOption[0]));
        ArrayNode componentsArray = (ArrayNode)sbomJson.get("components");
        if (componentsArray == null) {
            throw new RuntimeException(String.format("SBOM generated by %s:%s contained no components.", "org.cyclonedx", "cyclonedx-maven-plugin"));
        }
        componentsArray.forEach(componentNode -> this.augmentComponentNode((JsonNode)componentNode, artifacts, objectMapper));
        JsonNode metadataNode = sbomJson.get("metadata");
        if (metadataNode != null && metadataNode.has("component")) {
            this.augmentComponentNode(metadataNode.get("component"), artifacts, objectMapper);
        }
        objectMapper.writerWithDefaultPrettyPrinter().writeValue(Files.newOutputStream(baseSBOMPath, new OpenOption[0]), (Object)sbomJson);
    }

    private void augmentComponentNode(JsonNode componentNode, Set<ArtifactAdapter> artifactsWithPackageNames, ObjectMapper objectMapper) {
        String groupField = "group";
        String nameField = "name";
        String versionField = "version";
        if (componentNode.has(groupField) && componentNode.has(nameField) && componentNode.has(versionField)) {
            String groupId = componentNode.get(groupField).asText();
            String artifactId = componentNode.get(nameField).asText();
            String version = componentNode.get(versionField).asText();
            Optional<ArtifactAdapter> optionalArtifact = artifactsWithPackageNames.stream().filter(artifact -> artifact.groupId.equals(groupId) && artifact.artifactId.equals(artifactId) && artifact.version.equals(version)).findFirst();
            if (optionalArtifact.isPresent()) {
                ArtifactAdapter artifact2 = optionalArtifact.get();
                ArrayNode packageNamesArray = objectMapper.createArrayNode();
                List<String> sortedPackageNames = artifact2.packageNames.stream().sorted().collect(Collectors.toList());
                sortedPackageNames.forEach(arg_0 -> ((ArrayNode)packageNamesArray).add(arg_0));
                ((ObjectNode)componentNode).set("packageNames", (JsonNode)packageNamesArray);
                String jarPath = "";
                if (artifact2.jarPath != null) {
                    jarPath = artifact2.jarPath.toString();
                }
                ((ObjectNode)componentNode).put("jarPath", jarPath);
                ((ObjectNode)componentNode).put("prunable", artifact2.prunable);
            }
        }
    }

    private static final class Plugin {
        static final String artifactId = "cyclonedx-maven-plugin";
        static final String groupId = "org.cyclonedx";
        static final String version = "2.8.1";
        static final String goal = "makeAggregateBom";

        private Plugin() {
        }

        private static final class Configuration {
            static final String outputFormat = "json";
            static final String outputName = "base_sbom";
            static final String skipNotDeployed = "false";
            static final String schemaVersion = "1.5";

            private Configuration() {
            }
        }
    }

    private static final class AddedComponentFields {
        static final String packageNames = "packageNames";
        static final String jarPath = "jarPath";
        static final String prunable = "prunable";

        private AddedComponentFields() {
        }
    }
}

