/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.CommandLineArgumentProvider;

public abstract class AgentCommandLineProvider
implements CommandLineArgumentProvider {
    @Inject
    public AgentCommandLineProvider() {
    }

    @Input
    public abstract Property<Boolean> getEnabled();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getInputFiles();

    @Input
    public abstract ListProperty<String> getFilterableEntries();

    @Input
    public abstract Property<String> getAgentMode();

    @Input
    @Optional
    public abstract ListProperty<String> getAgentOptions();

    public Iterable<String> asArguments() {
        if (((Boolean)this.getEnabled().get()).booleanValue()) {
            String outputDirPath = ((File)this.getOutputDirectory().getAsFile().get()).getAbsolutePath() + File.separator + "session-{pid}-{datetime}";
            List agentOptions = ((List)this.getAgentOptions().get()).stream().map(opt -> opt.replace("{output_dir}", outputDirPath)).collect(Collectors.toList());
            return Arrays.asList("-agentlib:native-image-agent=" + String.join((CharSequence)",", agentOptions), "-Dorg.graalvm.nativeimage.imagecode=agent");
        }
        return Collections.emptyList();
    }
}

