/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.xmlparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.MyEntityResolver;
import org.apache.jasper.xmlparser.MyErrorHandler;
import org.apache.jasper.xmlparser.MyLSResourceResolver;
import org.apache.jasper.xmlparser.TreeNode;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserUtils {
    static Logger log = Logger.getLogger(ParserUtils.class.getName());
    private static ErrorHandler errorHandler = new MyErrorHandler();
    static EntityResolver entityResolver = new MyEntityResolver();
    static String schemaResourcePrefix;
    static String dtdResourcePrefix;
    static boolean isDtdResourcePrefixFileUrl;
    static boolean isSchemaResourcePrefixFileUrl;
    private static final String SCHEMA_LOCATION_ATTR = "schemaLocation";
    private static HashMap<String, Schema> schemaCache;
    static final String[] CACHED_DTD_PUBLIC_IDS;
    private static final String[] DEFAULT_DTD_RESOURCE_PATHS;
    static final String[] CACHED_DTD_RESOURCE_PATHS;
    private static final String[] DEFAULT_SCHEMA_RESOURCE_PATHS;
    static final String[] CACHED_SCHEMA_RESOURCE_PATHS;

    public static void setEntityResolver(EntityResolver er) {
        entityResolver = er;
    }

    public static void setSchemaResourcePrefix(String prefix) {
        if (prefix != null && prefix.startsWith("file:")) {
            schemaResourcePrefix = ParserUtils.uencode(prefix);
            isSchemaResourcePrefixFileUrl = true;
        } else {
            schemaResourcePrefix = prefix;
            isSchemaResourcePrefixFileUrl = false;
        }
        for (int i = 0; i < CACHED_SCHEMA_RESOURCE_PATHS.length; ++i) {
            String path = DEFAULT_SCHEMA_RESOURCE_PATHS[i];
            int index = path.lastIndexOf(47);
            if (index == -1) continue;
            ParserUtils.CACHED_SCHEMA_RESOURCE_PATHS[i] = schemaResourcePrefix + path.substring(index + 1);
        }
    }

    public static void setDtdResourcePrefix(String prefix) {
        if (prefix != null && prefix.startsWith("file:")) {
            dtdResourcePrefix = ParserUtils.uencode(prefix);
            isDtdResourcePrefixFileUrl = true;
        } else {
            dtdResourcePrefix = prefix;
            isDtdResourcePrefixFileUrl = false;
        }
        for (int i = 0; i < CACHED_DTD_RESOURCE_PATHS.length; ++i) {
            String path = DEFAULT_DTD_RESOURCE_PATHS[i];
            int index = path.lastIndexOf(47);
            if (index == -1) continue;
            ParserUtils.CACHED_DTD_RESOURCE_PATHS[i] = dtdResourcePrefix + path.substring(index + 1);
        }
    }

    private static String uencode(String prefix) {
        if (prefix != null && prefix.startsWith("file:")) {
            StringTokenizer tokens = new StringTokenizer(prefix, "/\\:", true);
            StringBuilder stringBuilder = new StringBuilder();
            while (tokens.hasMoreElements()) {
                String token = tokens.nextToken();
                if ("/".equals(token) || "\\".equals(token) || ":".equals(token)) {
                    stringBuilder.append(token);
                    continue;
                }
                try {
                    stringBuilder.append(URLEncoder.encode(token, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            return stringBuilder.toString();
        }
        return prefix;
    }

    public TreeNode parseXMLDocument(String uri, InputSource is) throws JasperException {
        return this.parseXMLDocument(uri, is, false);
    }

    public TreeNode parseXMLDocument(String uri, InputSource is, boolean validate) throws JasperException {
        Document document = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            block7: {
                try {
                    Schema schema;
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    builder.setEntityResolver(entityResolver);
                    builder.setErrorHandler(errorHandler);
                    document = builder.parse(is);
                    document.setDocumentURI(uri);
                    if (!validate || (schema = ParserUtils.getSchema(document)) == null) break block7;
                    schema.newValidator().validate(new DOMSource(document));
                }
                catch (ParserConfigurationException ex) {
                    throw new JasperException(Localizer.getMessage("jsp.error.parse.xml", uri), ex);
                }
                catch (SAXParseException ex) {
                    throw new JasperException(Localizer.getMessage("jsp.error.parse.xml.line", uri, Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber())), ex);
                }
                catch (SAXException sx) {
                    throw new JasperException(Localizer.getMessage("jsp.error.parse.xml", uri), sx);
                }
                catch (IOException io) {
                    throw new JasperException(Localizer.getMessage("jsp.error.parse.xml", uri), io);
                }
            }
            Object var10_13 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            throw throwable;
        }
        return this.convert(null, document.getDocumentElement());
    }

    public TreeNode parseXMLDocument(String uri, InputStream is) throws JasperException {
        return this.parseXMLDocument(uri, new InputSource(is), false);
    }

    public TreeNode parseXMLDocument(String uri, InputStream is, boolean validate) throws JasperException {
        return this.parseXMLDocument(uri, new InputSource(is), validate);
    }

    protected TreeNode convert(TreeNode parent, Node node) {
        NodeList children;
        TreeNode treeNode = new TreeNode(node.getNodeName(), parent);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Node attribute = attributes.item(i);
                treeNode.addAttribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = children.item(i);
                if (child instanceof Comment) continue;
                if (child instanceof Text) {
                    String body = ((Text)child).getData();
                    if (body == null || (body = body.trim()).length() <= 0) continue;
                    treeNode.setBody(body);
                    continue;
                }
                TreeNode treeNode2 = this.convert(treeNode, child);
            }
        }
        return treeNode;
    }

    private static Schema getSchema(Document document) throws SAXException, JasperException {
        Schema schema = null;
        Element root = document.getDocumentElement();
        NamedNodeMap map = root.getAttributes();
        for (int i = 0; map != null && i < map.getLength(); ++i) {
            if (!SCHEMA_LOCATION_ATTR.equals(map.item(i).getLocalName())) continue;
            String schemaLocation = map.item(i).getNodeValue();
            if ("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd".equals(schemaLocation)) {
                schema = ParserUtils.getSchema("web-jsptaglibrary_2_0.xsd");
                break;
            }
            if ("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-jsptaglibrary_2_1.xsd".equals(schemaLocation)) {
                schema = ParserUtils.getSchema("web-jsptaglibrary_2_1.xsd");
                break;
            }
            if ("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd".equals(schemaLocation)) {
                schema = ParserUtils.getSchema("web-app_2_4.xsd");
                break;
            }
            if ("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd".equals(schemaLocation)) {
                schema = ParserUtils.getSchema("web-app_2_5.xsd");
                break;
            }
            throw new JasperException(Localizer.getMessage("jsp.error.parse.unknownTldSchemaLocation", document.getDocumentURI(), map.item(i).getNodeValue()));
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static Schema getSchema(String schemaPublicId) throws SAXException {
        schema = ParserUtils.schemaCache.get(schemaPublicId);
        if (schema == null) {
            var2_2 = ParserUtils.schemaCache;
            synchronized (var2_2) {
                schema = ParserUtils.schemaCache.get(schemaPublicId);
                if (schema == null) {
                    schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    schemaFactory.setResourceResolver(new MyLSResourceResolver());
                    schemaFactory.setErrorHandler(new MyErrorHandler());
                    path = schemaPublicId;
                    if (ParserUtils.schemaResourcePrefix != null) {
                        index = schemaPublicId.lastIndexOf(47);
                        if (index != -1) {
                            path = schemaPublicId.substring(index + 1);
                        }
                        path = ParserUtils.schemaResourcePrefix + path;
                    }
                    input = null;
                    if (ParserUtils.isSchemaResourcePrefixFileUrl) {
                        try {
                            f = new File(new URI(path));
                            if (!f.exists()) ** GOTO lbl27
                            input = new FileInputStream(f);
                        }
                        catch (Exception e) {
                            throw new SAXException(e);
                        }
                    } else {
                        input = ParserUtils.class.getResourceAsStream(path);
                    }
lbl27:
                    // 3 sources

                    if (input == null) {
                        throw new SAXException(Localizer.getMessage("jsp.error.internal.filenotfound", schemaPublicId));
                    }
                    schema = schemaFactory.newSchema(new StreamSource(input));
                    ParserUtils.schemaCache.put(schemaPublicId, schema);
                }
            }
        }
        return schema;
    }

    static {
        isDtdResourcePrefixFileUrl = false;
        isSchemaResourcePrefixFileUrl = false;
        schemaCache = new HashMap();
        CACHED_DTD_PUBLIC_IDS = new String[]{"-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN"};
        DEFAULT_DTD_RESOURCE_PATHS = new String[]{"/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", "/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", "/javax/servlet/resources/web-app_2_2.dtd", "/javax/servlet/resources/web-app_2_3.dtd"};
        CACHED_DTD_RESOURCE_PATHS = DEFAULT_DTD_RESOURCE_PATHS;
        DEFAULT_SCHEMA_RESOURCE_PATHS = new String[]{"/javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", "/javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", "/javax/servlet/resources/web-app_2_4.xsd", "/javax/servlet/resources/web-app_2_5.xsd"};
        CACHED_SCHEMA_RESOURCE_PATHS = DEFAULT_SCHEMA_RESOURCE_PATHS;
    }
}

