/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.SmapGenerator;
import org.apache.jasper.compiler.SmapStratum;

public class SmapUtil {
    private JspCompilationContext ctxt;
    private List<ClassInfo> classInfos;
    public static final String SMAP_ENCODING = "UTF-8";

    SmapUtil(JspCompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public void generateSmap(Node.Nodes pageNodes) throws IOException {
        this.classInfos = new ArrayList<ClassInfo>();
        String className = this.ctxt.getFullClassName();
        SmapStratum s = new SmapStratum("JSP");
        this.classInfos.add(new ClassInfo(className, s));
        this.evaluateNodes(pageNodes, s, this.ctxt.getOptions().getMappedFile());
        String classFileName = this.ctxt.getClassFileName();
        for (ClassInfo entry : this.classInfos) {
            s = entry.getSmapStratum();
            s.optimizeLineSection();
            SmapGenerator g = new SmapGenerator();
            g.setOutputFileName(SmapUtil.unqualify(this.ctxt.getServletJavaFileName()));
            g.addStratum(s, true);
            String name = entry.getClassName();
            if (!className.equals(name)) {
                classFileName = this.ctxt.getOutputDir() + name.substring(name.lastIndexOf(46) + 1) + ".class";
            }
            entry.setClassFileName(classFileName);
            entry.setSmap(g.getString());
            if (!this.ctxt.getOptions().isSmapDumped()) continue;
            File outSmap = new File(classFileName + ".smap");
            PrintWriter so = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outSmap), SMAP_ENCODING));
            so.print(g.getString());
            so.close();
        }
    }

    public void installSmap() throws IOException {
        for (ClassInfo ci : this.classInfos) {
            String className = ci.getClassName();
            byte[] classfile = this.ctxt.getRuntimeContext().getBytecode(className);
            if (classfile == null) {
                SDEInstaller.install(new File(ci.getClassFileName()), ci.getSmap().getBytes());
                continue;
            }
            classfile = SDEInstaller.install(classfile, ci.getSmap().getBytes());
            this.ctxt.getRuntimeContext().setBytecode(className, classfile);
        }
    }

    private static String unqualify(String path) {
        path = path.replace('\\', '/');
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private void evaluateNodes(Node.Nodes nodes, SmapStratum s, boolean breakAtLF) {
        try {
            nodes.visit(new SmapGenVisitor(s, breakAtLF, this.classInfos));
        }
        catch (JasperException jasperException) {
            // empty catch block
        }
    }

    public static class ClassInfo {
        private String className;
        private String classFileName;
        private String smap;
        private SmapStratum smapStratum;

        public ClassInfo(String className, SmapStratum smapStratum) {
            this.className = className;
            this.smapStratum = smapStratum;
        }

        public String getClassName() {
            return this.className;
        }

        public SmapStratum getSmapStratum() {
            return this.smapStratum;
        }

        public String getClassFileName() {
            return this.classFileName;
        }

        public void setClassFileName(String classFileName) {
            this.classFileName = classFileName;
        }

        public String getSmap() {
            return this.smap;
        }

        public void setSmap(String smap) {
            this.smap = smap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SmapGenVisitor
    extends Node.Visitor {
        private SmapStratum smapStratum;
        private boolean breakAtLF;
        private List<ClassInfo> classInfos;

        SmapGenVisitor(SmapStratum s, boolean breakAtLF, List<ClassInfo> classInfos) {
            this.smapStratum = s;
            this.breakAtLF = breakAtLF;
            this.classInfos = classInfos;
        }

        @Override
        public void visitBody(Node n) throws JasperException {
            SmapStratum smapStratumSave;
            block2: {
                smapStratumSave = this.smapStratum;
                String innerClass = n.getInnerClassName();
                if (innerClass != null) {
                    for (ClassInfo ci : this.classInfos) {
                        if (!innerClass.equals(ci.getClassName())) continue;
                        this.smapStratum = ci.getSmapStratum();
                        break block2;
                    }
                    this.smapStratum = new SmapStratum("JSP");
                    this.classInfos.add(new ClassInfo(innerClass, this.smapStratum));
                }
            }
            super.visitBody(n);
            this.smapStratum = smapStratumSave;
        }

        @Override
        public void visit(Node.Declaration n) throws JasperException {
            this.doSmapText(n);
        }

        @Override
        public void visit(Node.Expression n) throws JasperException {
            this.doSmapText(n);
        }

        @Override
        public void visit(Node.Scriptlet n) throws JasperException {
            this.doSmapText(n);
        }

        @Override
        public void visit(Node.IncludeAction n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.ForwardAction n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.GetProperty n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.SetProperty n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.UseBean n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.PlugIn n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.CustomTag n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.UninterpretedTag n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.JspElement n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.JspText n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.NamedAttribute n) throws JasperException {
            this.visitBody(n);
        }

        @Override
        public void visit(Node.JspBody n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.InvokeAction n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.DoBodyAction n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.ELExpression n) throws JasperException {
            this.doSmap(n);
        }

        @Override
        public void visit(Node.TemplateText n) throws JasperException {
            Mark mark = n.getStart();
            if (mark == null) {
                return;
            }
            String fileName = mark.getFile();
            this.smapStratum.addFile(SmapUtil.unqualify(fileName), fileName);
            int iInputStartLine = mark.getLineNumber();
            int iOutputStartLine = n.getBeginJavaLine();
            int iOutputLineIncrement = this.breakAtLF ? 1 : 0;
            this.smapStratum.addLineData(iInputStartLine, fileName, 1, iOutputStartLine, iOutputLineIncrement);
            ArrayList extraSmap = n.getExtraSmap();
            if (extraSmap != null) {
                for (int i = 0; i < extraSmap.size(); ++i) {
                    this.smapStratum.addLineData(iInputStartLine + (Integer)extraSmap.get(i), fileName, 1, iOutputStartLine += iOutputLineIncrement, iOutputLineIncrement);
                }
            }
        }

        private void doSmap(Node n, int inLineCount, int outIncrement, int skippedLines) {
            Mark mark = n.getStart();
            if (mark == null) {
                return;
            }
            String unqualifiedName = SmapUtil.unqualify(mark.getFile());
            this.smapStratum.addFile(unqualifiedName, mark.getFile());
            this.smapStratum.addLineData(mark.getLineNumber() + skippedLines, mark.getFile(), inLineCount - skippedLines, n.getBeginJavaLine() + skippedLines, outIncrement);
        }

        private void doSmap(Node n) {
            this.doSmap(n, 1, n.getEndJavaLine() - n.getBeginJavaLine(), 0);
        }

        private void doSmapText(Node n) {
            String text = n.getText();
            int index = 0;
            int next = 0;
            int lineCount = 1;
            int skippedLines = 0;
            boolean slashStarSeen = false;
            boolean beginning = true;
            while ((next = text.indexOf(10, index)) > -1) {
                if (beginning) {
                    String line = text.substring(index, next).trim();
                    if (!slashStarSeen && line.startsWith("/*")) {
                        slashStarSeen = true;
                    }
                    if (slashStarSeen) {
                        ++skippedLines;
                        int endIndex = line.indexOf("*/");
                        if (endIndex >= 0) {
                            slashStarSeen = false;
                            if (endIndex < line.length() - 2) {
                                --skippedLines;
                                beginning = false;
                            }
                        }
                    } else if (line.length() == 0 || line.startsWith("//")) {
                        ++skippedLines;
                    } else {
                        beginning = false;
                    }
                }
                ++lineCount;
                index = next + 1;
            }
            this.doSmap(n, lineCount, 1, skippedLines);
        }
    }

    private static class SDEInstaller {
        static final String nameSDE = "SourceDebugExtension";
        byte[] orig;
        byte[] sdeAttr;
        byte[] gen;
        int origPos = 0;
        int genPos = 0;
        int sdeIndex;

        public static void main(String[] args) throws IOException {
            if (args.length == 2) {
                SDEInstaller.install(new File(args[0]), new File(args[1]));
            } else if (args.length == 3) {
                SDEInstaller.install(new File(args[0]), new File(args[1]), new File(args[2]));
            } else {
                System.err.println("Usage: <command> <input class file> <attribute file> <output class file name>\n<command> <input/output class file> <attribute file>");
            }
        }

        static void install(File inClassFile, File attrFile, File outClassFile) throws IOException {
            new SDEInstaller(inClassFile, attrFile, outClassFile);
        }

        static void install(File inOutClassFile, File attrFile) throws IOException {
            File tmpFile = new File(inOutClassFile.getPath() + "tmp");
            new SDEInstaller(inOutClassFile, attrFile, tmpFile);
            if (!inOutClassFile.delete()) {
                throw new IOException("inOutClassFile.delete() failed");
            }
            if (!tmpFile.renameTo(inOutClassFile)) {
                throw new IOException("tmpFile.renameTo(inOutClassFile) failed");
            }
        }

        static void install(File classFile, byte[] smap) throws IOException {
            File tmpFile = new File(classFile.getPath() + "tmp");
            new SDEInstaller(classFile, smap, tmpFile);
            if (!classFile.delete()) {
                throw new IOException("classFile.delete() failed");
            }
            if (!tmpFile.renameTo(classFile)) {
                throw new IOException("tmpFile.renameTo(classFile) failed");
            }
        }

        static byte[] install(byte[] classfile, byte[] smap) throws IOException {
            SDEInstaller installer = new SDEInstaller(classfile, smap);
            byte[] tmp = new byte[installer.genPos];
            System.arraycopy(installer.gen, 0, tmp, 0, installer.genPos);
            return tmp;
        }

        SDEInstaller(byte[] classfile, byte[] sdeAttr) throws IOException {
            this.orig = classfile;
            this.sdeAttr = sdeAttr;
            this.gen = new byte[this.orig.length + sdeAttr.length + 100];
            this.addSDE();
        }

        SDEInstaller(File inClassFile, byte[] sdeAttr, File outClassFile) throws IOException {
            if (!inClassFile.exists()) {
                throw new FileNotFoundException("no such file: " + inClassFile);
            }
            this.sdeAttr = sdeAttr;
            this.orig = SDEInstaller.readWhole(inClassFile);
            this.gen = new byte[this.orig.length + sdeAttr.length + 100];
            this.addSDE();
            FileOutputStream outStream = new FileOutputStream(outClassFile);
            outStream.write(this.gen, 0, this.genPos);
            outStream.close();
        }

        SDEInstaller(File inClassFile, File attrFile, File outClassFile) throws IOException {
            this(inClassFile, SDEInstaller.readWhole(attrFile), outClassFile);
        }

        static byte[] readWhole(File input) throws IOException {
            FileInputStream inStream = new FileInputStream(input);
            int len = (int)input.length();
            byte[] bytes = new byte[len];
            if (inStream.read(bytes, 0, len) != len) {
                throw new IOException("expected size: " + len);
            }
            inStream.close();
            return bytes;
        }

        void addSDE() throws UnsupportedEncodingException, IOException {
            this.copy(8);
            int constantPoolCountPos = this.genPos;
            int constantPoolCount = this.readU2();
            this.writeU2(constantPoolCount);
            this.sdeIndex = this.copyConstantPool(constantPoolCount);
            if (this.sdeIndex < 0) {
                this.writeUtf8ForSDE();
                this.sdeIndex = constantPoolCount++;
                this.randomAccessWriteU2(constantPoolCountPos, constantPoolCount);
            }
            this.copy(6);
            int interfaceCount = this.readU2();
            this.writeU2(interfaceCount);
            this.copy(interfaceCount * 2);
            this.copyMembers();
            this.copyMembers();
            int attrCountPos = this.genPos;
            int attrCount = this.readU2();
            this.writeU2(attrCount);
            if (!this.copyAttrs(attrCount)) {
                this.randomAccessWriteU2(attrCountPos, ++attrCount);
            }
            this.writeAttrForSDE(this.sdeIndex);
        }

        void copyMembers() {
            int count = this.readU2();
            this.writeU2(count);
            for (int i = 0; i < count; ++i) {
                this.copy(6);
                int attrCount = this.readU2();
                this.writeU2(attrCount);
                this.copyAttrs(attrCount);
            }
        }

        boolean copyAttrs(int attrCount) {
            boolean sdeFound = false;
            for (int i = 0; i < attrCount; ++i) {
                int nameIndex = this.readU2();
                if (nameIndex == this.sdeIndex) {
                    sdeFound = true;
                    continue;
                }
                this.writeU2(nameIndex);
                int len = this.readU4();
                this.writeU4(len);
                this.copy(len);
            }
            return sdeFound;
        }

        void writeAttrForSDE(int index) {
            this.writeU2(index);
            this.writeU4(this.sdeAttr.length);
            for (int i = 0; i < this.sdeAttr.length; ++i) {
                this.writeU1(this.sdeAttr[i]);
            }
        }

        void randomAccessWriteU2(int pos, int val) {
            int savePos = this.genPos;
            this.genPos = pos;
            this.writeU2(val);
            this.genPos = savePos;
        }

        int readU1() {
            return this.orig[this.origPos++] & 0xFF;
        }

        int readU2() {
            int res = this.readU1();
            return (res << 8) + this.readU1();
        }

        int readU4() {
            int res = this.readU2();
            return (res << 16) + this.readU2();
        }

        void writeU1(int val) {
            this.gen[this.genPos++] = (byte)val;
        }

        void writeU2(int val) {
            this.writeU1(val >> 8);
            this.writeU1(val & 0xFF);
        }

        void writeU4(int val) {
            this.writeU2(val >> 16);
            this.writeU2(val & 0xFFFF);
        }

        void copy(int count) {
            for (int i = 0; i < count; ++i) {
                this.gen[this.genPos++] = this.orig[this.origPos++];
            }
        }

        byte[] readBytes(int count) {
            byte[] bytes = new byte[count];
            for (int i = 0; i < count; ++i) {
                bytes[i] = this.orig[this.origPos++];
            }
            return bytes;
        }

        void writeBytes(byte[] bytes) {
            for (int i = 0; i < bytes.length; ++i) {
                this.gen[this.genPos++] = bytes[i];
            }
        }

        int copyConstantPool(int constantPoolCount) throws UnsupportedEncodingException, IOException {
            int sdeIndex = -1;
            block6: for (int i = 1; i < constantPoolCount; ++i) {
                int tag = this.readU1();
                this.writeU1(tag);
                switch (tag) {
                    case 7: 
                    case 8: {
                        this.copy(2);
                        continue block6;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        this.copy(4);
                        continue block6;
                    }
                    case 5: 
                    case 6: {
                        this.copy(8);
                        ++i;
                        continue block6;
                    }
                    case 1: {
                        int len = this.readU2();
                        this.writeU2(len);
                        byte[] utf8 = this.readBytes(len);
                        String str = new String(utf8, SmapUtil.SMAP_ENCODING);
                        if (str.equals(nameSDE)) {
                            sdeIndex = i;
                        }
                        this.writeBytes(utf8);
                        continue block6;
                    }
                    default: {
                        throw new IOException("unexpected tag: " + tag);
                    }
                }
            }
            return sdeIndex;
        }

        void writeUtf8ForSDE() {
            int len = nameSDE.length();
            this.writeU1(1);
            this.writeU2(len);
            for (int i = 0; i < len; ++i) {
                this.writeU1(nameSDE.charAt(i));
            }
        }
    }
}

