/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.Writer;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.io.TemporaryHeapBuffer;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HeaderValue;
import org.glassfish.grizzly.http.util.MimeType;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.threadpool.Threads;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.utils.Exceptions;
import org.glassfish.grizzly.utils.Futures;

public class OutputBuffer {
    protected static final Logger LOGGER = Grizzly.logger(OutputBuffer.class);
    private static final int DEFAULT_BUFFER_SIZE = Integer.getInteger(OutputBuffer.class.getName() + ".default-buffer-size", 8192);
    private static final int MAX_CHAR_BUFFER_SIZE = Integer.getInteger(OutputBuffer.class.getName() + ".max-char-buffer-size", 65537);
    private static final boolean IS_BLOCKING = Boolean.getBoolean(OutputBuffer.class.getName() + ".isBlocking");
    private FilterChainContext ctx;
    private CompositeBuffer compositeBuffer;
    private Buffer currentBuffer;
    private final TemporaryHeapBuffer temporaryWriteBuffer = new TemporaryHeapBuffer();
    private final ByteArrayCloner cloner = new ByteArrayCloner(this.temporaryWriteBuffer);
    private final List<LifeCycleListener> lifeCycleListeners = new ArrayList<LifeCycleListener>(2);
    private boolean committed;
    private boolean finished;
    private boolean closed;
    private CharsetEncoder encoder;
    private final Map<String, CharsetEncoder> encoders = new HashMap<String, CharsetEncoder>();
    private char[] charsArray;
    private int charsArrayLength;
    private CharBuffer charsBuffer;
    private MemoryManager memoryManager;
    private Connection connection;
    private WriteHandler handler;
    private InternalWriteHandler asyncWriteHandler;
    private boolean fileTransferRequested;
    private int bufferSize = DEFAULT_BUFFER_SIZE;
    protected boolean sendfileEnabled;
    private HttpHeader outputHeader;
    private Runnable writePossibleRunnable;
    private HttpContent.Builder builder;
    private boolean isNonBlockingWriteGuaranteed;
    private boolean isLastWriteNonBlocking;
    private HttpContext httpContext;

    public void initialize(HttpHeader outputHeader, boolean sendfileEnabled, FilterChainContext ctx) {
        this.outputHeader = outputHeader;
        if (this.builder == null) {
            this.builder = outputHeader.httpContentBuilder();
        } else {
            this.builder.httpHeader(outputHeader);
        }
        this.sendfileEnabled = sendfileEnabled;
        this.ctx = ctx;
        this.httpContext = HttpContext.get(ctx);
        this.connection = ctx.getConnection();
        this.memoryManager = ctx.getMemoryManager();
    }

    public boolean isAsyncEnabled() {
        return true;
    }

    public void setAsyncEnabled(boolean asyncEnabled) {
    }

    public void prepareCharacterEncoder() {
        this.getEncoder();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void registerLifeCycleListener(LifeCycleListener listener) {
        this.lifeCycleListeners.add(listener);
    }

    public boolean removeLifeCycleListener(LifeCycleListener listener) {
        return this.lifeCycleListeners.remove(listener);
    }

    public void setBufferSize(int bufferSize) {
        if (!this.committed && this.currentBuffer == null) {
            this.bufferSize = bufferSize;
        }
        if (this.charsArray != null && this.charsArray.length < bufferSize) {
            char[] newCharsArray = new char[bufferSize];
            System.arraycopy(this.charsArray, 0, newCharsArray, 0, this.charsArrayLength);
            this.charsBuffer = CharBuffer.wrap(newCharsArray);
            this.charsArray = newCharsArray;
        }
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException();
        }
        this.compositeBuffer = null;
        if (this.currentBuffer != null) {
            this.currentBuffer.clear();
        }
        this.charsArrayLength = 0;
        this.encoder = null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getBufferedDataSize() {
        int size = 0;
        if (this.compositeBuffer != null) {
            size += this.compositeBuffer.remaining();
        }
        if (this.currentBuffer != null) {
            size += this.currentBuffer.position();
        }
        return size += this.charsArrayLength << 1;
    }

    public void recycle() {
        this.outputHeader = null;
        this.builder.reset();
        if (this.compositeBuffer != null) {
            this.compositeBuffer.dispose();
            this.compositeBuffer = null;
        }
        if (this.currentBuffer != null) {
            this.currentBuffer.dispose();
            this.currentBuffer = null;
        }
        this.temporaryWriteBuffer.recycle();
        if (this.charsArray != null) {
            this.charsArrayLength = 0;
            if (this.charsArray.length < MAX_CHAR_BUFFER_SIZE) {
                this.charsBuffer.clear();
            } else {
                this.charsBuffer = null;
                this.charsArray = null;
            }
        }
        this.bufferSize = DEFAULT_BUFFER_SIZE;
        this.fileTransferRequested = false;
        this.encoder = null;
        this.ctx = null;
        this.httpContext = null;
        this.connection = null;
        this.memoryManager = null;
        this.handler = null;
        this.isNonBlockingWriteGuaranteed = false;
        this.isLastWriteNonBlocking = false;
        this.asyncWriteHandler = null;
        this.committed = false;
        this.finished = false;
        this.closed = false;
        this.lifeCycleListeners.clear();
    }

    public void endRequest() throws IOException {
        if (this.finished) {
            return;
        }
        InternalWriteHandler asyncWriteQueueHandlerLocal = this.asyncWriteHandler;
        if (asyncWriteQueueHandlerLocal != null) {
            this.asyncWriteHandler = null;
            asyncWriteQueueHandlerLocal.detach();
        }
        if (!this.closed) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.ctx != null) {
            this.ctx.notifyDownstream(HttpServerFilter.RESPONSE_COMPLETE_EVENT);
        }
        this.finished = true;
    }

    public void acknowledge() throws IOException {
        this.ctx.write((Object)this.outputHeader, IS_BLOCKING);
    }

    public void writeChar(int c) throws IOException {
        this.connection.assertOpen();
        if (this.closed) {
            return;
        }
        this.updateNonBlockingStatus();
        this.checkCharBuffer();
        if (this.charsArrayLength == this.charsArray.length) {
            this.flushCharsToBuf(true);
        }
        this.charsArray[this.charsArrayLength++] = (char)c;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.connection.assertOpen();
        if (this.closed || len == 0) {
            return;
        }
        this.updateNonBlockingStatus();
        this.checkCharBuffer();
        int remaining = this.charsArray.length - this.charsArrayLength;
        if (len <= remaining) {
            System.arraycopy(cbuf, off, this.charsArray, this.charsArrayLength, len);
            this.charsArrayLength += len;
        } else if (len - remaining < remaining) {
            System.arraycopy(cbuf, off, this.charsArray, this.charsArrayLength, remaining);
            this.charsArrayLength += remaining;
            this.flushCharsToBuf(true);
            System.arraycopy(cbuf, off + remaining, this.charsArray, 0, len - remaining);
            this.charsArrayLength = len - remaining;
        } else {
            this.flushCharsToBuf(false);
            this.flushCharsToBuf(CharBuffer.wrap(cbuf, off, len), true);
        }
    }

    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    public void write(String str, int off, int len) throws IOException {
        this.connection.assertOpen();
        if (this.closed || len == 0) {
            return;
        }
        this.updateNonBlockingStatus();
        this.checkCharBuffer();
        if (this.charsArray.length - this.charsArrayLength >= len) {
            str.getChars(off, off + len, this.charsArray, this.charsArrayLength);
            this.charsArrayLength += len;
            return;
        }
        int offLocal = off;
        int lenLocal = len;
        do {
            int remaining = this.charsArray.length - this.charsArrayLength;
            int workingLen = Math.min(lenLocal, remaining);
            str.getChars(offLocal, offLocal + workingLen, this.charsArray, this.charsArrayLength);
            this.charsArrayLength += workingLen;
            offLocal += workingLen;
            if ((lenLocal -= workingLen) <= 0) continue;
            this.flushCharsToBuf(false);
        } while (lenLocal > 0);
        this.flushBinaryBuffersIfNeeded();
    }

    public void writeByte(int b) throws IOException {
        this.connection.assertOpen();
        if (this.closed) {
            return;
        }
        this.updateNonBlockingStatus();
        this.checkCurrentBuffer();
        if (!this.currentBuffer.hasRemaining()) {
            if (this.canWritePayloadChunk()) {
                this.doCommit();
                this.flushBinaryBuffers(false);
                this.checkCurrentBuffer();
                this.blockAfterWriteIfNeeded();
            } else {
                this.finishCurrentBuffer();
                this.checkCurrentBuffer();
            }
        }
        this.currentBuffer.put((byte)b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void sendfile(File file, CompletionHandler<WriteResult> handler) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 'file' cannot be null");
        }
        this.sendfile(file, 0L, file.length(), handler);
    }

    public void sendfile(File file, long offset, long length, CompletionHandler<WriteResult> handler) {
        if (!this.sendfileEnabled) {
            throw new IllegalStateException("sendfile support isn't available.");
        }
        if (this.fileTransferRequested) {
            throw new IllegalStateException("Only one file transfer allowed per request");
        }
        this.reset();
        FileTransfer f = new FileTransfer(file, offset, length);
        this.fileTransferRequested = true;
        this.outputHeader.setContentLengthLong(f.remaining());
        if (this.outputHeader.getContentType() == null) {
            this.outputHeader.setContentType(MimeType.getByFilename(file.getName()));
        }
        this.outputHeader.setHeader(Header.ContentEncoding, HeaderValue.IDENTITY);
        try {
            this.flush();
        }
        catch (IOException e) {
            if (handler != null) {
                handler.failed(e);
            } else if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, String.format("Failed to transfer file %s.  Cause: %s.", file.getAbsolutePath(), e.getMessage()), e);
            }
            return;
        }
        this.ctx.write((Object)f, handler);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.connection.assertOpen();
        if (this.closed || len == 0) {
            return;
        }
        this.updateNonBlockingStatus();
        if (this.bufferSize >= len && (this.currentBuffer == null || this.currentBuffer.remaining() >= len)) {
            this.checkCurrentBuffer();
            assert (this.currentBuffer != null);
            this.currentBuffer.put(b, off, len);
        } else if (this.canWritePayloadChunk()) {
            this.temporaryWriteBuffer.reset(b, off, len);
            this.finishCurrentBuffer();
            this.doCommit();
            if (this.compositeBuffer != null) {
                this.compositeBuffer.append(this.temporaryWriteBuffer);
                this.flushBuffer(this.compositeBuffer, false, this.cloner);
                this.compositeBuffer = null;
            } else {
                this.flushBuffer(this.temporaryWriteBuffer, false, this.cloner);
            }
            this.blockAfterWriteIfNeeded();
        } else {
            this.finishCurrentBuffer();
            Object cloneBuffer = this.memoryManager.allocate(len);
            cloneBuffer.put(b, off, len);
            cloneBuffer.flip();
            this.checkCompositeBuffer();
            this.compositeBuffer.append((Buffer)cloneBuffer);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.connection.assertOpen();
        boolean isJustCommitted = this.doCommit();
        if (!this.flushAllBuffers(true) && (isJustCommitted || this.outputHeader.isChunked())) {
            this.forceCommitHeaders(true);
        }
        this.blockAfterWriteIfNeeded();
    }

    public void flush() throws IOException {
        this.connection.assertOpen();
        boolean isJustCommitted = this.doCommit();
        if (!this.flushAllBuffers(false) && isJustCommitted) {
            this.forceCommitHeaders(false);
        }
        this.blockAfterWriteIfNeeded();
    }

    public void writeByteBuffer(ByteBuffer byteBuffer) throws IOException {
        Buffer w = Buffers.wrap(this.memoryManager, byteBuffer);
        w.allowBufferDispose(false);
        this.writeBuffer(w);
    }

    public void writeBuffer(Buffer buffer) throws IOException {
        this.connection.assertOpen();
        this.updateNonBlockingStatus();
        this.finishCurrentBuffer();
        this.checkCompositeBuffer();
        this.compositeBuffer.append(buffer);
        if (this.canWritePayloadChunk() && this.compositeBuffer.remaining() > this.bufferSize) {
            this.flush();
        }
    }

    @Deprecated
    public boolean canWriteChar(int length) {
        return this.canWrite();
    }

    public boolean canWrite(int length) {
        return this.canWrite();
    }

    public boolean canWrite() {
        if (IS_BLOCKING || this.isNonBlockingWriteGuaranteed) {
            return true;
        }
        if (this.httpContext.getOutputSink().canWrite()) {
            this.isNonBlockingWriteGuaranteed = true;
            return true;
        }
        return false;
    }

    public void notifyCanWrite(WriteHandler handler, int length) {
        this.notifyCanWrite(handler);
    }

    public void notifyCanWrite(WriteHandler handler) {
        if (this.handler != null) {
            throw new IllegalStateException("Illegal attempt to set a new handler before the existing handler has been notified.");
        }
        if (!this.connection.isOpen()) {
            handler.onError(this.connection.getCloseReason().getCause());
            return;
        }
        this.handler = handler;
        if (this.isNonBlockingWriteGuaranteed || this.canWrite()) {
            Writer.Reentrant reentrant = Writer.Reentrant.getWriteReentrant();
            if (!reentrant.isMaxReentrantsReached()) {
                this.notifyWritePossible();
            } else {
                this.notifyWritePossibleAsync();
            }
            return;
        }
        assert (!IS_BLOCKING);
        if (this.asyncWriteHandler == null) {
            this.asyncWriteHandler = new InternalWriteHandler(this);
        }
        try {
            this.httpContext.getOutputSink().notifyCanWrite(this.asyncWriteHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Executor getThreadPool() {
        if (!Threads.isService()) {
            return null;
        }
        ExecutorService es = this.connection.getTransport().getWorkerThreadPool();
        return es != null && !es.isShutdown() ? es : null;
    }

    private void notifyWritePossibleAsync() {
        if (this.writePossibleRunnable == null) {
            this.writePossibleRunnable = new Runnable(){

                @Override
                public void run() {
                    OutputBuffer.this.notifyWritePossible();
                }
            };
        }
        this.connection.executeInEventThread(IOEvent.WRITE, this.writePossibleRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWritePossible() {
        WriteHandler localHandler = this.handler;
        if (localHandler != null) {
            Writer.Reentrant reentrant = Writer.Reentrant.getWriteReentrant();
            try {
                this.handler = null;
                reentrant.inc();
                this.isNonBlockingWriteGuaranteed = true;
                localHandler.onWritePossible();
            }
            catch (Throwable t) {
                localHandler.onError(t);
            }
            finally {
                reentrant.dec();
            }
        }
    }

    private boolean canWritePayloadChunk() {
        return this.outputHeader.isChunkingAllowed() || this.outputHeader.getContentLength() != -1L;
    }

    private void blockAfterWriteIfNeeded() throws IOException {
        if (IS_BLOCKING || this.isNonBlockingWriteGuaranteed || this.isLastWriteNonBlocking) {
            return;
        }
        if (this.httpContext.getOutputSink().canWrite()) {
            return;
        }
        final FutureImpl future = Futures.createSafeFuture();
        this.httpContext.getOutputSink().notifyCanWrite(new WriteHandler(){

            @Override
            public void onWritePossible() throws Exception {
                future.result(Boolean.TRUE);
            }

            @Override
            public void onError(Throwable t) {
                future.failure(Exceptions.makeIOException(t));
            }
        });
        try {
            long writeTimeout = this.connection.getWriteTimeout(TimeUnit.MILLISECONDS);
            if (writeTimeout >= 0L) {
                future.get(writeTimeout, TimeUnit.MILLISECONDS);
            } else {
                future.get();
            }
        }
        catch (ExecutionException e) {
            this.httpContext.close();
            throw new IOException(e.getCause());
        }
        catch (Exception e) {
            this.httpContext.close();
            throw new IOException(e);
        }
    }

    private boolean flushAllBuffers(boolean isLast) throws IOException {
        if (this.charsArrayLength > 0) {
            this.flushCharsToBuf(false);
        }
        return this.flushBinaryBuffers(isLast);
    }

    private boolean flushBinaryBuffers(boolean isLast) throws IOException {
        Buffer bufferToFlush;
        boolean isFlushComposite;
        if (!this.outputHeader.isChunkingAllowed() && this.outputHeader.getContentLength() == -1L) {
            if (!isLast) {
                return false;
            }
            this.outputHeader.setContentLength(this.getBufferedDataSize());
        }
        boolean bl = isFlushComposite = this.compositeBuffer != null && this.compositeBuffer.hasRemaining();
        if (isFlushComposite) {
            this.finishCurrentBuffer();
            bufferToFlush = this.compositeBuffer;
            this.compositeBuffer = null;
        } else if (this.currentBuffer != null && this.currentBuffer.position() > 0) {
            this.currentBuffer.trim();
            bufferToFlush = this.currentBuffer;
            this.currentBuffer = null;
        } else {
            bufferToFlush = null;
        }
        if (bufferToFlush != null) {
            this.flushBuffer(bufferToFlush, isLast, null);
            return true;
        }
        return false;
    }

    private void flushBuffer(Buffer bufferToFlush, boolean isLast, MessageCloner<Buffer> messageCloner) throws IOException {
        ((HttpContent.Builder)this.builder.content(bufferToFlush)).last(isLast);
        this.ctx.write(null, (Object)this.builder.build(), null, messageCloner, IS_BLOCKING);
    }

    private void checkCharBuffer() {
        if (this.charsArray == null) {
            this.charsArray = new char[this.bufferSize];
            this.charsBuffer = CharBuffer.wrap(this.charsArray);
        }
    }

    private void checkCurrentBuffer() {
        if (this.currentBuffer == null) {
            this.currentBuffer = this.memoryManager.allocate(this.bufferSize);
            this.currentBuffer.allowBufferDispose(true);
        }
    }

    private void finishCurrentBuffer() {
        if (this.currentBuffer != null && this.currentBuffer.position() > 0) {
            this.currentBuffer.trim();
            this.checkCompositeBuffer();
            this.compositeBuffer.append(this.currentBuffer);
            this.currentBuffer = null;
        }
    }

    private CharsetEncoder getEncoder() {
        if (this.encoder == null) {
            String encoding = this.outputHeader.getCharacterEncoding();
            if (encoding == null) {
                encoding = "ISO-8859-1";
            }
            this.encoder = this.encoders.get(encoding);
            if (this.encoder == null) {
                Charset cs = Charsets.lookupCharset(encoding);
                this.encoder = cs.newEncoder();
                this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
                this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.encoders.put(encoding, this.encoder);
            } else {
                this.encoder.reset();
            }
        }
        return this.encoder;
    }

    private boolean doCommit() throws IOException {
        if (!this.committed) {
            this.notifyCommit();
            this.committed = true;
            return true;
        }
        return false;
    }

    private void forceCommitHeaders(boolean isLast) throws IOException {
        if (isLast) {
            if (this.outputHeader != null) {
                ((HttpContent.Builder)this.builder.last(true)).content(null);
                this.ctx.write((Object)this.builder.build(), IS_BLOCKING);
            }
        } else {
            this.ctx.write((Object)this.outputHeader, IS_BLOCKING);
        }
    }

    private void checkCompositeBuffer() {
        if (this.compositeBuffer == null) {
            CompositeBuffer buffer = CompositeBuffer.newBuffer(this.memoryManager);
            buffer.allowBufferDispose(true);
            buffer.allowInternalBuffersDispose(true);
            this.compositeBuffer = buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushCharsToBuf(boolean canFlushToNet) throws IOException {
        this.charsBuffer.limit(this.charsArrayLength);
        try {
            this.flushCharsToBuf(this.charsBuffer, canFlushToNet);
        }
        finally {
            this.charsArrayLength = 0;
            this.charsBuffer.clear();
        }
    }

    private void flushCharsToBuf(CharBuffer charBuf, boolean canFlushToNet) throws IOException {
        if (!charBuf.hasRemaining()) {
            return;
        }
        CharsetEncoder enc = this.getEncoder();
        this.checkCurrentBuffer();
        if (!this.currentBuffer.hasRemaining()) {
            this.finishCurrentBuffer();
            this.checkCurrentBuffer();
        }
        ByteBuffer currentByteBuffer = this.currentBuffer.toByteBuffer();
        int bufferPos = this.currentBuffer.position();
        int byteBufferPos = currentByteBuffer.position();
        CoderResult res = enc.encode(charBuf, currentByteBuffer, true);
        this.currentBuffer.position(bufferPos + (currentByteBuffer.position() - byteBufferPos));
        while (res == CoderResult.OVERFLOW) {
            this.checkCurrentBuffer();
            currentByteBuffer = this.currentBuffer.toByteBuffer();
            bufferPos = this.currentBuffer.position();
            byteBufferPos = currentByteBuffer.position();
            res = enc.encode(charBuf, currentByteBuffer, true);
            this.currentBuffer.position(bufferPos + (currentByteBuffer.position() - byteBufferPos));
            if (res != CoderResult.OVERFLOW) continue;
            this.finishCurrentBuffer();
        }
        if (res != CoderResult.UNDERFLOW) {
            throw new IOException("Encoding error");
        }
        if (canFlushToNet) {
            this.flushBinaryBuffersIfNeeded();
        }
    }

    private void flushBinaryBuffersIfNeeded() throws IOException {
        if (this.compositeBuffer != null) {
            this.doCommit();
            this.flushBinaryBuffers(false);
            this.blockAfterWriteIfNeeded();
        }
    }

    private void notifyCommit() throws IOException {
        int len = this.lifeCycleListeners.size();
        for (int i = 0; i < len; ++i) {
            this.lifeCycleListeners.get(i).onCommit();
        }
    }

    private void updateNonBlockingStatus() {
        this.isLastWriteNonBlocking = this.isNonBlockingWriteGuaranteed;
        this.isNonBlockingWriteGuaranteed = false;
    }

    private static class InternalWriteHandler
    implements WriteHandler {
        private volatile OutputBuffer outputBuffer;

        public InternalWriteHandler(OutputBuffer outputBuffer) {
            this.outputBuffer = outputBuffer;
        }

        public void detach() {
            this.outputBuffer = null;
        }

        @Override
        public void onWritePossible() throws Exception {
            final OutputBuffer localOB = this.outputBuffer;
            if (localOB != null) {
                Executor executor = localOB.getThreadPool();
                if (executor != null) {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                InternalWriteHandler.onWritePossible0(localOB);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                } else {
                    InternalWriteHandler.onWritePossible0(localOB);
                }
            }
        }

        @Override
        public void onError(final Throwable t) {
            final OutputBuffer localOB = this.outputBuffer;
            if (localOB != null) {
                Executor executor = localOB.getThreadPool();
                if (executor != null) {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            InternalWriteHandler.onError0(localOB, t);
                        }
                    });
                } else {
                    InternalWriteHandler.onError0(localOB, t);
                }
            }
        }

        private static void onWritePossible0(OutputBuffer ob) throws Exception {
            try {
                Writer.Reentrant reentrant = Writer.Reentrant.getWriteReentrant();
                if (!reentrant.isMaxReentrantsReached()) {
                    ob.notifyWritePossible();
                } else {
                    ob.notifyWritePossibleAsync();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static void onError0(OutputBuffer ob, Throwable t) {
            WriteHandler localHandler = ob.handler;
            if (localHandler != null) {
                try {
                    ob.handler = null;
                    localHandler.onError(t);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static interface LifeCycleListener {
        public void onCommit() throws IOException;
    }

    static final class ByteArrayCloner
    implements MessageCloner<Buffer> {
        private final TemporaryHeapBuffer temporaryWriteBuffer;

        public ByteArrayCloner(TemporaryHeapBuffer temporaryWriteBuffer) {
            this.temporaryWriteBuffer = temporaryWriteBuffer;
        }

        @Override
        public Buffer clone(Connection connection, Buffer originalMessage) {
            if (this.temporaryWriteBuffer.isDisposed()) {
                return originalMessage;
            }
            return this.clone0(connection.getTransport().getMemoryManager(), originalMessage);
        }

        Buffer clone0(MemoryManager memoryManager, Buffer originalMessage) {
            if (originalMessage.isComposite()) {
                CompositeBuffer compositeBuffer = (CompositeBuffer)originalMessage;
                compositeBuffer.shrink();
                if (!this.temporaryWriteBuffer.isDisposed()) {
                    if (compositeBuffer.remaining() == this.temporaryWriteBuffer.remaining()) {
                        compositeBuffer.allowInternalBuffersDispose(false);
                        compositeBuffer.tryDispose();
                        return this.temporaryWriteBuffer.cloneContent(memoryManager);
                    }
                    compositeBuffer.replace(this.temporaryWriteBuffer, this.temporaryWriteBuffer.cloneContent(memoryManager));
                }
                return originalMessage;
            }
            return this.temporaryWriteBuffer.cloneContent(memoryManager);
        }
    }
}

