/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core.frame;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.glassfish.tyrus.core.Frame;
import org.glassfish.tyrus.core.StrictUtf8;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utf8DecodingError;
import org.glassfish.tyrus.core.Utf8Utils;
import org.glassfish.tyrus.core.frame.TyrusFrame;

public class TextFrame
extends TyrusFrame {
    private final Charset utf8 = new StrictUtf8();
    private final CharsetDecoder currentDecoder = this.utf8.newDecoder();
    private final String textPayload;
    private final boolean continuation;
    private ByteBuffer remainder;

    public TextFrame(Frame frame, ByteBuffer remainder) {
        super(frame);
        this.textPayload = this.utf8Decode(this.isFin(), this.getPayloadData(), remainder);
        this.continuation = false;
    }

    public TextFrame(Frame frame, ByteBuffer remainder, boolean continuation) {
        super(frame);
        this.textPayload = this.utf8Decode(this.isFin(), this.getPayloadData(), remainder);
        this.continuation = continuation;
    }

    public TextFrame(String message, boolean continuation, boolean fin) {
        super(Frame.builder().payloadData(Utf8Utils.encode(new StrictUtf8(), message)).opcode(continuation ? (byte)0 : 1).fin(fin).build());
        this.continuation = continuation;
        this.textPayload = message;
    }

    public String getTextPayload() {
        return this.textPayload;
    }

    public ByteBuffer getRemainder() {
        return this.remainder;
    }

    @Override
    public void respond(TyrusWebSocket socket) {
        if (this.continuation) {
            socket.onFragment(this.isFin(), this);
        } else if (this.isFin()) {
            socket.onMessage(this);
        } else {
            socket.onFragment(false, this);
        }
    }

    private String utf8Decode(boolean finalFragment, byte[] data, ByteBuffer remainder) {
        CharBuffer cb;
        block7: {
            ByteBuffer b = this.getByteBuffer(data, remainder);
            int n = (int)((float)b.remaining() * this.currentDecoder.averageCharsPerByte());
            cb = CharBuffer.allocate(n);
            while (true) {
                CoderResult result;
                if ((result = this.currentDecoder.decode(b, cb, finalFragment)).isUnderflow()) {
                    if (finalFragment) {
                        this.currentDecoder.flush(cb);
                        if (b.hasRemaining()) {
                            throw new IllegalStateException("Final UTF-8 fragment received, but not all bytes consumed by decode process");
                        }
                        this.currentDecoder.reset();
                    } else if (b.hasRemaining()) {
                        this.remainder = b;
                    }
                    break block7;
                }
                if (result.isOverflow()) {
                    CharBuffer tmp = CharBuffer.allocate(2 * n + 1);
                    cb.flip();
                    tmp.put(cb);
                    cb = tmp;
                    continue;
                }
                if (result.isError() || result.isMalformed()) break;
            }
            throw new Utf8DecodingError("Illegal UTF-8 Sequence");
        }
        cb.flip();
        String res = cb.toString();
        return res;
    }

    private ByteBuffer getByteBuffer(byte[] data, ByteBuffer remainder) {
        if (remainder == null) {
            return ByteBuffer.wrap(data);
        }
        int rem = remainder.remaining();
        byte[] orig = remainder.array();
        byte[] b = new byte[rem + data.length];
        System.arraycopy(orig, orig.length - rem, b, 0, rem);
        System.arraycopy(data, 0, b, rem, data.length);
        return ByteBuffer.wrap(b);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(", textPayload='").append(this.textPayload).append('\'');
        return sb.toString();
    }
}

