/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.DataFrame;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.FramingException;
import org.glassfish.tyrus.core.Handshake;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.TyrusEndpoint;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.Version;
import org.glassfish.tyrus.core.WebSocket;
import org.glassfish.tyrus.core.WebSocketApplication;
import org.glassfish.tyrus.core.uri.Match;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

public class TyrusWebSocketEngine
implements WebSocketEngine {
    public static final String INCOMING_BUFFER_SIZE = "org.glassfish.tyrus.incomingBufferSize";
    public static final int RESPONSE_CODE_VALUE = 101;
    public static final Version DEFAULT_VERSION = Version.DRAFT17;
    public static final int MASK_SIZE = 4;
    private static final int BUFFER_STEP_SIZE = 256;
    private static final Logger LOGGER = Logger.getLogger("websocket");
    private final Set<WebSocketApplication> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ComponentProviderService componentProviderService = ComponentProviderService.create();
    private final WebSocketContainer webSocketContainer;
    private int incomingBufferSize = 0x40000B;
    private static final WebSocketEngine.UpgradeInfo NOT_APPLICABLE_UPGRADE_INFO = new NoConnectionUpgradeInfo(WebSocketEngine.UpgradeStatus.NOT_APPLICABLE);
    private static final WebSocketEngine.UpgradeInfo HANDSHAKE_FAILED_UPGRADE_INFO = new NoConnectionUpgradeInfo(WebSocketEngine.UpgradeStatus.HANDSHAKE_FAILED);

    public TyrusWebSocketEngine(WebSocketContainer webSocketContainer) {
        this.webSocketContainer = webSocketContainer;
    }

    public TyrusWebSocketEngine(WebSocketContainer webSocketContainer, Integer incomingBufferSize) {
        if (incomingBufferSize != null) {
            this.incomingBufferSize = incomingBufferSize;
        }
        this.webSocketContainer = webSocketContainer;
    }

    public static byte[] toArray(long length) {
        long value = length;
        byte[] b = new byte[8];
        for (int i = 7; i >= 0 && value > 0L; value >>= 8, --i) {
            b[i] = (byte)(value & 0xFFL);
        }
        return b;
    }

    public static long toLong(byte[] bytes, int start, int end) {
        long value = 0L;
        for (int i = start; i < end; ++i) {
            value <<= 8;
            value ^= (long)bytes[i] & 0xFFL;
        }
        return value;
    }

    public static List<String> toString(byte[] bytes) {
        return TyrusWebSocketEngine.toString(bytes, 0, bytes.length);
    }

    private static List<String> toString(byte[] bytes, int start, int end) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            list.add(Integer.toHexString(bytes[i] & 0xFF).toUpperCase(Locale.US));
        }
        return list;
    }

    private static ProtocolHandler loadHandler(UpgradeRequest request) {
        for (Version version : Version.values()) {
            if (!version.validate(request)) continue;
            return version.createHandler(false);
        }
        return null;
    }

    private static void handleUnsupportedVersion(UpgradeRequest request, UpgradeResponse response) {
        response.setStatus(426);
        response.getHeaders().put("Sec-WebSocket-Version", Arrays.asList(Version.getSupportedWireProtocolVersions()));
    }

    WebSocketApplication getApplication(UpgradeRequest request) {
        if (this.applications.isEmpty()) {
            return null;
        }
        String requestPath = request.getRequestUri();
        for (Match m : Match.getAllMatches(requestPath, this.applications)) {
            WebSocketApplication webSocketApplication = m.getWebSocketApplication();
            for (String name : m.getParameterNames()) {
                request.getParameterMap().put(name, Arrays.asList(m.getParameterValue(name)));
            }
            if (!webSocketApplication.upgrade(request)) continue;
            return webSocketApplication;
        }
        return null;
    }

    @Override
    public WebSocketEngine.UpgradeInfo upgrade(UpgradeRequest request, UpgradeResponse response) {
        try {
            WebSocketApplication app = this.getApplication(request);
            if (app != null) {
                ProtocolHandler protocolHandler = TyrusWebSocketEngine.loadHandler(request);
                if (protocolHandler == null) {
                    TyrusWebSocketEngine.handleUnsupportedVersion(request, response);
                    return HANDSHAKE_FAILED_UPGRADE_INFO;
                }
                protocolHandler.handshake(app, request, response);
                return new SuccessfulUpgradeInfo(app, protocolHandler, this.incomingBufferSize);
            }
        }
        catch (HandshakeException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            response.setStatus(e.getCode());
            return HANDSHAKE_FAILED_UPGRADE_INFO;
        }
        response.setStatus(500);
        return NOT_APPLICABLE_UPGRADE_INFO;
    }

    public ReadHandler getReadHandler(WebSocketHolder webSocketHolder) {
        return new TyrusReadHandler(webSocketHolder, this.incomingBufferSize);
    }

    public void setIncomingBufferSize(int incomingBufferSize) {
        this.incomingBufferSize = incomingBufferSize;
    }

    private void register(WebSocketApplication app) throws DeploymentException {
        this.checkPath(app);
        this.applications.add(app);
    }

    @Override
    public void register(Class<?> endpointClass, String contextPath) throws DeploymentException {
        EndpointConfig config;
        AnnotatedEndpoint endpoint;
        ErrorCollector collector = new ErrorCollector();
        TyrusEndpointWrapper ew = new TyrusEndpointWrapper(endpoint, config, this.componentProviderService, this.webSocketContainer, contextPath, (config = (endpoint = AnnotatedEndpoint.fromClass(endpointClass, this.componentProviderService, true, collector)).getEndpointConfig()) instanceof ServerEndpointConfig ? ((ServerEndpointConfig)config).getConfigurator() : null);
        if (!collector.isEmpty()) {
            throw collector.composeComprehensiveException();
        }
        this.register(new TyrusEndpoint(ew));
    }

    @Override
    public void register(ServerEndpointConfig serverConfig, String contextPath) throws DeploymentException {
        TyrusEndpointWrapper ew;
        Class<?> endpointClass = serverConfig.getEndpointClass();
        boolean isEndpointClass = false;
        do {
            if (!(endpointClass = endpointClass.getSuperclass()).equals(Endpoint.class)) continue;
            isEndpointClass = true;
        } while (!endpointClass.equals(Object.class));
        if (isEndpointClass) {
            ew = new TyrusEndpointWrapper(serverConfig.getEndpointClass(), (EndpointConfig)serverConfig, this.componentProviderService, this.webSocketContainer, contextPath, serverConfig.getConfigurator());
        } else {
            EndpointConfig config;
            AnnotatedEndpoint endpoint;
            ErrorCollector collector = new ErrorCollector();
            ew = new TyrusEndpointWrapper(endpoint, config, this.componentProviderService, this.webSocketContainer, contextPath, (config = (endpoint = AnnotatedEndpoint.fromClass(serverConfig.getEndpointClass(), this.componentProviderService, true, collector)).getEndpointConfig()) instanceof ServerEndpointConfig ? ((ServerEndpointConfig)config).getConfigurator() : null);
            if (!collector.isEmpty()) {
                throw collector.composeComprehensiveException();
            }
        }
        this.register(new TyrusEndpoint(ew));
    }

    private void checkPath(WebSocketApplication app) throws DeploymentException {
        for (WebSocketApplication webSocketApplication : this.applications) {
            if (!Match.isEquivalent(app.getPath(), webSocketApplication.getPath())) continue;
            throw new DeploymentException(String.format("Found equivalent paths. Added path: '%s' is equivalent with '%s'.", app.getPath(), webSocketApplication.getPath()));
        }
    }

    public void unregister(WebSocketApplication app) {
        this.applications.remove(app);
    }

    static class TyrusConnection
    implements Connection {
        private final ReadHandler readHandler;
        private final Writer writer;
        private final Connection.CloseListener closeListener;
        private final WebSocket socket;

        TyrusConnection(WebSocketApplication app, ProtocolHandler protocolHandler, int incomingBufferSize, Writer writer, Connection.CloseListener closeListener) {
            protocolHandler.setWriter(writer);
            WebSocket socket = app.createSocket(protocolHandler, app);
            WebSocketHolder holder = new WebSocketHolder(protocolHandler, socket, null, app);
            socket.onConnect();
            this.socket = socket;
            this.readHandler = new TyrusReadHandler(holder, incomingBufferSize);
            this.writer = writer;
            this.closeListener = closeListener;
        }

        @Override
        public ReadHandler getReadHandler() {
            return this.readHandler;
        }

        @Override
        public Writer getWriter() {
            return this.writer;
        }

        @Override
        public Connection.CloseListener getCloseListener() {
            return this.closeListener;
        }

        @Override
        public void close(CloseReason reason) {
            this.socket.close(reason.getCloseCode().getCode(), reason.getReasonPhrase());
        }
    }

    private static class SuccessfulUpgradeInfo
    implements WebSocketEngine.UpgradeInfo {
        private final WebSocketApplication app;
        private final ProtocolHandler protocolHandler;
        private final int incomingBufferSize;

        SuccessfulUpgradeInfo(WebSocketApplication app, ProtocolHandler protocolHandler, int incomingBufferSize) {
            this.app = app;
            this.protocolHandler = protocolHandler;
            this.incomingBufferSize = incomingBufferSize;
        }

        @Override
        public WebSocketEngine.UpgradeStatus getStatus() {
            return WebSocketEngine.UpgradeStatus.SUCCESS;
        }

        @Override
        public Connection createConnection(Writer writer, Connection.CloseListener closeListener) {
            return new TyrusConnection(this.app, this.protocolHandler, this.incomingBufferSize, writer, closeListener);
        }
    }

    private static class NoConnectionUpgradeInfo
    implements WebSocketEngine.UpgradeInfo {
        private final WebSocketEngine.UpgradeStatus status;

        NoConnectionUpgradeInfo(WebSocketEngine.UpgradeStatus status) {
            this.status = status;
        }

        @Override
        public WebSocketEngine.UpgradeStatus getStatus() {
            return this.status;
        }

        @Override
        public Connection createConnection(Writer writer, Connection.CloseListener closeListener) {
            return null;
        }
    }

    public static final class WebSocketHolder {
        public final WebSocket webSocket;
        public final ProtocolHandler handler;
        public final Handshake handshake;
        public final WebSocketApplication application;
        public volatile ByteBuffer buffer;

        public WebSocketHolder(ProtocolHandler handler, WebSocket socket, Handshake handshake, WebSocketApplication application) {
            this.handler = handler;
            this.webSocket = socket;
            this.handshake = handshake;
            this.application = application;
        }
    }

    private static class TyrusReadHandler
    implements ReadHandler {
        private final WebSocketHolder webSocketHolder;
        private final int incomingBufferSize;

        TyrusReadHandler(WebSocketHolder webSocketHolder, int incomingBufferSize) {
            this.webSocketHolder = webSocketHolder;
            this.incomingBufferSize = incomingBufferSize;
        }

        @Override
        public void handle(ByteBuffer data) {
            block10: {
                if (this.webSocketHolder == null) {
                    return;
                }
                try {
                    if (data == null || !data.hasRemaining()) break block10;
                    if (this.webSocketHolder.buffer != null) {
                        data = this.appendBuffers(this.webSocketHolder.buffer, data);
                    } else {
                        int newSize = data.remaining();
                        if (newSize > this.incomingBufferSize) {
                            throw new IllegalArgumentException("Buffer overflow.");
                        }
                        int roundedSize = newSize % 256 > 0 ? (newSize / 256 + 1) * 256 : newSize;
                        ByteBuffer result = ByteBuffer.allocate(roundedSize > this.incomingBufferSize ? newSize : roundedSize);
                        result.flip();
                        data = this.appendBuffers(result, data);
                    }
                    while (true) {
                        DataFrame result;
                        if ((result = this.webSocketHolder.handler.unframe(data)) == null) {
                            this.webSocketHolder.buffer = data;
                            break;
                        }
                        result.respond(this.webSocketHolder.webSocket);
                    }
                }
                catch (FramingException e) {
                    e.printStackTrace();
                    this.webSocketHolder.webSocket.onClose(new CloseReason(CloseReason.CloseCodes.getCloseCode(e.getClosingCode()), e.getMessage()));
                }
                catch (Exception wse) {
                    wse.printStackTrace();
                    if (this.webSocketHolder.application == null) {
                        this.webSocketHolder.webSocket.onClose(new CloseReason(CloseReason.CloseCodes.UNEXPECTED_CONDITION, wse.getMessage()));
                    }
                    if (!this.webSocketHolder.application.onError(this.webSocketHolder.webSocket, wse)) break block10;
                    this.webSocketHolder.webSocket.onClose(new CloseReason(CloseReason.CloseCodes.UNEXPECTED_CONDITION, wse.getMessage()));
                }
            }
        }

        private ByteBuffer appendBuffers(ByteBuffer buffer, ByteBuffer buffer1) {
            int limit = buffer.limit();
            int capacity = buffer.capacity();
            int remaining = buffer.remaining();
            int len = buffer1.remaining();
            if (len < capacity - limit) {
                buffer.mark();
                buffer.position(limit);
                buffer.limit(capacity);
                buffer.put(buffer1);
                buffer.limit(limit + len);
                buffer.reset();
                return buffer;
            }
            if (remaining + len < capacity) {
                buffer.compact();
                buffer.put(buffer1);
                buffer.flip();
                return buffer;
            }
            int newSize = remaining + len;
            if (newSize > this.incomingBufferSize) {
                throw new IllegalArgumentException("Buffer overflow.");
            }
            int roundedSize = newSize % 256 > 0 ? (newSize / 256 + 1) * 256 : newSize;
            ByteBuffer result = ByteBuffer.allocate(roundedSize > this.incomingBufferSize ? newSize : roundedSize);
            result.put(buffer);
            result.put(buffer1);
            result.flip();
            return result;
        }
    }
}

