/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.websocket.CloseReason;
import javax.websocket.SendHandler;
import org.glassfish.tyrus.core.DataFrame;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.WebSocket;
import org.glassfish.tyrus.spi.RemoteEndpoint;

public class TyrusRemoteEndpoint
extends RemoteEndpoint {
    private final WebSocket socket;

    public TyrusRemoteEndpoint(WebSocket socket) {
        this.socket = socket;
    }

    public Future<DataFrame> sendText(String text) {
        return this.socket.send(text);
    }

    @Override
    public void sendText(String text, SendHandler handler) {
        this.socket.send(text, handler);
    }

    public Future<DataFrame> sendBinary(ByteBuffer byteBuffer) {
        return this.socket.send(Utils.getRemainingArray(byteBuffer));
    }

    @Override
    public void sendBinary(ByteBuffer data, SendHandler handler) {
        this.socket.send(Utils.getRemainingArray(data), handler);
    }

    public Future<DataFrame> sendText(String fragment, boolean isLast) {
        return this.socket.stream(isLast, fragment);
    }

    public Future<DataFrame> sendBinary(ByteBuffer byteBuffer, boolean b) {
        byte[] bytes = Utils.getRemainingArray(byteBuffer);
        return this.socket.stream(b, bytes, 0, bytes.length);
    }

    public Future<DataFrame> sendPing(ByteBuffer byteBuffer) {
        return this.socket.sendPing(Utils.getRemainingArray(byteBuffer));
    }

    public Future<DataFrame> sendPong(ByteBuffer byteBuffer) {
        return this.socket.sendPong(Utils.getRemainingArray(byteBuffer));
    }

    @Override
    public void close(CloseReason closeReason) {
        this.socket.close(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
    }

    @Override
    public void setWriteTimeout(long timeoutMs) {
        this.socket.setWriteTimeout(timeoutMs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TyrusRemoteEndpoint)) {
            return false;
        }
        TyrusRemoteEndpoint that = (TyrusRemoteEndpoint)o;
        return this.socket.equals(that.socket);
    }

    public int hashCode() {
        return this.socket.hashCode();
    }

    public Future<DataFrame> sendRawFrame(ByteBuffer dataFrame) {
        return this.socket.sendRawFrame(dataFrame);
    }

    WebSocket getSocket() {
        return this.socket;
    }
}

