/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import org.glassfish.tyrus.core.OutputStreamToAsyncBinaryAdapter;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusSession;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.WriterToAsyncTextAdapter;

public abstract class RemoteEndpointWrapper
implements RemoteEndpoint {
    final org.glassfish.tyrus.spi.RemoteEndpoint remoteEndpoint;
    final TyrusSession session;
    final TyrusEndpointWrapper tyrusEndpointWrapper;

    private RemoteEndpointWrapper(TyrusSession session, org.glassfish.tyrus.spi.RemoteEndpoint remoteEndpoint, TyrusEndpointWrapper tyrusEndpointWrapper) {
        this.remoteEndpoint = remoteEndpoint;
        this.tyrusEndpointWrapper = tyrusEndpointWrapper;
        this.session = session;
    }

    Future<?> sendSyncObject(Object o) {
        Object toSend;
        if (o instanceof String) {
            return this.remoteEndpoint.sendText((String)o);
        }
        try {
            toSend = this.tyrusEndpointWrapper.doEncode(this.session, o);
        }
        catch (Exception e) {
            return new Future<Object>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                @Override
                public Object get() throws InterruptedException, ExecutionException {
                    throw new ExecutionException(e);
                }

                @Override
                public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    throw new ExecutionException(e);
                }
            };
        }
        if (toSend instanceof String) {
            return this.remoteEndpoint.sendText((String)toSend);
        }
        if (toSend instanceof ByteBuffer) {
            return this.remoteEndpoint.sendBinary((ByteBuffer)toSend);
        }
        if (toSend instanceof StringWriter) {
            StringWriter writer = (StringWriter)toSend;
            StringBuffer sb = writer.getBuffer();
            return this.remoteEndpoint.sendText(sb.toString());
        }
        if (toSend instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)toSend;
            ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
            return this.remoteEndpoint.sendBinary(buffer);
        }
        return null;
    }

    void sendSyncObject(Object o, SendHandler handler) {
        if (o instanceof String) {
            this.remoteEndpoint.sendText((String)o, handler);
        } else {
            Object toSend = null;
            try {
                toSend = this.tyrusEndpointWrapper.doEncode(this.session, o);
            }
            catch (Exception e) {
                handler.onResult(new SendResult(e));
            }
            if (toSend instanceof String) {
                this.remoteEndpoint.sendText((String)toSend, handler);
            } else if (toSend instanceof ByteBuffer) {
                this.remoteEndpoint.sendBinary((ByteBuffer)toSend, handler);
            } else if (toSend instanceof StringWriter) {
                StringWriter writer = (StringWriter)toSend;
                StringBuffer sb = writer.getBuffer();
                this.remoteEndpoint.sendText(sb.toString(), handler);
            } else if (toSend instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream baos = (ByteArrayOutputStream)toSend;
                ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
                this.remoteEndpoint.sendBinary(buffer, handler);
            }
        }
    }

    @Override
    public void sendPing(ByteBuffer applicationData) throws IOException {
        if (applicationData != null && applicationData.remaining() > 125) {
            throw new IllegalArgumentException("Ping applicationData exceeded the maximum allowed payload of 125 bytes.");
        }
        this.session.restartIdleTimeoutExecutor();
        this.remoteEndpoint.sendPing(applicationData);
    }

    @Override
    public void sendPong(ByteBuffer applicationData) throws IOException {
        if (applicationData != null && applicationData.remaining() > 125) {
            throw new IllegalArgumentException("Pong applicationData exceeded the maximum allowed payload of 125 bytes.");
        }
        this.session.restartIdleTimeoutExecutor();
        this.remoteEndpoint.sendPong(applicationData);
    }

    public String toString() {
        return "Wrapped: " + this.getClass().getSimpleName();
    }

    @Override
    public void setBatchingAllowed(boolean allowed) {
    }

    @Override
    public boolean getBatchingAllowed() {
        return false;
    }

    @Override
    public void flushBatch() {
    }

    public void close(CloseReason cr) {
        Logger.getLogger(RemoteEndpointWrapper.class.getName()).fine("Close public void close(CloseReason cr): " + cr);
        this.remoteEndpoint.close(cr);
    }

    static class Async
    extends RemoteEndpointWrapper
    implements RemoteEndpoint.Async {
        private long sendTimeout;

        Async(TyrusSession session, org.glassfish.tyrus.spi.RemoteEndpoint remoteEndpoint, TyrusEndpointWrapper tyrusEndpointWrapper) {
            super(session, remoteEndpoint, tyrusEndpointWrapper);
            if (session.getContainer() != null) {
                this.setSendTimeout(session.getContainer().getDefaultAsyncSendTimeout());
            }
        }

        @Override
        public void sendText(String text, SendHandler handler) {
            Utils.checkNotNull(text, "Argument 'text' cannot be null.");
            Utils.checkNotNull(handler, "Argument 'handler' cannot be null.");
            this.session.restartIdleTimeoutExecutor();
            this.sendAsync(text, handler, AsyncMessageType.TEXT);
        }

        @Override
        public Future<Void> sendText(String text) {
            Utils.checkNotNull(text, "Argument 'text' cannot be null.");
            this.session.restartIdleTimeoutExecutor();
            return this.sendAsync(text, AsyncMessageType.TEXT);
        }

        @Override
        public Future<Void> sendBinary(ByteBuffer data) {
            Utils.checkNotNull(data, "Argument 'data' cannot be null.");
            this.session.restartIdleTimeoutExecutor();
            return this.sendAsync(data, AsyncMessageType.BINARY);
        }

        @Override
        public void sendBinary(ByteBuffer data, SendHandler handler) {
            Utils.checkNotNull(data, "Argument 'data' cannot be null.");
            Utils.checkNotNull(handler, "Argument 'handler' cannot be null.");
            this.session.restartIdleTimeoutExecutor();
            this.sendAsync(data, handler, AsyncMessageType.BINARY);
        }

        @Override
        public void sendObject(Object data, SendHandler handler) {
            Utils.checkNotNull(data, "Argument 'data' cannot be null.");
            Utils.checkNotNull(handler, "Argument 'handler' cannot be null.");
            this.session.restartIdleTimeoutExecutor();
            this.sendAsync(data, handler, AsyncMessageType.OBJECT);
        }

        @Override
        public Future<Void> sendObject(Object data) {
            Utils.checkNotNull(data, "Argument 'data' cannot be null.");
            this.session.restartIdleTimeoutExecutor();
            return this.sendAsync(data, AsyncMessageType.OBJECT);
        }

        @Override
        public long getSendTimeout() {
            return this.sendTimeout;
        }

        @Override
        public void setSendTimeout(long timeoutmillis) {
            this.sendTimeout = timeoutmillis;
            this.remoteEndpoint.setWriteTimeout(timeoutmillis);
        }

        private Future<Void> sendAsync(Object message, AsyncMessageType type) {
            Future<?> result = null;
            switch (type) {
                case TEXT: {
                    result = this.remoteEndpoint.sendText((String)message);
                    break;
                }
                case BINARY: {
                    result = this.remoteEndpoint.sendBinary((ByteBuffer)message);
                    break;
                }
                case OBJECT: {
                    result = this.sendSyncObject(message);
                }
            }
            final Future<?> finalResult = result;
            return new Future<Void>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return finalResult.cancel(mayInterruptIfRunning);
                }

                @Override
                public boolean isCancelled() {
                    return finalResult.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return finalResult.isDone();
                }

                @Override
                public Void get() throws InterruptedException, ExecutionException {
                    finalResult.get();
                    return null;
                }

                @Override
                public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    finalResult.get(timeout, unit);
                    return null;
                }
            };
        }

        private void sendAsync(Object message, SendHandler handler, AsyncMessageType type) {
            switch (type) {
                case TEXT: {
                    this.remoteEndpoint.sendText((String)message, handler);
                    break;
                }
                case BINARY: {
                    this.remoteEndpoint.sendBinary((ByteBuffer)message, handler);
                    break;
                }
                case OBJECT: {
                    this.sendSyncObject(message, handler);
                }
            }
        }

        private static enum AsyncMessageType {
            TEXT,
            BINARY,
            OBJECT;

        }
    }

    static class Basic
    extends RemoteEndpointWrapper
    implements RemoteEndpoint.Basic {
        Basic(TyrusSession session, org.glassfish.tyrus.spi.RemoteEndpoint remoteEndpoint, TyrusEndpointWrapper tyrusEndpointWrapper) {
            super(session, remoteEndpoint, tyrusEndpointWrapper);
        }

        @Override
        public void sendText(String text) throws IOException {
            Utils.checkNotNull(text, "Argument 'text' cannot be null.");
            Future<?> future = this.remoteEndpoint.sendText(text);
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e.getCause());
            }
            this.session.restartIdleTimeoutExecutor();
        }

        @Override
        public void sendBinary(ByteBuffer data) throws IOException {
            Utils.checkNotNull(data, "Argument 'data' cannot be null.");
            Future<?> future = this.remoteEndpoint.sendBinary(data);
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e.getCause());
            }
            this.session.restartIdleTimeoutExecutor();
        }

        @Override
        public void sendText(String partialMessage, boolean isLast) throws IOException {
            Utils.checkNotNull(partialMessage, "Argument 'partialMessage' cannot be null.");
            Future<?> future = this.remoteEndpoint.sendText(partialMessage, isLast);
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e.getCause());
            }
            this.session.restartIdleTimeoutExecutor();
        }

        @Override
        public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
            Utils.checkNotNull(partialByte, "Argument 'partialByte' cannot be null.");
            Future<?> future = this.remoteEndpoint.sendBinary(partialByte, isLast);
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e.getCause());
            }
            this.session.restartIdleTimeoutExecutor();
        }

        @Override
        public void sendObject(Object data) throws IOException, EncodeException {
            Utils.checkNotNull(data, "Argument 'data' cannot be null.");
            Future<?> future = this.sendSyncObject(data);
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                if (e.getCause() instanceof EncodeException) {
                    throw (EncodeException)e.getCause();
                }
                throw new IOException(e.getCause());
            }
            this.session.restartIdleTimeoutExecutor();
        }

        @Override
        public OutputStream getSendStream() throws IOException {
            return new OutputStreamToAsyncBinaryAdapter(this.remoteEndpoint);
        }

        @Override
        public Writer getSendWriter() throws IOException {
            return new WriterToAsyncTextAdapter(this.remoteEndpoint);
        }
    }
}

