/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueRecord;
import org.glassfish.grizzly.asyncqueue.PushBackHandler;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.utils.DebugPoint;

public class AsyncWriteQueueRecord
extends AsyncQueueRecord<WriteResult> {
    private static final ThreadCache.CachedTypeIndex<AsyncWriteQueueRecord> CACHE_IDX = ThreadCache.obtainIndex(AsyncWriteQueueRecord.class, 2);
    private long initialMessageSize;
    private boolean isEmptyRecord;
    private Object dstAddress;
    private PushBackHandler pushBackHandler;

    public static AsyncWriteQueueRecord create(Connection connection, WritableMessage message, WriteResult currentResult, CompletionHandler completionHandler, Object dstAddress, PushBackHandler pushbackHandler, boolean isEmptyRecord) {
        AsyncWriteQueueRecord asyncWriteQueueRecord = ThreadCache.takeFromCache(CACHE_IDX);
        if (asyncWriteQueueRecord != null) {
            asyncWriteQueueRecord.isRecycled = false;
            asyncWriteQueueRecord.set(connection, message, currentResult, completionHandler, dstAddress, pushbackHandler, isEmptyRecord);
            return asyncWriteQueueRecord;
        }
        return new AsyncWriteQueueRecord(connection, message, currentResult, completionHandler, dstAddress, pushbackHandler, isEmptyRecord);
    }

    protected AsyncWriteQueueRecord(Connection connection, WritableMessage message, WriteResult currentResult, CompletionHandler completionHandler, Object dstAddress, PushBackHandler pushBackHandler, boolean isEmptyRecord) {
        super(connection, message, currentResult, completionHandler);
        this.dstAddress = dstAddress;
        this.isEmptyRecord = isEmptyRecord;
        this.initialMessageSize = message != null ? (long)message.remaining() : 0L;
        this.pushBackHandler = pushBackHandler;
    }

    protected void set(Connection connection, WritableMessage message, WriteResult currentResult, CompletionHandler completionHandler, Object dstAddress, PushBackHandler pushBackHandler, boolean isEmptyRecord) {
        super.set(connection, message, currentResult, completionHandler);
        this.dstAddress = dstAddress;
        this.isEmptyRecord = isEmptyRecord;
        this.initialMessageSize = message != null ? (long)message.remaining() : 0L;
        this.pushBackHandler = pushBackHandler;
    }

    public final Object getDstAddress() {
        this.checkRecycled();
        return this.dstAddress;
    }

    public final WritableMessage getWritableMessage() {
        return (WritableMessage)this.message;
    }

    public boolean isEmptyRecord() {
        return this.isEmptyRecord;
    }

    public void setEmptyRecord(boolean isEmptyRecord) {
        this.isEmptyRecord = isEmptyRecord;
    }

    public long getInitialMessageSize() {
        return this.initialMessageSize;
    }

    public long remaining() {
        return this.getWritableMessage().remaining();
    }

    @Deprecated
    public PushBackHandler getPushBackHandler() {
        return this.pushBackHandler;
    }

    public boolean canBeAggregated() {
        return !this.getWritableMessage().isExternal();
    }

    public void notifyCompleteAndRecycle() {
        WriteResult currentResultLocal = (WriteResult)this.currentResult;
        CompletionHandler completionHandlerLocal = this.completionHandler;
        WritableMessage messageLocal = this.getWritableMessage();
        this.recycle();
        if (completionHandlerLocal != null) {
            completionHandlerLocal.completed(currentResultLocal);
        } else {
            currentResultLocal.recycle();
        }
        messageLocal.release();
    }

    public boolean isFinished() {
        return !this.getWritableMessage().hasRemaining();
    }

    protected final void reset() {
        this.set(null, null, null, null, null, null, false);
    }

    @Override
    public void recycle() {
        this.checkRecycled();
        this.reset();
        this.isRecycled = true;
        if (Grizzly.isTrackingThreadCache()) {
            this.recycleTrack = new DebugPoint(new Exception(), Thread.currentThread().getName());
        }
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

