/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.websocket.Extension;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.SecKey;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.core.WebSocketApplication;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;

public final class Handshake {
    public static final int RESPONSE_CODE_VALUE = 101;
    private static final String VERSION = "13";
    private boolean secure;
    private String origin;
    private String serverHostName;
    private int port = 80;
    private String resourcePath;
    private List<String> subProtocols = new ArrayList<String>();
    private List<Extension> extensions = new ArrayList<Extension>();
    private UpgradeRequest request;
    private UpgradeRequest incomingRequest;
    private SecKey secKey;

    private Handshake() {
    }

    static Handshake createClientHandShake(UpgradeRequest webSocketRequest) {
        Handshake handshake = new Handshake();
        handshake.request = webSocketRequest;
        URI uri = webSocketRequest.getRequestURI();
        handshake.resourcePath = uri.getPath();
        if ("".equals(handshake.resourcePath)) {
            handshake.resourcePath = "/";
        }
        if (uri.getQuery() != null) {
            handshake.resourcePath = handshake.resourcePath + "?" + uri.getQuery();
        }
        handshake.serverHostName = uri.getHost();
        handshake.secure = webSocketRequest.isSecure();
        handshake.port = uri.getPort();
        handshake.origin = Handshake.appendPort(new StringBuilder(uri.getHost()), handshake.port, handshake.secure).toString();
        handshake.secKey = new SecKey();
        return handshake;
    }

    static Handshake createServerHandShake(UpgradeRequest request) {
        List<String> value;
        Handshake handshake = new Handshake();
        handshake.incomingRequest = request;
        Handshake.checkForHeader(request.getHeader("Upgrade"), "Upgrade", "WebSocket");
        Handshake.checkForHeader(request.getHeader("Connection"), "Connection", "Upgrade");
        handshake.origin = request.getHeader("Sec-WebSocket-Origin");
        if (handshake.origin == null) {
            handshake.origin = request.getHeader("Origin");
        }
        Handshake.determineHostAndPort(handshake, request);
        String protocolHeader = request.getHeader("Sec-WebSocket-Protocol");
        List<Object> list = handshake.subProtocols = protocolHeader == null ? Collections.emptyList() : Arrays.asList(protocolHeader.split(","));
        if (handshake.serverHostName == null) {
            throw new HandshakeException("Missing required headers for WebSocket negotiation");
        }
        handshake.resourcePath = request.getRequestUri();
        String queryString = request.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            handshake.resourcePath = handshake.resourcePath + "?" + queryString;
        }
        if ((value = request.getHeaders().get("Sec-WebSocket-Extensions")) != null) {
            handshake.extensions = TyrusExtension.fromHeaders(value);
        }
        handshake.secKey = SecKey.generateServerKey(new SecKey(request.getHeader("Sec-WebSocket-Key")));
        return handshake;
    }

    private static void checkForHeader(String currentValue, String header, String validValue) {
        Handshake.validate(header, validValue, currentValue);
    }

    private static void validate(String header, String validValue, String value) {
        if (header.equalsIgnoreCase("Connection") ? !value.toLowerCase().contains(validValue.toLowerCase()) : !value.equalsIgnoreCase(validValue)) {
            throw new HandshakeException(String.format("Invalid %s header returned: '%s'", header, value));
        }
    }

    private static void determineHostAndPort(Handshake handshake, UpgradeRequest request) {
        int i;
        String header = request.getHeader("Host");
        int n = i = header == null ? -1 : header.indexOf(":");
        if (i == -1) {
            handshake.serverHostName = header;
            handshake.port = 80;
        } else {
            handshake.serverHostName = header.substring(0, i);
            handshake.port = Integer.valueOf(header.substring(i + 1));
        }
    }

    private static StringBuilder appendPort(StringBuilder builder, int port, boolean secure) {
        if (secure) {
            if (port != 443 && port != -1) {
                builder.append(':').append(port);
            }
        } else if (port != 80 && port != -1) {
            builder.append(':').append(port);
        }
        return builder;
    }

    String getOrigin() {
        return this.origin;
    }

    int getPort() {
        return this.port;
    }

    String getServerHostName() {
        return this.serverHostName;
    }

    List<String> getSubProtocols() {
        return this.subProtocols;
    }

    public void setSubProtocols(List<String> subProtocols) {
        this.subProtocols = subProtocols;
    }

    <T> String getHeaderFromList(List<T> list, Stringifier<T> stringifier) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            if (stringifier != null) {
                sb.append(stringifier.toString(it.next()));
            } else {
                sb.append(it.next());
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    <T> List<String> getStringList(List<T> list, Stringifier<T> stringifier) {
        ArrayList<String> result = new ArrayList<String>();
        for (T item : list) {
            if (stringifier != null) {
                result.add(stringifier.toString(item));
                continue;
            }
            result.add(item.toString());
        }
        return result;
    }

    List<Extension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    public UpgradeRequest getRequest() {
        return this.request;
    }

    public UpgradeRequest prepareRequest() {
        String host = this.getServerHostName();
        if (this.port != -1 && this.port != 80 && this.port != 443) {
            host = host + ":" + this.getPort();
        }
        this.putSingleHeader(this.request, "Host", host);
        this.putSingleHeader(this.request, "Connection", "Upgrade");
        this.putSingleHeader(this.request, "Upgrade", "websocket");
        this.putSingleHeader(this.request, "Sec-WebSocket-Key", this.secKey.toString());
        this.putSingleHeader(this.request, "Sec-WebSocket-Origin", this.getOrigin());
        this.putSingleHeader(this.request, "Sec-WebSocket-Version", VERSION);
        if (!this.getSubProtocols().isEmpty()) {
            this.putSingleHeader(this.request, "Sec-WebSocket-Protocol", this.getHeaderFromList(this.subProtocols, null));
        }
        if (!this.getExtensions().isEmpty()) {
            this.putSingleHeader(this.request, "Sec-WebSocket-Extensions", this.getHeaderFromList(this.getExtensions(), new Stringifier<Extension>(){

                @Override
                String toString(Extension extension) {
                    return TyrusExtension.toString(extension);
                }
            }));
        }
        String headerValue = this.request.getHeader("Sec-WebSocket-Origin");
        this.request.getHeaders().remove("Sec-WebSocket-Origin");
        this.putSingleHeader(this.request, "Origin", headerValue);
        return this.request;
    }

    private void putSingleHeader(UpgradeRequest request, String headerName, String headerValue) {
        request.getHeaders().put(headerName, Arrays.asList(headerValue));
    }

    public void validateServerResponse(UpgradeResponse response) {
        if (101 != response.getStatus()) {
            throw new HandshakeException(String.format("Response code was not %s: %s", 101, response.getStatus()));
        }
        Handshake.checkForHeader(response.getFirstHeaderValue("Upgrade"), "Upgrade", "websocket");
        Handshake.checkForHeader(response.getFirstHeaderValue("Connection"), "Connection", "Upgrade");
        this.secKey.validateServerKey(response.getFirstHeaderValue("Sec-WebSocket-Accept"));
    }

    void respond(UpgradeResponse response, WebSocketApplication application) {
        List<String> appProtocols;
        response.setStatus(101);
        response.getHeaders().put("Upgrade", Arrays.asList("websocket"));
        response.getHeaders().put("Connection", Arrays.asList("Upgrade"));
        response.setReasonPhrase("Switching Protocols");
        response.getHeaders().put("Sec-WebSocket-Accept", Arrays.asList(this.secKey.getSecKey()));
        if (this.subProtocols != null && !this.subProtocols.isEmpty() && !(appProtocols = application.getSupportedProtocols(this.subProtocols)).isEmpty()) {
            response.getHeaders().put("Sec-WebSocket-Protocol", this.getStringList(appProtocols, null));
        }
        if (!application.getSupportedExtensions().isEmpty()) {
            response.getHeaders().put("Sec-WebSocket-Extensions", this.getStringList(application.getSupportedExtensions(), new Stringifier<Extension>(){

                @Override
                String toString(Extension extension) {
                    return TyrusExtension.toString(extension);
                }
            }));
        }
        application.onHandShakeResponse(this.incomingRequest, response);
    }

    static abstract class Stringifier<T> {
        Stringifier() {
        }

        abstract String toString(T var1);
    }
}

