/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.GracefulShutdownListener;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventProcessingHandler;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.Reader;
import org.glassfish.grizzly.TransportProbe;
import org.glassfish.grizzly.Writer;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.monitoring.MonitoringAware;
import org.glassfish.grizzly.monitoring.MonitoringConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;
import org.glassfish.grizzly.utils.StateHolder;

public interface Transport
extends MonitoringAware<TransportProbe> {
    public static final int DEFAULT_READ_BUFFER_SIZE = -1;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = -1;
    public static final int DEFAULT_READ_TIMEOUT = 30;
    public static final int DEFAULT_WRITE_TIMEOUT = 30;

    public String getName();

    public void setName(String var1);

    public StateHolder<State> getState();

    public boolean isBlocking();

    public void configureBlocking(boolean var1);

    public void configureStandalone(boolean var1);

    public boolean isStandalone();

    public Processor obtainProcessor(IOEvent var1, Connection var2);

    public Processor getProcessor();

    public void setProcessor(Processor var1);

    public ProcessorSelector getProcessorSelector();

    public void setProcessorSelector(ProcessorSelector var1);

    public MemoryManager getMemoryManager();

    public void setMemoryManager(MemoryManager var1);

    public IOStrategy getIOStrategy();

    public void setIOStrategy(IOStrategy var1);

    public int getReadBufferSize();

    public void setReadBufferSize(int var1);

    public int getWriteBufferSize();

    public void setWriteBufferSize(int var1);

    public ExecutorService getWorkerThreadPool();

    public ExecutorService getKernelThreadPool();

    public void setWorkerThreadPool(ExecutorService var1);

    public void setKernelThreadPool(ExecutorService var1);

    public void setKernelThreadPoolConfig(ThreadPoolConfig var1);

    public void setWorkerThreadPoolConfig(ThreadPoolConfig var1);

    public ThreadPoolConfig getKernelThreadPoolConfig();

    public ThreadPoolConfig getWorkerThreadPoolConfig();

    public AttributeBuilder getAttributeBuilder();

    public void setAttributeBuilder(AttributeBuilder var1);

    public void start() throws IOException;

    @Deprecated
    public void stop() throws IOException;

    public GrizzlyFuture<Transport> shutdown();

    public GrizzlyFuture<Transport> shutdown(long var1, TimeUnit var3);

    public void shutdownNow() throws IOException;

    public boolean addShutdownListener(GracefulShutdownListener var1);

    public void pause();

    public void resume();

    public void fireIOEvent(IOEvent var1, Connection var2, IOEventProcessingHandler var3);

    public boolean isStopped();

    public boolean isPaused();

    public Reader getReader(Connection var1);

    public Reader getReader(boolean var1);

    public Writer getWriter(Connection var1);

    public Writer getWriter(boolean var1);

    public MonitoringConfig<ConnectionProbe> getConnectionMonitoringConfig();

    public MonitoringConfig<ThreadPoolProbe> getThreadPoolMonitoringConfig();

    @Override
    public MonitoringConfig<TransportProbe> getMonitoringConfig();

    public void notifyTransportError(Throwable var1);

    public long getReadTimeout(TimeUnit var1);

    public void setReadTimeout(long var1, TimeUnit var3);

    public long getWriteTimeout(TimeUnit var1);

    public void setWriteTimeout(long var1, TimeUnit var3);

    public static enum State {
        STARTING,
        STARTED,
        PAUSING,
        PAUSED,
        STOPPING,
        STOPPED;

    }
}

