/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.glassfish.tyrus.core.DataFrame;
import org.glassfish.tyrus.core.EndpointWrapper;
import org.glassfish.tyrus.core.FramingException;
import org.glassfish.tyrus.core.Handshake;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusEndpoint;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.core.TyrusRemoteEndpoint;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.Version;
import org.glassfish.tyrus.core.WebSocket;
import org.glassfish.tyrus.spi.ClientEngine;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.Writer;

public class TyrusClientEngine
implements ClientEngine {
    private static final int DEFAULT_INCOMING_BUFFER_SIZE = 0x40000B;
    private static final Version DEFAULT_VERSION = Version.DRAFT17;
    private static final int BUFFER_STEP_SIZE = 256;
    private final ProtocolHandler protocolHandler = DEFAULT_VERSION.createHandler(true);
    private final EndpointWrapper endpointWrapper;
    private final ClientHandshakeListener listener;
    private final Map<String, Object> properties;
    private Handshake clientHandShake = null;
    private volatile ClientEngine.TimeoutHandler timeoutHandler = null;

    TyrusClientEngine(EndpointWrapper endpointWrapper, ClientHandshakeListener listener, Map<String, Object> properties) {
        this.endpointWrapper = endpointWrapper;
        this.listener = listener;
        this.properties = properties;
    }

    @Override
    public UpgradeRequest createUpgradeRequest(URI uri, ClientEngine.TimeoutHandler timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
        this.clientHandShake = this.protocolHandler.createClientHandShake(RequestContext.Builder.create().requestURI(uri).build());
        ClientEndpointConfig config = (ClientEndpointConfig)this.endpointWrapper.getEndpointConfig();
        this.clientHandShake.setExtensions(config.getExtensions());
        this.clientHandShake.setSubProtocols(config.getPreferredSubprotocols());
        this.clientHandShake.prepareRequest();
        config.getConfigurator().beforeRequest(this.clientHandShake.getRequest().getHeaders());
        return this.clientHandShake.getRequest();
    }

    @Override
    public Connection processResponse(UpgradeResponse upgradeResponse, final Writer writer, final Connection.CloseListener closeListener) {
        try {
            this.clientHandShake.validateServerResponse(upgradeResponse);
            final TyrusWebSocket tyrusWebSocket = new TyrusWebSocket(this.protocolHandler, new TyrusEndpoint(this.endpointWrapper));
            Session sessionForRemoteEndpoint = this.endpointWrapper.createSessionForRemoteEndpoint(new TyrusRemoteEndpoint(tyrusWebSocket), upgradeResponse.getFirstHeaderValue("Sec-WebSocket-Protocol"), TyrusExtension.fromHeaders(upgradeResponse.getHeaders().get("Sec-WebSocket-Extensions")));
            ((ClientEndpointConfig)this.endpointWrapper.getEndpointConfig()).getConfigurator().afterResponse(upgradeResponse);
            this.protocolHandler.setWriter(writer);
            this.protocolHandler.setWebSocket(tyrusWebSocket);
            tyrusWebSocket.onConnect(this.clientHandShake.getRequest());
            this.listener.onSessionCreated(sessionForRemoteEndpoint);
            Object o = this.properties.get("org.glassfish.tyrus.incomingBufferSize");
            final int incomingBufferSize = o != null && o instanceof Integer ? (Integer)o : 0x40000B;
            return new Connection(){
                private final ReadHandler readHandler;
                {
                    this.readHandler = new TyrusReadHandler(TyrusClientEngine.this.protocolHandler, tyrusWebSocket, incomingBufferSize);
                }

                @Override
                public ReadHandler getReadHandler() {
                    return this.readHandler;
                }

                @Override
                public Writer getWriter() {
                    return writer;
                }

                @Override
                public Connection.CloseListener getCloseListener() {
                    return closeListener;
                }

                @Override
                public void close(CloseReason reason) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getMessage(), e);
                    }
                }
            };
        }
        catch (HandshakeException e) {
            this.listener.onError(e);
            return null;
        }
    }

    public ClientEngine.TimeoutHandler getTimeoutHandler() {
        return this.timeoutHandler;
    }

    private static class TyrusReadHandler
    implements ReadHandler {
        private final int incomingBufferSize;
        private final ProtocolHandler handler;
        private final WebSocket webSocket;
        private ByteBuffer buffer = null;

        TyrusReadHandler(ProtocolHandler handler, WebSocket webSocket, int incomingBufferSize) {
            this.handler = handler;
            this.webSocket = webSocket;
            this.incomingBufferSize = incomingBufferSize;
        }

        @Override
        public void handle(ByteBuffer data) {
            block8: {
                try {
                    if (data == null || !data.hasRemaining()) break block8;
                    if (this.buffer != null) {
                        data = Utils.appendBuffers(this.buffer, data, this.incomingBufferSize, 256);
                    } else {
                        int newSize = data.remaining();
                        if (newSize > this.incomingBufferSize) {
                            throw new IllegalArgumentException("Buffer overflow.");
                        }
                        int roundedSize = newSize % 256 > 0 ? (newSize / 256 + 1) * 256 : newSize;
                        ByteBuffer result = ByteBuffer.allocate(roundedSize > this.incomingBufferSize ? newSize : roundedSize);
                        result.flip();
                        data = Utils.appendBuffers(result, data, this.incomingBufferSize, 256);
                    }
                    while (true) {
                        DataFrame result;
                        if ((result = this.handler.unframe(data)) == null) {
                            this.buffer = data;
                            break;
                        }
                        result.respond(this.webSocket);
                    }
                }
                catch (FramingException e) {
                    e.printStackTrace();
                    this.webSocket.onClose(new CloseReason(CloseReason.CloseCodes.getCloseCode(e.getClosingCode()), e.getMessage()));
                }
                catch (Exception wse) {
                    this.webSocket.onClose(new CloseReason(CloseReason.CloseCodes.UNEXPECTED_CONDITION, wse.getMessage()));
                }
            }
        }
    }

    public static interface ClientHandshakeListener {
        public void onSessionCreated(Session var1);

        public void onError(Throwable var1);
    }
}

