/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.client.TyrusClientEngine;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.BaseContainer;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.ReflectionHelper;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusFuture;
import org.glassfish.tyrus.spi.ClientContainer;
import org.glassfish.tyrus.spi.ClientEngine;

public class ClientManager
extends BaseContainer
implements WebSocketContainer {
    public static final String HANDSHAKE_TIMEOUT = "org.glassfish.tyrus.client.ClientManager.ContainerTimeout";
    private static final String CONTAINER_PROVIDER_CLASSNAME = "org.glassfish.tyrus.container.grizzly.client.GrizzlyClientContainer";
    private static final Logger LOGGER = Logger.getLogger(ClientManager.class.getName());
    private final WebSocketContainer webSocketContainer;
    private final ClientContainer container;
    private final ComponentProviderService componentProvider;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private volatile long defaultAsyncSendTimeout;
    private volatile long defaultMaxSessionIdleTimeout;
    private volatile int maxBinaryMessageBufferSize = Integer.MAX_VALUE;
    private volatile int maxTextMessageBufferSize = Integer.MAX_VALUE;

    public static ClientManager createClient() {
        return ClientManager.createClient(CONTAINER_PROVIDER_CLASSNAME);
    }

    public static ClientManager createClient(WebSocketContainer webSocketContainer) {
        return ClientManager.createClient(CONTAINER_PROVIDER_CLASSNAME, webSocketContainer);
    }

    public static ClientManager createClient(String containerProviderClassName) {
        return new ClientManager(containerProviderClassName, null);
    }

    public static ClientManager createClient(String containerProviderClassName, WebSocketContainer webSocketContainer) {
        return new ClientManager(containerProviderClassName, webSocketContainer);
    }

    public ClientManager() {
        this(CONTAINER_PROVIDER_CLASSNAME, null);
    }

    private ClientManager(String containerProviderClassName, WebSocketContainer webSocketContainer) {
        Class engineProviderClazz;
        ErrorCollector collector = new ErrorCollector();
        this.componentProvider = ComponentProviderService.create();
        try {
            engineProviderClazz = ReflectionHelper.classForNameWithException(containerProviderClassName);
        }
        catch (ClassNotFoundException e) {
            collector.addException(e);
            throw new RuntimeException(collector.composeComprehensiveException());
        }
        LOGGER.config(String.format("Provider class loaded: %s", containerProviderClassName));
        this.container = (ClientContainer)ReflectionHelper.getInstance(engineProviderClazz, collector);
        if (!collector.isEmpty()) {
            throw new RuntimeException(collector.composeComprehensiveException());
        }
        this.webSocketContainer = webSocketContainer;
    }

    public Session connectToServer(Class annotatedEndpointClass, URI path) throws DeploymentException, IOException {
        if (annotatedEndpointClass.getAnnotation(ClientEndpoint.class) == null) {
            throw new DeploymentException(String.format("Class argument in connectToServer(Class, URI) is to be annotated endpoint class.Class %s does not have @ClientEndpoint", annotatedEndpointClass.getName()));
        }
        try {
            return this.connectToServer(annotatedEndpointClass, null, path.toString(), new SameThreadExecutorService()).get();
        }
        catch (InterruptedException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException) {
                throw (DeploymentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new DeploymentException(cause.getMessage(), cause);
        }
    }

    @Override
    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        try {
            return this.connectToServer(endpointClass, cec, path.toString(), new SameThreadExecutorService()).get();
        }
        catch (InterruptedException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException) {
                throw (DeploymentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new DeploymentException(cause.getMessage(), cause);
        }
    }

    @Override
    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        try {
            return this.connectToServer(endpointInstance, cec, path.toString(), new SameThreadExecutorService()).get();
        }
        catch (InterruptedException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException) {
                throw (DeploymentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new DeploymentException(cause.getMessage(), cause);
        }
    }

    @Override
    public Session connectToServer(Object obj, URI path) throws DeploymentException, IOException {
        try {
            return this.connectToServer(obj, null, path.toString(), new SameThreadExecutorService()).get();
        }
        catch (InterruptedException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException) {
                throw (DeploymentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new DeploymentException(cause.getMessage(), cause);
        }
    }

    public Future<Session> asyncConnectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException {
        if (annotatedEndpointClass.getAnnotation(ClientEndpoint.class) == null) {
            throw new DeploymentException(String.format("Class argument in connectToServer(Class, URI) is to be annotated endpoint class.Class %s does not have @ClientEndpoint", annotatedEndpointClass.getName()));
        }
        return this.connectToServer(annotatedEndpointClass, null, path.toString(), this.getExecutorService());
    }

    public Future<Session> asyncConnectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException {
        return this.connectToServer(endpointClass, cec, path.toString(), this.getExecutorService());
    }

    public Future<Session> asyncConnectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException {
        return this.connectToServer(endpointInstance, cec, path.toString(), this.getExecutorService());
    }

    public Future<Session> asyncConnectToServer(Object obj, URI path) throws DeploymentException {
        return this.connectToServer(obj, null, path.toString(), this.getExecutorService());
    }

    Future<Session> connectToServer(final Object o, final ClientEndpointConfig configuration, final String url, ExecutorService executorService) throws DeploymentException {
        final TyrusFuture<Session> future = new TyrusFuture<Session>();
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equals("ws") && !scheme.equals("wss")) {
                throw new DeploymentException("Incorrect scheme in WebSocket endpoint URI=" + url);
            }
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Incorrect WebSocket endpoint URI=" + url, e);
        }
        final int handshakeTimeout = this.getHandshakeTimeout();
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                TyrusClientEngine clientEngine;
                ClientManagerHandshakeListener listener;
                ClientEndpointConfig config;
                ErrorCollector collector = new ErrorCollector();
                final CountDownLatch responseLatch = new CountDownLatch(1);
                try {
                    Endpoint endpoint;
                    if (o instanceof Endpoint) {
                        endpoint = (Endpoint)o;
                        config = configuration == null ? ClientEndpointConfig.Builder.create().build() : configuration;
                    } else if (o instanceof Class) {
                        if (Endpoint.class.isAssignableFrom((Class)o)) {
                            endpoint = (Endpoint)ReflectionHelper.getInstance((Class)o, collector);
                            config = configuration == null ? ClientEndpointConfig.Builder.create().build() : configuration;
                        } else if (((Class)o).getAnnotation(ClientEndpoint.class) != null) {
                            endpoint = AnnotatedEndpoint.fromClass((Class)o, ClientManager.this.componentProvider, false, collector);
                            config = (ClientEndpointConfig)((AnnotatedEndpoint)endpoint).getEndpointConfig();
                        } else {
                            collector.addException(new DeploymentException(String.format("Class %s in not Endpoint descendant and does not have @ClientEndpoint", ((Class)o).getName())));
                            endpoint = null;
                            config = null;
                        }
                    } else {
                        endpoint = AnnotatedEndpoint.fromInstance(o, ClientManager.this.componentProvider, false, collector);
                        config = (ClientEndpointConfig)((AnnotatedEndpoint)endpoint).getEndpointConfig();
                    }
                    TyrusEndpointWrapper clientEndpoint = new TyrusEndpointWrapper(endpoint, (EndpointConfig)config, ClientManager.this.componentProvider, ClientManager.this.webSocketContainer == null ? ClientManager.this : ClientManager.this.webSocketContainer, url, null);
                    if (!collector.isEmpty()) {
                        future.setFailure(collector.composeComprehensiveException());
                        return;
                    }
                    listener = new ClientManagerHandshakeListener(){
                        private volatile Session session;
                        private volatile Throwable throwable;

                        @Override
                        public void onSessionCreated(Session session) {
                            this.session = session;
                            responseLatch.countDown();
                        }

                        @Override
                        public void onError(Throwable exception) {
                            this.throwable = exception;
                            responseLatch.countDown();
                        }

                        @Override
                        public Session getSession() {
                            return this.session;
                        }

                        @Override
                        public Throwable getThrowable() {
                            return this.throwable;
                        }
                    };
                    clientEngine = new TyrusClientEngine(clientEndpoint, listener, ClientManager.this.properties);
                    ClientManager.this.container.openClientSocket(url, config, ClientManager.this.properties, clientEngine);
                }
                catch (IOException e) {
                    future.setFailure(e);
                    return;
                }
                catch (DeploymentException e) {
                    e.printStackTrace();
                    future.setFailure(e);
                    return;
                }
                if (!collector.isEmpty()) {
                    future.setFailure(collector.composeComprehensiveException());
                    return;
                }
                try {
                    boolean countedDown = responseLatch.await(handshakeTimeout, TimeUnit.MILLISECONDS);
                    if (countedDown) {
                        assert (config != null);
                        Throwable exception = listener.getThrowable();
                        if (exception != null) {
                            future.setFailure(new DeploymentException("Handshake error.", exception));
                            return;
                        }
                        Session session = listener.getSession();
                        if (session.isOpen()) {
                            session.setMaxBinaryMessageBufferSize(ClientManager.this.maxBinaryMessageBufferSize);
                            session.setMaxTextMessageBufferSize(ClientManager.this.maxTextMessageBufferSize);
                            session.setMaxIdleTimeout(ClientManager.this.defaultMaxSessionIdleTimeout);
                        }
                        future.setResult(session);
                        return;
                    }
                    ClientEngine.TimeoutHandler timeoutHandler = clientEngine.getTimeoutHandler();
                    if (timeoutHandler != null) {
                        timeoutHandler.handleTimeout();
                    }
                }
                catch (Exception e) {
                    future.setFailure(new DeploymentException("Handshake response not received.", e));
                }
                future.setFailure(new DeploymentException("Handshake response not received."));
            }
        });
        return future;
    }

    private int getHandshakeTimeout() {
        Object o = this.properties.get(HANDSHAKE_TIMEOUT);
        if (o != null && o instanceof Integer) {
            return (Integer)o;
        }
        return 30000;
    }

    @Override
    public int getDefaultMaxBinaryMessageBufferSize() {
        if (this.webSocketContainer == null) {
            return this.maxBinaryMessageBufferSize;
        }
        return this.webSocketContainer.getDefaultMaxBinaryMessageBufferSize();
    }

    @Override
    public void setDefaultMaxBinaryMessageBufferSize(int i) {
        if (this.webSocketContainer == null) {
            this.maxBinaryMessageBufferSize = i;
        } else {
            this.webSocketContainer.setDefaultMaxBinaryMessageBufferSize(i);
        }
    }

    @Override
    public int getDefaultMaxTextMessageBufferSize() {
        if (this.webSocketContainer == null) {
            return this.maxTextMessageBufferSize;
        }
        return this.webSocketContainer.getDefaultMaxTextMessageBufferSize();
    }

    @Override
    public void setDefaultMaxTextMessageBufferSize(int i) {
        if (this.webSocketContainer == null) {
            this.maxTextMessageBufferSize = i;
        } else {
            this.webSocketContainer.setDefaultMaxTextMessageBufferSize(i);
        }
    }

    @Override
    public Set<Extension> getInstalledExtensions() {
        if (this.webSocketContainer == null) {
            return Collections.emptySet();
        }
        return this.webSocketContainer.getInstalledExtensions();
    }

    @Override
    public long getDefaultAsyncSendTimeout() {
        if (this.webSocketContainer == null) {
            return this.defaultAsyncSendTimeout;
        }
        return this.webSocketContainer.getDefaultAsyncSendTimeout();
    }

    @Override
    public void setAsyncSendTimeout(long timeoutmillis) {
        if (this.webSocketContainer == null) {
            this.defaultAsyncSendTimeout = timeoutmillis;
        } else {
            this.webSocketContainer.setAsyncSendTimeout(timeoutmillis);
        }
    }

    @Override
    public long getDefaultMaxSessionIdleTimeout() {
        if (this.webSocketContainer == null) {
            return this.defaultMaxSessionIdleTimeout;
        }
        return this.webSocketContainer.getDefaultMaxSessionIdleTimeout();
    }

    @Override
    public void setDefaultMaxSessionIdleTimeout(long defaultMaxSessionIdleTimeout) {
        if (this.webSocketContainer == null) {
            this.defaultMaxSessionIdleTimeout = defaultMaxSessionIdleTimeout;
        } else {
            this.webSocketContainer.setDefaultMaxSessionIdleTimeout(defaultMaxSessionIdleTimeout);
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    private static class SameThreadExecutorService
    extends AbstractExecutorService {
        private SameThreadExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    private static interface ClientManagerHandshakeListener
    extends TyrusClientEngine.ClientHandshakeListener {
        public Session getSession();

        public Throwable getThrowable();
    }
}

