/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.core.websocket.ContainerProvider;

public class TyrusContainerProvider<T>
extends ContainerProvider {
    private static final TyrusContainerProvider<WebSocketContainer> CONTAINER = new TyrusContainerProvider();
    private final Map<ClassLoader, T> clToContainerMap = new ConcurrentHashMap<ClassLoader, T>();

    public static TyrusContainerProvider<WebSocketContainer> getContainerProvider() {
        return CONTAINER;
    }

    public T getContainer() {
        T container;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        do {
            container = this.clToContainerMap.get(cl);
        } while ((cl = cl.getParent()) != null && container == null);
        return container;
    }

    public void setContainer(T container) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.clToContainerMap.put(cl, container);
    }

    @Override
    protected <T> T getContainer(Class<T> containerClass) {
        try {
            Class<?> realProviderClass = Class.forName(TyrusContainerProvider.class.getName(), true, Thread.currentThread().getContextClassLoader());
            Method getContainerType = realProviderClass.getMethod("getContainerProvider", new Class[0]);
            Object provider = getContainerType.invoke(null, new Object[0]);
            Method getContainer = realProviderClass.getMethod("getContainer", new Class[0]);
            return (T)getContainer.invoke(provider, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get container: " + containerClass.getName());
        }
    }
}

