/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.websocket.server.HandshakeRequest;
import org.glassfish.tyrus.spi.SPIHandshakeRequest;
import org.glassfish.tyrus.websockets.Connection;
import org.glassfish.tyrus.websockets.WebSocketRequest;

public final class RequestContext
implements HandshakeRequest,
SPIHandshakeRequest,
WebSocketRequest {
    private final URI requestURI;
    private final String queryString;
    private final Connection connection;
    private final Object httpSession;
    private final boolean secure;
    private final Principal userPrincipal;
    private final Builder.IsUserInRoleDelegate isUserInRoleDelegate;
    private String requestPath;
    private Map<String, List<String>> headers = new TreeMap<String, List<String>>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.toLowerCase().compareTo(o2.toLowerCase());
        }
    });
    private Map<String, List<String>> parameterMap;

    private RequestContext(URI requestURI, String requestPath, String queryString, Connection connection, Object httpSession, boolean secure, Principal userPrincipal, Builder.IsUserInRoleDelegate IsUserInRoleDelegate2, Map<String, List<String>> parameterMap) {
        this.requestURI = requestURI;
        this.requestPath = requestPath;
        this.queryString = queryString;
        this.connection = connection;
        this.httpSession = httpSession;
        this.secure = secure;
        this.userPrincipal = userPrincipal;
        this.isUserInRoleDelegate = IsUserInRoleDelegate2;
        this.parameterMap = parameterMap;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        List<String> stringList = this.headers.get(name);
        if (stringList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : stringList) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public String getFirstHeaderValue(String name) {
        List<String> stringList = this.headers.get(name);
        return stringList == null ? null : stringList.get(0);
    }

    public void lock() {
        this.headers = Collections.unmodifiableMap(this.headers);
        this.parameterMap = Collections.unmodifiableMap(this.parameterMap);
    }

    @Override
    public void putSingleHeader(String headerName, String headerValue) {
        this.headers.put(headerName, Arrays.asList(headerValue));
    }

    @Override
    public String getRequestPath() {
        return this.requestPath;
    }

    @Override
    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public boolean isUserInRole(String role) {
        if (this.isUserInRoleDelegate != null) {
            return this.isUserInRoleDelegate.isUserInRole(role);
        }
        return false;
    }

    @Override
    public Object getHttpSession() {
        return this.httpSession;
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return this.parameterMap;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getRequestUri() {
        return this.requestURI.toString();
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public static final class Builder {
        private URI requestURI;
        private String requestPath;
        private String queryString;
        private Connection connection;
        private Object httpSession;
        private boolean secure;
        private Principal userPrincipal;
        private IsUserInRoleDelegate isUserInRoleDelegate;
        private Map<String, List<String>> parameterMap;

        public static Builder create() {
            return new Builder();
        }

        public Builder requestURI(URI requestURI) {
            this.requestURI = requestURI;
            return this;
        }

        public Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public Builder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        public Builder requestPath(String requestPath) {
            this.requestPath = requestPath;
            return this;
        }

        public Builder httpSession(Object httpSession) {
            this.httpSession = httpSession;
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder userPrincipal(Principal principal) {
            this.userPrincipal = principal;
            return this;
        }

        public Builder isUserInRoleDelegate(IsUserInRoleDelegate isUserInRoleDelegate) {
            this.isUserInRoleDelegate = isUserInRoleDelegate;
            return this;
        }

        public Builder parameterMap(Map<String, String[]> parameterMap) {
            if (parameterMap != null) {
                this.parameterMap = new HashMap<String, List<String>>();
                for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
                    this.parameterMap.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
                }
            } else {
                this.parameterMap = null;
            }
            return this;
        }

        public RequestContext build() {
            return new RequestContext(this.requestURI, this.requestPath, this.queryString, this.connection, this.httpSession, this.secure, this.userPrincipal, this.isUserInRoleDelegate, this.parameterMap != null ? this.parameterMap : new HashMap());
        }

        public static interface IsUserInRoleDelegate {
            public boolean isUserInRole(String var1);
        }
    }
}

