/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.BaseContainer;
import org.glassfish.tyrus.core.CoderWrapper;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.InputStreamBuffer;
import org.glassfish.tyrus.core.InputStreamDecoder;
import org.glassfish.tyrus.core.MessageTooBigException;
import org.glassfish.tyrus.core.NoOpByteArrayCoder;
import org.glassfish.tyrus.core.NoOpByteBufferCoder;
import org.glassfish.tyrus.core.NoOpTextCoder;
import org.glassfish.tyrus.core.PrimitiveDecoders;
import org.glassfish.tyrus.core.ReaderBuffer;
import org.glassfish.tyrus.core.ReaderDecoder;
import org.glassfish.tyrus.core.ReflectionHelper;
import org.glassfish.tyrus.core.SessionImpl;
import org.glassfish.tyrus.core.ToStringEncoder;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIHandshakeRequest;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;
import org.glassfish.tyrus.websockets.HandshakeException;

public class EndpointWrapper
extends SPIEndpoint {
    private static final Logger LOGGER = Logger.getLogger(EndpointWrapper.class.getName());
    final BaseContainer container;
    private final String contextPath;
    private final List<CoderWrapper<Decoder>> decoders = new ArrayList<CoderWrapper<Decoder>>();
    private final List<CoderWrapper<Encoder>> encoders = new ArrayList<CoderWrapper<Encoder>>();
    private final EndpointConfig configuration;
    private final Class<?> endpointClass;
    private final Endpoint endpoint;
    private final Map<SPIRemoteEndpoint, SessionImpl> remoteEndpointToSession = new ConcurrentHashMap<SPIRemoteEndpoint, SessionImpl>();
    private final ErrorCollector collector;
    private final ComponentProviderService componentProvider;
    private final ServerEndpointConfig.Configurator configurator;
    private String uri;
    private Principal principal;
    private final Map<String, String> templateValues = new HashMap<String, String>();
    private boolean isSecure;
    private String queryString;
    private Map<String, List<String>> requestParameterMap;

    public EndpointWrapper(Class<?> endpointClass, EndpointConfig configuration, ComponentProviderService componentProvider, BaseContainer container, String contextPath, ErrorCollector collector, ServerEndpointConfig.Configurator configurator) {
        this(null, endpointClass, configuration, componentProvider, container, contextPath, collector, configurator);
    }

    public EndpointWrapper(Endpoint endpoint, EndpointConfig configuration, ComponentProviderService componentProvider, BaseContainer container, String contextPath, ErrorCollector collector, ServerEndpointConfig.Configurator configurator) {
        this(endpoint, null, configuration, componentProvider, container, contextPath, collector, configurator);
    }

    private EndpointWrapper(Endpoint endpoint, Class<?> endpointClass, EndpointConfig configuration, ComponentProviderService componentProvider, BaseContainer container, String contextPath, ErrorCollector collector, final ServerEndpointConfig.Configurator configurator) {
        Class<?> type;
        this.endpointClass = endpointClass;
        this.endpoint = endpoint;
        this.container = container;
        this.contextPath = contextPath;
        this.uri = contextPath;
        this.collector = collector;
        this.configurator = configurator;
        this.componentProvider = configurator == null ? componentProvider : new ComponentProviderService(componentProvider){

            @Override
            public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
                return configurator.getEndpointInstance(endpointClass);
            }
        };
        this.configuration = configuration == null ? new EndpointConfig(){
            private final Map<String, Object> properties = new HashMap<String, Object>();

            @Override
            public List<Class<? extends Encoder>> getEncoders() {
                return Collections.emptyList();
            }

            @Override
            public List<Class<? extends Decoder>> getDecoders() {
                return Collections.emptyList();
            }

            @Override
            public Map<String, Object> getUserProperties() {
                return this.properties;
            }
        } : configuration;
        for (Class<? extends Decoder> clazz : this.configuration.getDecoders()) {
            type = this.getDecoderClassType(clazz);
            this.decoders.add(new CoderWrapper<Class<? extends Decoder>>(clazz, type));
        }
        if (endpoint == null || !(endpoint instanceof AnnotatedEndpoint)) {
            for (Class<? extends Decoder> clazz : EndpointWrapper.getDefaultDecoders()) {
                type = this.getDecoderClassType(clazz);
                this.decoders.add(new CoderWrapper<Class<? extends Decoder>>(clazz, type));
            }
        }
        for (Class<Object> clazz : this.configuration.getEncoders()) {
            type = this.getEncoderClassType(clazz);
            this.encoders.add(new CoderWrapper<Class<Object>>(clazz, type));
        }
        this.encoders.add(new CoderWrapper<Class<NoOpTextCoder>>(NoOpTextCoder.class, (Class<?>)String.class));
        this.encoders.add(new CoderWrapper<Class<NoOpByteBufferCoder>>(NoOpByteBufferCoder.class, (Class<?>)ByteBuffer.class));
        this.encoders.add(new CoderWrapper<Class<NoOpByteArrayCoder>>(NoOpByteArrayCoder.class, (Class<?>)byte[].class));
        this.encoders.add(new CoderWrapper<Class<ToStringEncoder>>(ToStringEncoder.class, (Class<?>)Object.class));
    }

    @Override
    public boolean checkHandshake(SPIHandshakeRequest hr) {
        if (!(this.configuration instanceof ServerEndpointConfig)) {
            return false;
        }
        this.uri = hr.getRequestUri();
        this.queryString = hr.getQueryString();
        this.isSecure = hr.isSecure();
        this.principal = hr.getUserPrincipal();
        this.requestParameterMap = hr.getParameterMap();
        this.templateValues.clear();
        for (Map.Entry<String, List<String>> entry : hr.getParameterMap().entrySet()) {
            this.templateValues.put(entry.getKey(), entry.getValue().get(0));
        }
        if (this.configurator.checkOrigin(hr.getHeader("Origin"))) {
            return true;
        }
        throw new HandshakeException(403, "Origin not verified.");
    }

    static List<Class<? extends Decoder>> getDefaultDecoders() {
        ArrayList<Class<? extends Decoder>> classList = new ArrayList<Class<? extends Decoder>>();
        classList.addAll(PrimitiveDecoders.ALL);
        classList.add(NoOpTextCoder.class);
        classList.add(NoOpByteBufferCoder.class);
        classList.add(NoOpByteArrayCoder.class);
        classList.add(ReaderDecoder.class);
        classList.add(InputStreamDecoder.class);
        return classList;
    }

    @Override
    public String getEndpointPath() {
        if (this.configuration instanceof ServerEndpointConfig) {
            String relativePath = ((ServerEndpointConfig)this.configuration).getPath();
            return (this.contextPath.endsWith("/") ? this.contextPath.substring(0, this.contextPath.length() - 1) : this.contextPath) + "/" + (relativePath.startsWith("/") ? relativePath.substring(1) : relativePath);
        }
        return null;
    }

    @Override
    public WebSocketContainer getWebSocketContainer() {
        return this.container;
    }

    private <T> T getCoderInstance(Session session, CoderWrapper<T> wrapper) {
        T coder = wrapper.getCoder();
        if (coder == null) {
            return this.componentProvider.getCoderInstance(wrapper.getCoderClass(), session, this.getEndpointConfig(), this.collector);
        }
        return coder;
    }

    Object decodeCompleteMessage(Session session, Object message, Class<?> type, CoderWrapper<Decoder> selectedDecoder) {
        try {
            Class<Decoder> decoderClass = selectedDecoder.getCoderClass();
            if (Decoder.Text.class.isAssignableFrom(decoderClass)) {
                if (type != null && type.isAssignableFrom(selectedDecoder.getType())) {
                    Decoder.Text decoder = (Decoder.Text)this.getCoderInstance(session, selectedDecoder);
                    return decoder.decode((String)message);
                }
            } else if (Decoder.Binary.class.isAssignableFrom(decoderClass)) {
                if (type != null && type.isAssignableFrom(selectedDecoder.getType())) {
                    Decoder.Binary decoder = (Decoder.Binary)this.getCoderInstance(session, selectedDecoder);
                    return decoder.decode((ByteBuffer)message);
                }
            } else if (Decoder.TextStream.class.isAssignableFrom(decoderClass)) {
                if (type != null && type.isAssignableFrom(selectedDecoder.getType())) {
                    return ((Decoder.TextStream)this.getCoderInstance(session, selectedDecoder)).decode(new StringReader((String)message));
                }
            } else if (Decoder.BinaryStream.class.isAssignableFrom(decoderClass) && type != null && type.isAssignableFrom(selectedDecoder.getType())) {
                byte[] array = ((ByteBuffer)message).array();
                return ((Decoder.BinaryStream)this.getCoderInstance(session, selectedDecoder)).decode(new ByteArrayInputStream(array));
            }
        }
        catch (Exception e) {
            this.collector.addException(e);
        }
        return null;
    }

    private ArrayList<CoderWrapper<Decoder>> findApplicableDecoders(Session session, Object message, boolean isString) {
        ArrayList<CoderWrapper<Decoder>> result = new ArrayList<CoderWrapper<Decoder>>();
        for (CoderWrapper<Decoder> dec : this.decoders) {
            Decoder decoder;
            if (isString && Decoder.Text.class.isAssignableFrom(dec.getCoderClass())) {
                decoder = (Decoder.Text)this.getCoderInstance(session, dec);
                if (!decoder.willDecode((String)message)) continue;
                result.add(dec);
                continue;
            }
            if (!isString && Decoder.Binary.class.isAssignableFrom(dec.getCoderClass())) {
                decoder = (Decoder.Binary)this.getCoderInstance(session, dec);
                if (!decoder.willDecode((ByteBuffer)message)) continue;
                result.add(dec);
                continue;
            }
            if (isString && Decoder.TextStream.class.isAssignableFrom(dec.getCoderClass())) {
                result.add(dec);
                continue;
            }
            if (isString || !Decoder.BinaryStream.class.isAssignableFrom(dec.getCoderClass())) continue;
            result.add(dec);
        }
        return result;
    }

    Object doEncode(Session session, Object message) throws EncodeException {
        for (CoderWrapper<Encoder> enc : this.encoders) {
            try {
                Class<Encoder> encoderClass = enc.getCoderClass();
                if (Encoder.Binary.class.isAssignableFrom(encoderClass)) {
                    if (!enc.getType().isAssignableFrom(message.getClass())) continue;
                    Encoder.Binary encoder = (Encoder.Binary)this.getCoderInstance(session, enc);
                    return encoder.encode(message);
                }
                if (Encoder.Text.class.isAssignableFrom(encoderClass)) {
                    if (!enc.getType().isAssignableFrom(message.getClass())) continue;
                    Encoder.Text encoder = (Encoder.Text)this.getCoderInstance(session, enc);
                    return encoder.encode(message);
                }
                if (Encoder.BinaryStream.class.isAssignableFrom(encoderClass)) {
                    if (!enc.getType().isAssignableFrom(message.getClass())) continue;
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    Encoder.BinaryStream encoder = (Encoder.BinaryStream)this.getCoderInstance(session, enc);
                    encoder.encode(message, stream);
                    return stream;
                }
                if (!Encoder.TextStream.class.isAssignableFrom(encoderClass) || !enc.getType().isAssignableFrom(message.getClass())) continue;
                StringWriter writer = new StringWriter();
                Encoder.TextStream encoder = (Encoder.TextStream)this.getCoderInstance(session, enc);
                encoder.encode(message, writer);
                return writer;
            }
            catch (EncodeException ee) {
                throw ee;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new EncodeException(message, "Unable to encode ");
    }

    @Override
    public List<Extension> getNegotiatedExtensions(List<Extension> clientExtensions) {
        if (this.configuration instanceof ServerEndpointConfig) {
            return this.configurator.getNegotiatedExtensions(((ServerEndpointConfig)this.configuration).getExtensions(), clientExtensions);
        }
        return Collections.emptyList();
    }

    @Override
    public String getNegotiatedProtocol(List<String> clientProtocols) {
        if (this.configuration instanceof ServerEndpointConfig) {
            return this.configurator.getNegotiatedSubprotocol(((ServerEndpointConfig)this.configuration).getSubprotocols(), clientProtocols);
        }
        return null;
    }

    @Override
    public Set<Session> getOpenSessions() {
        HashSet<Session> result = new HashSet<Session>();
        for (Session session : this.remoteEndpointToSession.values()) {
            if (!session.isOpen()) continue;
            result.add(session);
        }
        return Collections.unmodifiableSet(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session createSessionForRemoteEndpoint(SPIRemoteEndpoint re, String subprotocol, List<Extension> extensions) {
        Map<SPIRemoteEndpoint, SessionImpl> map = this.remoteEndpointToSession;
        synchronized (map) {
            SessionImpl session = new SessionImpl(this.container, re, this, subprotocol, extensions, this.isSecure, EndpointWrapper.getURI(this.uri, this.queryString), this.queryString, this.templateValues, this.principal, this.requestParameterMap);
            this.remoteEndpointToSession.put(re, session);
            return session;
        }
    }

    @Override
    public void remove() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionImpl getSession(SPIRemoteEndpoint gs) {
        Map<SPIRemoteEndpoint, SessionImpl> map = this.remoteEndpointToSession;
        synchronized (map) {
            return this.remoteEndpointToSession.get(gs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnect(SPIRemoteEndpoint gs, String subprotocol, List<Extension> extensions) {
        Map<SPIRemoteEndpoint, SessionImpl> map = this.remoteEndpointToSession;
        synchronized (map) {
            SessionImpl session = this.remoteEndpointToSession.get(gs);
            if (session == null) {
                session = new SessionImpl(this.container, gs, this, subprotocol, extensions, this.isSecure, EndpointWrapper.getURI(this.uri, this.queryString), this.queryString, this.templateValues, this.principal, this.requestParameterMap);
                this.remoteEndpointToSession.put(gs, session);
            }
            session.setNegotiatedExtensions(extensions);
            session.setNegotiatedSubprotocol(subprotocol);
            Endpoint toCall = this.endpoint != null ? this.endpoint : (Endpoint)this.componentProvider.getInstance(this.endpointClass, session, this.collector);
            try {
                toCall.onOpen(session, this.configuration);
            }
            catch (Throwable t) {
                if (toCall != null) {
                    toCall.onError(session, t);
                }
                this.collector.addException(new DeploymentException(t.getMessage(), t));
            }
        }
    }

    @Override
    public void onMessage(SPIRemoteEndpoint gs, ByteBuffer messageBytes) {
        block4: {
            SessionImpl session = this.getSession(gs);
            try {
                session.restartIdleTimeoutExecutor();
                session.setState(SessionImpl.State.RUNNING);
                if (session.isWholeBinaryHandlerPresent()) {
                    session.notifyMessageHandlers((Object)messageBytes, this.findApplicableDecoders(session, messageBytes, false));
                    break block4;
                }
                if (session.isPartialBinaryHandlerPresent()) {
                    session.notifyMessageHandlers((Object)messageBytes, true);
                    break block4;
                }
                throw new IllegalStateException(String.format("Binary messageHandler not found. Session: '%s'.", session));
            }
            catch (Throwable t) {
                Endpoint toCall;
                if (this.processThrowable(t, session)) break block4;
                Endpoint endpoint = toCall = this.endpoint != null ? this.endpoint : (Endpoint)this.componentProvider.getInstance(this.endpointClass, session, this.collector);
                if (toCall == null) break block4;
                toCall.onError(session, t);
            }
        }
    }

    @Override
    public void onMessage(SPIRemoteEndpoint gs, String messageString) {
        block5: {
            SessionImpl session = this.getSession(gs);
            if (session == null) {
                LOGGER.log(Level.FINE, "Message received on already closed connection.");
                return;
            }
            try {
                session.restartIdleTimeoutExecutor();
                session.setState(SessionImpl.State.RUNNING);
                if (session.isWholeTextHandlerPresent()) {
                    session.notifyMessageHandlers((Object)messageString, this.findApplicableDecoders(session, messageString, true));
                    break block5;
                }
                if (session.isPartialTextHandlerPresent()) {
                    session.notifyMessageHandlers((Object)messageString, true);
                    break block5;
                }
                throw new IllegalStateException(String.format("Text messageHandler not found. Session: '%s'.", session));
            }
            catch (Throwable t) {
                Endpoint toCall;
                if (this.processThrowable(t, session)) break block5;
                Endpoint endpoint = toCall = this.endpoint != null ? this.endpoint : (Endpoint)this.componentProvider.getInstance(this.endpointClass, session, this.collector);
                if (toCall == null) break block5;
                toCall.onError(session, t);
            }
        }
    }

    @Override
    public void onPartialMessage(SPIRemoteEndpoint gs, String partialString, boolean last) {
        block15: {
            SessionImpl session = this.getSession(gs);
            try {
                session.restartIdleTimeoutExecutor();
                if (session.isPartialTextHandlerPresent()) {
                    session.notifyMessageHandlers((Object)partialString, last);
                    session.setState(SessionImpl.State.RUNNING);
                    break block15;
                }
                if (session.isReaderHandlerPresent()) {
                    ReaderBuffer buffer = session.getReaderBuffer();
                    switch (session.getState()) {
                        case RUNNING: {
                            if (buffer == null) {
                                buffer = new ReaderBuffer(this.container.getExecutorService());
                                session.setReaderBuffer(buffer);
                            }
                            buffer.resetBuffer(session.getMaxTextMessageBufferSize());
                            buffer.setMessageHandler(session.getMessageHandler(Reader.class));
                            buffer.appendMessagePart(partialString, last);
                            session.setState(SessionImpl.State.RECEIVING_TEXT);
                            break;
                        }
                        case RECEIVING_TEXT: {
                            buffer.appendMessagePart(partialString, last);
                            if (last) {
                                session.setState(SessionImpl.State.RUNNING);
                                break;
                            }
                            break block15;
                        }
                        default: {
                            session.setState(SessionImpl.State.RUNNING);
                            throw new IllegalStateException(String.format("Partial text message received out of order. Session: '%s'.", session));
                        }
                    }
                    break block15;
                }
                if (!session.isWholeTextHandlerPresent()) break block15;
                switch (session.getState()) {
                    case RUNNING: {
                        session.getTextBuffer().resetBuffer(session.getMaxTextMessageBufferSize());
                        session.getTextBuffer().appendMessagePart(partialString);
                        session.setState(SessionImpl.State.RECEIVING_TEXT);
                        break;
                    }
                    case RECEIVING_TEXT: {
                        session.getTextBuffer().appendMessagePart(partialString);
                        if (last) {
                            String message = session.getTextBuffer().getBufferedContent();
                            session.notifyMessageHandlers((Object)message, this.findApplicableDecoders(session, message, true));
                            session.setState(SessionImpl.State.RUNNING);
                        }
                        break;
                    }
                    default: {
                        session.setState(SessionImpl.State.RUNNING);
                        throw new IllegalStateException(String.format("Text message received out of order. Session: '%s'.", session));
                    }
                }
            }
            catch (Throwable t) {
                Endpoint toCall;
                if (this.processThrowable(t, session)) break block15;
                Endpoint endpoint = toCall = this.endpoint != null ? this.endpoint : (Endpoint)this.componentProvider.getInstance(this.endpointClass, session, this.collector);
                if (toCall == null) break block15;
                toCall.onError(session, t);
            }
        }
    }

    @Override
    public void onPartialMessage(SPIRemoteEndpoint gs, ByteBuffer partialBytes, boolean last) {
        block15: {
            SessionImpl session = this.getSession(gs);
            try {
                session.restartIdleTimeoutExecutor();
                if (session.isPartialBinaryHandlerPresent()) {
                    session.notifyMessageHandlers((Object)partialBytes, last);
                    session.setState(SessionImpl.State.RUNNING);
                    break block15;
                }
                if (session.isInputStreamHandlerPresent()) {
                    InputStreamBuffer buffer = session.getInputStreamBuffer();
                    switch (session.getState()) {
                        case RUNNING: {
                            if (buffer == null) {
                                buffer = new InputStreamBuffer(this.container.getExecutorService());
                                session.setInputStreamBuffer(buffer);
                            }
                            buffer.resetBuffer(session.getMaxBinaryMessageBufferSize());
                            buffer.setMessageHandler(session.getMessageHandler(InputStream.class));
                            buffer.appendMessagePart(partialBytes, last);
                            session.setState(SessionImpl.State.RECEIVING_BINARY);
                            break;
                        }
                        case RECEIVING_BINARY: {
                            buffer.appendMessagePart(partialBytes, last);
                            if (last) {
                                session.setState(SessionImpl.State.RUNNING);
                                break;
                            }
                            break block15;
                        }
                        default: {
                            session.setState(SessionImpl.State.RUNNING);
                            throw new IllegalStateException(String.format("Partial binary message received out of order. Session: '%s'.", session));
                        }
                    }
                    break block15;
                }
                if (!session.isWholeBinaryHandlerPresent()) break block15;
                switch (session.getState()) {
                    case RUNNING: {
                        session.getBinaryBuffer().resetBuffer(session.getMaxBinaryMessageBufferSize());
                        session.getBinaryBuffer().appendMessagePart(partialBytes);
                        session.setState(SessionImpl.State.RECEIVING_BINARY);
                        break;
                    }
                    case RECEIVING_BINARY: {
                        session.getBinaryBuffer().appendMessagePart(partialBytes);
                        if (last) {
                            ByteBuffer bb = session.getBinaryBuffer().getBufferedContent();
                            session.notifyMessageHandlers((Object)bb, this.findApplicableDecoders(session, bb, false));
                            session.setState(SessionImpl.State.RUNNING);
                        }
                        break;
                    }
                    default: {
                        session.setState(SessionImpl.State.RUNNING);
                        throw new IllegalStateException(String.format("Binary message received out of order. Session: '%s'.", session));
                    }
                }
            }
            catch (Throwable t) {
                Endpoint toCall;
                if (this.processThrowable(t, session)) break block15;
                Endpoint endpoint = toCall = this.endpoint != null ? this.endpoint : (Endpoint)this.componentProvider.getInstance(this.endpointClass, session, this.collector);
                if (toCall == null) break block15;
                toCall.onError(session, t);
            }
        }
    }

    private boolean processThrowable(Throwable throwable, Session session) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("Exception thrown while processing message. Session: '%session'.", session), throwable);
        }
        if (throwable instanceof MessageTooBigException) {
            try {
                session.close(new CloseReason(CloseReason.CloseCodes.TOO_BIG, "Message too big."));
                return false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void onPong(SPIRemoteEndpoint gs, final ByteBuffer bytes) {
        SessionImpl session = this.getSession(gs);
        if (session.isPongHandlerPreset()) {
            session.notifyPongHandler(new PongMessage(){

                @Override
                public ByteBuffer getApplicationData() {
                    return bytes;
                }
            });
        } else {
            LOGGER.log(Level.FINE, String.format("Unhandled pong message. Session: '%s'", session));
        }
    }

    @Override
    public void onPing(SPIRemoteEndpoint gs, ByteBuffer bytes) {
        SessionImpl session = this.getSession(gs);
        try {
            session.getBasicRemote().sendPong(bytes);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClose(SPIRemoteEndpoint gs, CloseReason closeReason) {
        SessionImpl session = this.getSession(gs);
        if (session == null) {
            return;
        }
        session.setState(SessionImpl.State.CLOSING);
        Endpoint toCall = this.endpoint != null ? this.endpoint : (Endpoint)this.componentProvider.getInstance(this.endpointClass, session, this.collector);
        try {
            toCall.onClose(session, closeReason);
            session.setState(SessionImpl.State.CLOSED);
        }
        catch (Throwable t) {
            if (toCall != null) {
                toCall.onError(session, t);
            }
            this.collector.addException(new DeploymentException(t.getMessage(), t));
        }
        Map<SPIRemoteEndpoint, SessionImpl> map = this.remoteEndpointToSession;
        synchronized (map) {
            this.remoteEndpointToSession.remove(gs);
            this.componentProvider.removeSession(session);
        }
    }

    @Override
    public EndpointConfig getEndpointConfig() {
        return this.configuration;
    }

    boolean isOpen(SessionImpl session) {
        return this.remoteEndpointToSession.values().contains(session);
    }

    List<Decoder> getDecoders() {
        return this.decoders;
    }

    private Class<?> getEncoderClassType(Class<?> encoderClass) {
        if (Encoder.Binary.class.isAssignableFrom(encoderClass)) {
            return ReflectionHelper.getClassType(encoderClass, Encoder.Binary.class);
        }
        if (Encoder.Text.class.isAssignableFrom(encoderClass)) {
            return ReflectionHelper.getClassType(encoderClass, Encoder.Text.class);
        }
        if (Encoder.BinaryStream.class.isAssignableFrom(encoderClass)) {
            return ReflectionHelper.getClassType(encoderClass, Encoder.BinaryStream.class);
        }
        if (Encoder.TextStream.class.isAssignableFrom(encoderClass)) {
            return ReflectionHelper.getClassType(encoderClass, Encoder.TextStream.class);
        }
        return null;
    }

    private Class<?> getDecoderClassType(Class<?> decoderClass) {
        if (Decoder.Binary.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.Binary.class);
        }
        if (Decoder.Text.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.Text.class);
        }
        if (Decoder.BinaryStream.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.BinaryStream.class);
        }
        if (Decoder.TextStream.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.TextStream.class);
        }
        return null;
    }

    private static URI getURI(String uri, String queryString) {
        if (queryString != null && !queryString.isEmpty()) {
            return URI.create(String.format("%s?%s", uri, queryString));
        }
        return URI.create(uri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EndpointWrapper");
        sb.append("{endpointClass=").append(this.endpointClass);
        sb.append(", endpoint=").append(this.endpoint);
        sb.append(", uri='").append(this.uri).append('\'');
        sb.append(", contextPath='").append(this.contextPath).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

