/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.MimeHeadersPacket;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.MimeHeaders;

public class HttpTrailer
extends HttpContent
implements MimeHeadersPacket {
    private static final ThreadCache.CachedTypeIndex<HttpTrailer> CACHE_IDX = ThreadCache.obtainIndex(HttpTrailer.class, 16);
    private static final ThreadCache.CachedTypeIndex<Builder> BUILDER_CACHE_IDX = ThreadCache.obtainIndex(Builder.class, 16);
    private MimeHeaders headers = new MimeHeaders();

    public static boolean isTrailer(HttpContent httpContent) {
        return HttpTrailer.class.isAssignableFrom(httpContent.getClass());
    }

    public static HttpTrailer create() {
        return HttpTrailer.create(null);
    }

    public static HttpTrailer create(HttpHeader httpHeader) {
        HttpTrailer httpTrailer = ThreadCache.takeFromCache(CACHE_IDX);
        if (httpTrailer != null) {
            httpTrailer.httpHeader = httpHeader;
            return httpTrailer;
        }
        return new HttpTrailer(httpHeader);
    }

    private static Builder createBuilder(HttpHeader httpHeader) {
        Builder builder = ThreadCache.takeFromCache(BUILDER_CACHE_IDX);
        if (builder != null) {
            builder.packet = HttpTrailer.create(httpHeader);
            return builder;
        }
        return new Builder(httpHeader);
    }

    public static Builder builder(HttpHeader httpHeader) {
        return HttpTrailer.createBuilder(httpHeader);
    }

    protected HttpTrailer(HttpHeader httpHeader) {
        super(httpHeader);
    }

    @Override
    public final boolean isLast() {
        return true;
    }

    @Override
    public MimeHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public String getHeader(Header header) {
        return this.headers.getHeader(header);
    }

    @Override
    public void setHeader(String name, String value) {
        Header h = Header.find(name);
        if (h != null) {
            this.setHeader(h, value);
        } else {
            this.headers.setValue(name).setString(value);
        }
    }

    @Override
    public void setHeader(Header header, String value) {
        this.headers.setValue(header).setString(value);
    }

    @Override
    public void addHeader(String name, String value) {
        Header h = Header.find(name);
        if (h != null) {
            this.addHeader(h, value);
        } else {
            this.headers.addValue(name).setString(value);
        }
    }

    @Override
    public void addHeader(Header header, String value) {
        this.headers.addValue(header).setString(value);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.getHeader(name) != null;
    }

    @Override
    public boolean containsHeader(Header header) {
        return this.headers.getHeader(header) != null;
    }

    protected void setHeaders(MimeHeaders mimeHeaders) {
        this.headers = mimeHeaders;
    }

    @Override
    protected void reset() {
        this.headers.recycle();
        super.reset();
    }

    @Override
    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    public static final class Builder
    extends HttpContent.Builder<Builder> {
        protected Builder(HttpHeader httpHeader) {
            this.packet = HttpTrailer.create(httpHeader);
        }

        public final Builder headers(MimeHeaders mimeHeaders) {
            ((HttpTrailer)this.packet).setHeaders(mimeHeaders);
            return this;
        }

        public final Builder header(String name, String value) {
            ((HttpTrailer)this.packet).setHeader(name, value);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final HttpTrailer build() {
            try {
                HttpTrailer httpTrailer = (HttpTrailer)this.packet;
                return httpTrailer;
            }
            finally {
                ThreadCache.putToCache(BUILDER_CACHE_IDX, this);
            }
        }
    }
}

