/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.websockets.frametypes;

import org.glassfish.tyrus.websockets.BaseFrameType;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.FrameType;
import org.glassfish.tyrus.websockets.WebSocket;
import org.glassfish.tyrus.websockets.frametypes.BinaryFrameType;
import org.glassfish.tyrus.websockets.frametypes.TextFrameType;

public class ContinuationFrameType
extends BaseFrameType {
    private boolean text;
    private FrameType wrappedType;

    public ContinuationFrameType(boolean text) {
        this.text = text;
        this.wrappedType = text ? new TextFrameType() : new BinaryFrameType();
    }

    @Override
    public void respond(WebSocket socket, DataFrame frame) {
        if (this.text) {
            socket.onFragment(frame.isLast(), frame.getTextPayload());
        } else {
            socket.onFragment(frame.isLast(), frame.getBytes());
        }
    }

    @Override
    public void setPayload(DataFrame frame, byte[] data) {
        this.wrappedType.setPayload(frame, data);
    }

    @Override
    public byte[] getBytes(DataFrame dataFrame) {
        return this.wrappedType.getBytes(dataFrame);
    }
}

