/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.reflection;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.glassfish.pfl.basic.reflection.BridgeOperations;
import sun.misc.Unsafe;

public abstract class BridgeBase
implements BridgeOperations {
    private final Unsafe unsafe = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

        @Override
        public Unsafe run() {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException exc) {
                throw new Error("Could not access Unsafe", exc);
            }
        }
    });

    protected final Unsafe getUnsafe() {
        return this.unsafe;
    }

    @Override
    public final int getInt(Object o, long offset) {
        return this.unsafe.getInt(o, offset);
    }

    @Override
    public final void putInt(Object o, long offset, int x) {
        this.unsafe.putInt(o, offset, x);
    }

    @Override
    public final Object getObject(Object o, long offset) {
        return this.unsafe.getObject(o, offset);
    }

    @Override
    public final void putObject(Object o, long offset, Object x) {
        this.unsafe.putObject(o, offset, x);
    }

    @Override
    public final boolean getBoolean(Object o, long offset) {
        return this.unsafe.getBoolean(o, offset);
    }

    @Override
    public final void putBoolean(Object o, long offset, boolean x) {
        this.unsafe.putBoolean(o, offset, x);
    }

    @Override
    public final byte getByte(Object o, long offset) {
        return this.unsafe.getByte(o, offset);
    }

    @Override
    public final void putByte(Object o, long offset, byte x) {
        this.unsafe.putByte(o, offset, x);
    }

    @Override
    public final short getShort(Object o, long offset) {
        return this.unsafe.getShort(o, offset);
    }

    @Override
    public final void putShort(Object o, long offset, short x) {
        this.unsafe.putShort(o, offset, x);
    }

    @Override
    public final char getChar(Object o, long offset) {
        return this.unsafe.getChar(o, offset);
    }

    @Override
    public final void putChar(Object o, long offset, char x) {
        this.unsafe.putChar(o, offset, x);
    }

    @Override
    public final long getLong(Object o, long offset) {
        return this.unsafe.getLong(o, offset);
    }

    @Override
    public final void putLong(Object o, long offset, long x) {
        this.unsafe.putLong(o, offset, x);
    }

    @Override
    public final float getFloat(Object o, long offset) {
        return this.unsafe.getFloat(o, offset);
    }

    @Override
    public final void putFloat(Object o, long offset, float x) {
        this.unsafe.putFloat(o, offset, x);
    }

    @Override
    public final double getDouble(Object o, long offset) {
        return this.unsafe.getDouble(o, offset);
    }

    @Override
    public final void putDouble(Object o, long offset, double x) {
        this.unsafe.putDouble(o, offset, x);
    }

    @Override
    public final long objectFieldOffset(Field f) {
        return this.unsafe.objectFieldOffset(f);
    }

    @Override
    public final long staticFieldOffset(Field f) {
        return this.unsafe.staticFieldOffset(f);
    }

    @Override
    public final void throwException(Throwable ee) {
        this.unsafe.throwException(ee);
    }

    @Override
    public final Class<?> defineClass(String className, byte[] classBytes, ClassLoader classLoader, ProtectionDomain protectionDomain) {
        return this.unsafe.defineClass(className, classBytes, 0, classBytes.length, classLoader, null);
    }
}

