/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenConfiguration;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenManager;
import com.sun.xml.ws.runtime.dev.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.impl.DerivedKeyTokenImpl;
import com.sun.xml.ws.security.secconv.impl.client.DefaultSCTokenConfiguration;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.DerivedKeyTokenHeaderBlock;
import com.sun.xml.wss.core.EncryptedKeyToken;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.ReferenceElement;
import com.sun.xml.wss.core.SecurityContextTokenImpl;
import com.sun.xml.wss.core.SecurityToken;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.X509SecurityToken;
import com.sun.xml.wss.core.reference.DirectReference;
import com.sun.xml.wss.core.reference.KeyIdentifier;
import com.sun.xml.wss.core.reference.X509IssuerSerial;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.dsig.SignatureProcessor;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.logging.LogStringsMessages;
import com.sun.xml.wss.saml.AssertionUtil;
import com.sun.xml.wss.saml.util.SAMLUtil;
import jakarta.xml.soap.SOAPElement;
import java.math.BigInteger;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.keys.content.KeyValue;
import org.apache.xml.security.keys.content.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class KeyResolver {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    private KeyResolver() {
    }

    public static Key getKey(KeyInfoHeaderBlock keyInfo, boolean sig, FilterProcessingContext context) {
        Key returnKey;
        block17: {
            try {
                SecurableSoapMessage secureMsg = context.getSecurableSoapMessage();
                if (keyInfo.containsSecurityTokenReference()) {
                    return KeyResolver.processSecurityTokenReference(keyInfo, sig, context);
                }
                if (keyInfo.containsKeyName()) {
                    EncryptionPolicy policy = (EncryptionPolicy)context.getInferredPolicy();
                    String keynameString = keyInfo.getKeyNameString(0);
                    if (policy != null) {
                        SymmetricKeyBinding keyBinding = null;
                        keyBinding = (SymmetricKeyBinding)policy.newSymmetricKeyBinding();
                        keyBinding.setKeyIdentifier(keynameString);
                    }
                    returnKey = context.getSecurityEnvironment().getSecretKey(context.getExtraneousProperties(), keynameString, false);
                    break block17;
                }
                if (keyInfo.containsKeyValue()) {
                    returnKey = KeyResolver.resolveKeyValue(secureMsg, keyInfo.getKeyValue(0), sig, context);
                    break block17;
                }
                if (keyInfo.containsX509Data()) {
                    returnKey = KeyResolver.resolveX509Data(secureMsg, keyInfo.getX509Data(0), sig, context);
                    break block17;
                }
                if (keyInfo.containsEncryptedKeyToken()) {
                    EncryptedKeyToken token = keyInfo.getEncryptedKey(0);
                    KeyInfoHeaderBlock kiHB = token.getKeyInfo();
                    if (!kiHB.containsSecurityTokenReference()) {
                        log.log(Level.SEVERE, LogStringsMessages.WSS_0335_UNSUPPORTED_REFERENCETYPE());
                        throw new XWSSecurityException("Unsupported reference type under EncryptedKey");
                    }
                    SecurityTokenReference keyBinding = kiHB.getSecurityTokenReference(0);
                    String dataEncAlgo = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
                    if (context.getAlgorithmSuite() != null) {
                        dataEncAlgo = context.getAlgorithmSuite().getEncryptionAlgorithm();
                    } else if (context.getDataEncryptionAlgorithm() != null) {
                        dataEncAlgo = context.getDataEncryptionAlgorithm();
                    }
                    returnKey = token.getSecretKey(KeyResolver.getKey(kiHB, false, context), dataEncAlgo);
                    break block17;
                }
                if (keyInfo.containsBinarySecret()) {
                    BinarySecret bs = keyInfo.getBinarySecret(0);
                    if (bs.getType() == null || bs.getType().equals("http://schemas.xmlsoap.org/ws/2005/02/trust/SymmetricKey")) {
                        String algo = "AES";
                        if (context.getAlgorithmSuite() != null) {
                            algo = SecurityUtil.getSecretKeyAlgorithm(context.getAlgorithmSuite().getEncryptionAlgorithm());
                        }
                        returnKey = new SecretKeySpec(bs.getRawValue(), algo);
                        break block17;
                    }
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0339_UNSUPPORTED_KEYINFO());
                    throw new XWSSecurityException("Unsupported wst:BinarySecret Type");
                }
                XWSSecurityException xwsse = new XWSSecurityException("Support for processing information in the given ds:KeyInfo is not present");
                log.log(Level.SEVERE, LogStringsMessages.WSS_0339_UNSUPPORTED_KEYINFO(), xwsse);
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, xwsse.getMessage(), xwsse);
            }
            catch (WssSoapFaultException wsse) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0284_WSS_SOAP_FAULT_EXCEPTION(), wsse);
                throw wsse;
            }
            catch (XWSSecurityException xwsse) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0284_WSS_SOAP_FAULT_EXCEPTION(), xwsse);
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, xwsse.getMessage(), xwsse);
            }
        }
        if (returnKey == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0600_ILLEGAL_TOKEN_REFERENCE());
            XWSSecurityException xwsse = new XWSSecurityException("Referenced security token could not be retrieved");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, xwsse.getMessage(), xwsse);
        }
        return returnKey;
    }

    public static Key resolveSamlAssertion(SecurableSoapMessage secureMsg, Element samlAssertion, boolean sig, FilterProcessingContext context, String assertionID) throws XWSSecurityException {
        try {
            Key key = (Key)context.getSamlIdVSKeyCache().get(assertionID);
            String samlSignatureResolved = (String)context.getExtraneousProperty("Saml_Signature_resolved");
            if (key != null) {
                return key;
            }
            if (samlAssertion == null) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0235_FAILED_LOCATE_SAML_ASSERTION());
                throw new XWSSecurityException("Cannot Locate SAML Assertion");
            }
            if ("false".equals(samlSignatureResolved)) {
                NodeList nl = samlAssertion.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
                if (nl.getLength() == 0) {
                    XWSSecurityException e = new XWSSecurityException("Unsigned SAML Assertion encountered");
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.impl.dsig.LogStringsMessages.WSS_1309_SAML_SIGNATURE_VERIFY_FAILED(), e);
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Exception during Signature verfication in SAML Assertion", e);
                }
                SignaturePolicy policy = (SignaturePolicy)context.getInferredPolicy();
                Element elem = (Element)nl.item(0);
                try {
                    if (!SignatureProcessor.verifySignature(elem, context)) {
                        log.log(Level.SEVERE, com.sun.xml.wss.logging.impl.dsig.LogStringsMessages.WSS_1310_SAML_SIGNATURE_INVALID());
                        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "SAML Assertion has invalid Signature", new Exception("SAML Assertion has invalid Signature"));
                    }
                }
                catch (XWSSecurityException ex) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.impl.dsig.LogStringsMessages.WSS_1310_SAML_SIGNATURE_INVALID());
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "SAML Assertion has invalid Signature", ex);
                }
            }
            if ("false".equals(samlSignatureResolved)) {
                context.setExtraneousProperty("Saml_Signature_resolved", "true");
            }
            Element keyInfoElem = AssertionUtil.getSubjectConfirmationKeyInfo(samlAssertion);
            KeyInfoHeaderBlock keyInfo = new KeyInfoHeaderBlock(XMLUtil.convertToSoapElement((Document)secureMsg.getSOAPPart(), keyInfoElem));
            key = KeyResolver.getKey(keyInfo, sig, context);
            context.getSamlIdVSKeyCache().put(assertionID, key);
            return key;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0238_FAILED_RESOLVE_SAML_ASSERTION());
            throw new XWSSecurityException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Key processSecurityTokenReference(KeyInfoHeaderBlock keyInfo, boolean sig, FilterProcessingContext context) throws XWSSecurityException {
        void var3_27;
        Object var3_3 = null;
        HashMap tokenCache = context.getTokenCache();
        SecurableSoapMessage secureMsg = context.getSecurableSoapMessage();
        SecurityTokenReference str = keyInfo.getSecurityTokenReference(0);
        ReferenceElement refElement = str.getReference();
        EncryptionPolicy policy = (EncryptionPolicy)context.getInferredPolicy();
        EncryptionPolicy inferredEncryptionPolicy = null;
        boolean isWSITRecipient = context.getMode() == 3;
        try {
            if (isWSITRecipient) {
                int i = context.getInferredSecurityPolicy().size() - 1;
                inferredEncryptionPolicy = (EncryptionPolicy)context.getInferredSecurityPolicy().get(i);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0239_FAILED_PROCESS_SECURITY_TOKEN_REFERENCE(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        if (refElement instanceof KeyIdentifier) {
            KeyIdentifier keyId = (KeyIdentifier)refElement;
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(keyId.getValueType()) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3SubjectKeyIdentifier".equals(keyId.getValueType())) {
                if (policy != null) {
                    AuthenticationTokenPolicy.X509CertificateBinding keyBinding = null;
                    keyBinding = (AuthenticationTokenPolicy.X509CertificateBinding)policy.newX509CertificateKeyBinding();
                    keyBinding.setReferenceType("Identifier");
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    x509Binding.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier");
                    x509Binding.setReferenceType("Identifier");
                    if (inferredKB == null) {
                        inferredEncryptionPolicy.setKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                        ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                        DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                        if (dktBind.getOriginalKeyBinding() == null) {
                            ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                        } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                            dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                        }
                    }
                }
                if (sig) {
                    PublicKey publicKey = context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                    return var3_27;
                }
                PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                return var3_27;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(keyId.getValueType())) {
                if (policy != null) {
                    AuthenticationTokenPolicy.X509CertificateBinding keyBinding = null;
                    keyBinding = (AuthenticationTokenPolicy.X509CertificateBinding)policy.newX509CertificateKeyBinding();
                    keyBinding.setReferenceType("Thumbprint");
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    x509Binding.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1");
                    x509Binding.setReferenceType("Identifier");
                    if (inferredKB == null) {
                        inferredEncryptionPolicy.setKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                        ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                        DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                        if (dktBind.getOriginalKeyBinding() == null) {
                            ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                        } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                            dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                        }
                    }
                }
                if (sig) {
                    PublicKey publicKey = context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()), "Thumbprint");
                    return var3_27;
                }
                PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()), "Thumbprint");
                return var3_27;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(keyId.getValueType())) {
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                    SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    x509Binding.setReferenceType("Identifier");
                    skBinding.setKeyBinding(x509Binding);
                    if (inferredKB == null) {
                        inferredEncryptionPolicy.setKeyBinding(skBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                    }
                }
                String ekSha1RefValue = (String)context.getExtraneousProperty("EncryptedKeySHA1");
                Key secretKey = (Key)context.getExtraneousProperty("SecretKey");
                String keyRefValue = keyId.getReferenceValue();
                if (ekSha1RefValue != null && secretKey != null) {
                    if (!ekSha1RefValue.equals(keyRefValue)) return var3_27;
                    Key key = secretKey;
                    return var3_27;
                }
                String string = "EncryptedKeySHA1 reference not correct";
                log.log(Level.SEVERE, LogStringsMessages.WSS_0240_INVALID_ENCRYPTED_KEY_SHA_1_REFERENCE());
                throw new XWSSecurityException(string);
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(keyId.getValueType()) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(keyId.getValueType())) {
                if (policy != null) {
                    AuthenticationTokenPolicy.SAMLAssertionBinding keyBinding = null;
                    keyBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)policy.newSAMLAssertionKeyBinding();
                    keyBinding.setReferenceType(keyId.getValueType());
                }
                String assertionID = keyId.getDecodedReferenceValue();
                Element samlAssertion = KeyResolver.resolveSAMLToken(str, assertionID, context);
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                    IssuedTokenKeyBinding issuedTokenKeyBinding = new IssuedTokenKeyBinding();
                    if (inferredKB == null) {
                        if (context.hasIssuedToken()) {
                            inferredEncryptionPolicy.setKeyBinding(issuedTokenKeyBinding);
                        } else {
                            inferredEncryptionPolicy.setKeyBinding(new AuthenticationTokenPolicy.SAMLAssertionBinding());
                        }
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(issuedTokenKeyBinding);
                    }
                }
                Key key = KeyResolver.resolveSamlAssertion(secureMsg, samlAssertion, sig, context, assertionID);
                if (!context.hasIssuedToken()) return var3_27;
                if (key == null) return var3_27;
                SecurityUtil.initInferredIssuedTokenContext(context, (Token)str, key);
                return var3_27;
            }
            if (policy != null) {
                AuthenticationTokenPolicy.SAMLAssertionBinding keyBinding = null;
                keyBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)policy.newSAMLAssertionKeyBinding();
            }
            Element samlAssertion = null;
            String assertionID = keyId.getDecodedReferenceValue();
            try {
                samlAssertion = KeyResolver.resolveSAMLToken(str, assertionID, context);
            }
            catch (Exception inferredKB) {
                // empty catch block
            }
            if (samlAssertion != null) {
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                    IssuedTokenKeyBinding issuedTokenKeyBinding = new IssuedTokenKeyBinding();
                    if (inferredKB == null) {
                        inferredEncryptionPolicy.setKeyBinding(issuedTokenKeyBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(issuedTokenKeyBinding);
                    }
                }
                Key key = KeyResolver.resolveSamlAssertion(secureMsg, samlAssertion, sig, context, assertionID);
                if (!context.hasIssuedToken()) return var3_27;
                if (key == null) return var3_27;
                SecurityUtil.initInferredIssuedTokenContext(context, (Token)str, key);
                return var3_27;
            }
            if (isWSITRecipient) {
                MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                AuthenticationTokenPolicy.X509CertificateBinding x509CertificateBinding = new AuthenticationTokenPolicy.X509CertificateBinding();
                x509CertificateBinding.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier");
                x509CertificateBinding.setReferenceType("Identifier");
                if (inferredKB == null) {
                    inferredEncryptionPolicy.setKeyBinding(x509CertificateBinding);
                } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                    ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509CertificateBinding);
                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                    DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                    if (dktBind.getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509CertificateBinding);
                    } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                        dktBind.getOriginalKeyBinding().setKeyBinding(x509CertificateBinding);
                    }
                }
            }
            if (sig) {
                PublicKey publicKey = context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                return var3_27;
            }
            PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()));
            return var3_27;
        }
        if (refElement instanceof DirectReference) {
            void var15_81;
            String uri = ((DirectReference)refElement).getURI();
            AuthenticationTokenPolicy.X509CertificateBinding keyBinding = null;
            String valueType = ((DirectReference)refElement).getValueType();
            if ("http://schemas.xmlsoap.org/ws/2005/02/sc/dk".equals(valueType) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk".equals(valueType)) {
                valueType = null;
            }
            if (policy != null) {
                keyBinding = (AuthenticationTokenPolicy.X509CertificateBinding)policy.newX509CertificateKeyBinding();
                keyBinding.setReferenceType("Direct");
                keyBinding.setValueType(valueType);
            }
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(valueType) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1".equals(valueType)) {
                String string;
                HashMap insertedX509Cache = context.getInsertedX509Cache();
                X509SecurityToken token = (X509SecurityToken)insertedX509Cache.get(string = SecurableSoapMessage.getIdFromFragmentRef(uri));
                if (token == null) {
                    token = (X509SecurityToken)KeyResolver.resolveToken(string, context, secureMsg);
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    x509Binding.setReferenceType("Direct");
                    x509Binding.setValueType(valueType);
                    if (inferredKB == null) {
                        inferredEncryptionPolicy.setKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                        ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                        DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                        if (dktBind.getOriginalKeyBinding() == null) {
                            dktBind.setOriginalKeyBinding(x509Binding);
                        } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                            dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                        }
                    }
                }
                Key key = KeyResolver.resolveX509Token(secureMsg, token, sig, context);
                return var3_27;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(valueType)) {
                String wsuId = SecurableSoapMessage.getIdFromFragmentRef(uri);
                SecurityToken securityToken = KeyResolver.resolveToken(wsuId, context, secureMsg);
                KeyInfoHeaderBlock kiHB = ((EncryptedKeyToken)securityToken).getKeyInfo();
                SecurityTokenReference sectr = kiHB.getSecurityTokenReference(0);
                String dataEncAlgo = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
                if (context.getAlgorithmSuite() != null) {
                    dataEncAlgo = context.getAlgorithmSuite().getEncryptionAlgorithm();
                } else if (context.getDataEncryptionAlgorithm() != null) {
                    dataEncAlgo = context.getDataEncryptionAlgorithm();
                }
                try {
                    Element cipherData = (Element)((EncryptedKeyToken)securityToken).getAsSoapElement().getChildElements(new QName("http://www.w3.org/2001/04/xmlenc#", "CipherData", "xenc")).next();
                    String cipherValue = cipherData.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0).getTextContent();
                    byte[] decodedCipher = Base64.decode(cipherValue);
                    byte[] ekSha1 = MessageDigest.getInstance("SHA-1").digest(decodedCipher);
                    String encEkSha1 = Base64.encode(ekSha1);
                    context.setExtraneousProperty("EKSHA1Value", encEkSha1);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0241_UNABLETO_SET_EKSHA_1_ON_CONTEXT(), e);
                    throw new XWSSecurityException((Throwable)e);
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                    SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    skBinding.setKeyBinding(x509Binding);
                    if (inferredKB == null) {
                        inferredEncryptionPolicy.setKeyBinding(skBinding);
                    } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                        ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                        DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                        if (dktBind.getOriginalKeyBinding() == null) {
                            dktBind.setOriginalKeyBinding(x509Binding);
                        } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                            dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                        }
                    }
                }
                Key key = ((EncryptedKeyToken)securityToken).getSecretKey(KeyResolver.getKey(kiHB, sig, context), dataEncAlgo);
                context.setExtraneousProperty("SecretKeyValue", key);
                return var3_27;
            }
            if ("http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(valueType) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct".equals(valueType)) {
                void var15_78;
                String sctId = SecurableSoapMessage.getIdFromFragmentRef(uri);
                SecurityToken securityToken = (SecurityToken)tokenCache.get(sctId);
                if (securityToken == null) {
                    void var15_77;
                    SecurityContextTokenImpl securityContextTokenImpl = SecurityUtil.locateBySCTId(context, uri);
                    if (securityContextTokenImpl == null) {
                        SecurityToken securityToken2 = KeyResolver.resolveToken(sctId, context, secureMsg);
                    }
                    if (var15_77 == null) {
                        log.log(Level.SEVERE, LogStringsMessages.WSS_0242_UNABLETO_LOCATE_SCT());
                        throw new XWSSecurityException("SCT Token with Id " + sctId + "not found");
                    }
                    tokenCache.put(sctId, var15_77);
                }
                if (!(var15_78 instanceof SecurityContextToken)) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0243_INVALID_VALUE_TYPE_NON_SCT_TOKEN());
                    throw new XWSSecurityException("Incorrect ValueType: http://schemas.xmlsoap.org/ws/2005/02/sc/sct, specified for a Non SCT Token");
                }
                byte[] proofKey = KeyResolver.resolveSCT(context, (SecurityContextTokenImpl)var15_78, sig);
                String encAlgo = "AES";
                if (context.getAlgorithmSuite() != null) {
                    encAlgo = SecurityUtil.getSecretKeyAlgorithm(context.getAlgorithmSuite().getEncryptionAlgorithm());
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                    SecureConversationTokenKeyBinding sctBinding = new SecureConversationTokenKeyBinding();
                    if (inferredKB == null) {
                        inferredEncryptionPolicy.setKeyBinding(sctBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(sctBinding);
                    }
                }
                SecretKeySpec secretKeySpec = new SecretKeySpec(proofKey, encAlgo);
                return var3_27;
            }
            if (null != valueType) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0337_UNSUPPORTED_DIRECTREF_MECHANISM(((DirectReference)refElement).getValueType()), new Object[]{((DirectReference)refElement).getValueType()});
                XWSSecurityException xwsse = new XWSSecurityException("unsupported directreference ValueType " + ((DirectReference)refElement).getValueType());
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
            }
            String wsuId = SecurableSoapMessage.getIdFromFragmentRef(uri);
            SecurityContextTokenImpl securityContextTokenImpl = SecurityUtil.locateBySCTId(context, wsuId);
            if (securityContextTokenImpl == null) {
                SecurityToken securityToken = KeyResolver.resolveToken(wsuId, context, secureMsg);
            }
            if (var15_81 instanceof X509SecurityToken) {
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    x509Binding.setReferenceType("Direct");
                    if (inferredKB == null) {
                        inferredEncryptionPolicy.setKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                    }
                }
                Key key = KeyResolver.resolveX509Token(secureMsg, (X509SecurityToken)var15_81, sig, context);
                return var3_27;
            }
            if (var15_81 instanceof EncryptedKeyToken) {
                KeyInfoHeaderBlock kiHB = ((EncryptedKeyToken)var15_81).getKeyInfo();
                SecurityTokenReference sectr = kiHB.getSecurityTokenReference(0);
                ReferenceElement refElem = sectr.getReference();
                String dataEncAlgo = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
                if (context.getAlgorithmSuite() != null) {
                    dataEncAlgo = context.getAlgorithmSuite().getEncryptionAlgorithm();
                } else if (context.getDataEncryptionAlgorithm() != null) {
                    dataEncAlgo = context.getDataEncryptionAlgorithm();
                }
                try {
                    Element cipherData = (Element)((EncryptedKeyToken)var15_81).getAsSoapElement().getChildElements(new QName("http://www.w3.org/2001/04/xmlenc#", "CipherData", "xenc")).next();
                    String cipherValue = cipherData.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0).getTextContent();
                    byte[] decodedCipher = Base64.decode(cipherValue);
                    byte[] ekSha1 = MessageDigest.getInstance("SHA-1").digest(decodedCipher);
                    String encEkSha1 = Base64.encode(ekSha1);
                    context.setExtraneousProperty("EKSHA1Value", encEkSha1);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0241_UNABLETO_SET_EKSHA_1_ON_CONTEXT(), e);
                    throw new XWSSecurityException((Throwable)e);
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                    SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    skBinding.setKeyBinding(x509Binding);
                    if (inferredKB == null) {
                        inferredEncryptionPolicy.setKeyBinding(skBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                    }
                }
                Key key = ((EncryptedKeyToken)var15_81).getSecretKey(KeyResolver.getKey(kiHB, sig, context), dataEncAlgo);
                context.setExtraneousProperty("SecretKeyValue", key);
                return var3_27;
            }
            if (var15_81 instanceof SecurityContextToken) {
                byte[] proofKey = KeyResolver.resolveSCT(context, (SecurityContextTokenImpl)var15_81, sig);
                String encAlgo = "AES";
                if (context.getAlgorithmSuite() != null) {
                    encAlgo = SecurityUtil.getSecretKeyAlgorithm(context.getAlgorithmSuite().getEncryptionAlgorithm());
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                    SecureConversationTokenKeyBinding sctBinding = new SecureConversationTokenKeyBinding();
                    if (inferredKB == null) {
                        inferredEncryptionPolicy.setKeyBinding(sctBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(sctBinding);
                    }
                }
                SecretKeySpec secretKeySpec = new SecretKeySpec(proofKey, encAlgo);
                return var3_27;
            }
            if (!(var15_81 instanceof DerivedKeyTokenHeaderBlock)) {
                String message = " Cannot Resolve URI " + uri;
                log.log(Level.SEVERE, LogStringsMessages.WSS_0337_UNSUPPORTED_DIRECTREF_MECHANISM(message), new Object[]{message});
                XWSSecurityException xwsse = new XWSSecurityException(message);
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, xwsse.getMessage(), xwsse);
            }
            if (isWSITRecipient) {
                MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                DerivedTokenKeyBinding dtkBinding = new DerivedTokenKeyBinding();
                if (inferredKB == null) {
                    inferredEncryptionPolicy.setKeyBinding(dtkBinding);
                } else if (!PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0244_INVALID_LEVEL_DKT());
                    throw new XWSSecurityException("A derived Key Token should be a top level key binding");
                }
            }
            Key key = KeyResolver.resolveDKT(context, (DerivedKeyTokenHeaderBlock)var15_81);
            return var3_27;
        }
        if (!(refElement instanceof X509IssuerSerial)) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0338_UNSUPPORTED_REFERENCE_MECHANISM());
            XWSSecurityException xwsse = new XWSSecurityException("Key reference mechanism not supported");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
        }
        BigInteger serialNumber = ((X509IssuerSerial)refElement).getSerialNumber();
        String issuerName = ((X509IssuerSerial)refElement).getIssuerName();
        if (isWSITRecipient) {
            MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
            AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
            x509Binding.setReferenceType("IssuerSerialNumber");
            if (inferredKB == null) {
                inferredEncryptionPolicy.setKeyBinding(x509Binding);
            } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
            } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                DerivedTokenKeyBinding derivedTokenKeyBinding = (DerivedTokenKeyBinding)inferredKB;
                if (derivedTokenKeyBinding.getOriginalKeyBinding() == null) {
                    derivedTokenKeyBinding.setOriginalKeyBinding(x509Binding);
                } else if (PolicyTypeUtil.symmetricKeyBinding(derivedTokenKeyBinding.getOriginalKeyBinding())) {
                    derivedTokenKeyBinding.getOriginalKeyBinding().setKeyBinding(x509Binding);
                }
            }
        }
        if (sig) {
            PublicKey publicKey = context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), serialNumber, issuerName);
            return var3_27;
        }
        PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), serialNumber, issuerName);
        return var3_27;
    }

    public static Key resolveX509Token(SecurableSoapMessage secureMsg, X509SecurityToken token, boolean sig, FilterProcessingContext context) throws XWSSecurityException {
        if (sig) {
            X509Certificate cert = token.getCertificate();
            context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
            if (context.getTrustCredentialHolder() != null) {
                context.getTrustCredentialHolder().setRequestorCertificate(cert);
            }
            return cert.getPublicKey();
        }
        return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), token.getCertificate());
    }

    public static Key resolveKeyValue(SecurableSoapMessage secureMsg, KeyValue keyValue, boolean sig, FilterProcessingContext context) throws XWSSecurityException {
        keyValue.getElement().normalize();
        try {
            if (sig) {
                return keyValue.getPublicKey();
            }
            return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), keyValue.getPublicKey(), false);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0601_UNSUPPORTED_KEYINFO_WSS_0601_ILLEGAL_KEY_VALUE(e.getMessage()), e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public static Key resolveX509Data(SecurableSoapMessage secureMsg, X509Data x509Data, boolean sig, FilterProcessingContext context) throws XWSSecurityException {
        x509Data.getElement().normalize();
        X509Certificate cert = null;
        try {
            if (!x509Data.containsCertificate()) {
                if (x509Data.containsSKI()) {
                    if (sig) {
                        return context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), x509Data.itemSKI(0).getSKIBytes());
                    }
                    return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), x509Data.itemSKI(0).getSKIBytes());
                }
                if (x509Data.containsSubjectName()) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0339_UNSUPPORTED_KEYINFO());
                    throw new XWSSecurityException("X509SubjectName child element of X509Data is not yet supported by our implementation");
                }
                if (x509Data.containsIssuerSerial()) {
                    if (sig) {
                        return context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), x509Data.itemIssuerSerial(0).getSerialNumber(), x509Data.itemIssuerSerial(0).getIssuerName());
                    }
                    return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), x509Data.itemIssuerSerial(0).getSerialNumber(), x509Data.itemIssuerSerial(0).getIssuerName());
                }
                log.log(Level.SEVERE, LogStringsMessages.WSS_0339_UNSUPPORTED_KEYINFO());
                throw new XWSSecurityException("Unsupported child element of X509Data encountered");
            }
            cert = x509Data.itemCertificate(0).getX509Certificate();
            if (sig) {
                return cert.getPublicKey();
            }
            return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0602_ILLEGAL_X_509_DATA(e.getMessage()), e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
    }

    private static byte[] getDecodedBase64EncodedData(String encodedData) throws XWSSecurityException {
        try {
            return Base64.decode(encodedData);
        }
        catch (Base64DecodingException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0144_UNABLETO_DECODE_BASE_64_DATA(e.getMessage()), e);
            throw new XWSSecurityException("Unable to decode Base64 encoded data", (Throwable)e);
        }
    }

    private static SecurityToken resolveToken(String uri, FilterProcessingContext context, SecurableSoapMessage secureMsg) throws XWSSecurityException {
        try {
            HashMap cache = context.getTokenCache();
            SecurityToken token = (SecurityToken)cache.get(uri);
            if (token != null) {
                return token;
            }
            if (token == null) {
                Element tokenNode = secureMsg.getElementById(uri);
                tokenNode.normalize();
                if ("BinarySecurityToken".equals(tokenNode.getLocalName())) {
                    token = new X509SecurityToken((SOAPElement)tokenNode);
                } else if ("EncryptedKey".equals(tokenNode.getLocalName())) {
                    token = new EncryptedKeyToken((SOAPElement)tokenNode);
                } else if ("SecurityContextToken".equals(tokenNode.getLocalName())) {
                    token = new SecurityContextTokenImpl((SOAPElement)tokenNode);
                } else if ("DerivedKeyToken".equals(tokenNode.getLocalName())) {
                    token = new DerivedKeyTokenHeaderBlock((SOAPElement)tokenNode);
                }
            }
            cache.put(uri, token);
            return token;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0245_FAILED_RESOLVE_SECURITY_TOKEN(), ex);
            throw new XWSSecurityException((Throwable)ex);
        }
    }

    private static Element resolveSAMLToken(SecurityTokenReference tokenRef, String assertionId, FilterProcessingContext context) throws XWSSecurityException {
        Element clientSAMLAssertionCache = (Element)context.getExtraneousProperties().get("Saml_Assertion_Client_Cache");
        if (clientSAMLAssertionCache != null) {
            return clientSAMLAssertionCache;
        }
        Element tokenElement = context.getIssuedSAMLToken();
        if (tokenElement != null) {
            context.setExtraneousProperty("Saml_Signature_resolved", "false");
        }
        if (tokenElement == null) {
            if (tokenRef.getSamlAuthorityBinding() != null) {
                tokenElement = context.getSecurityEnvironment().locateSAMLAssertion(context.getExtraneousProperties(), tokenRef.getSamlAuthorityBinding(), assertionId, (Document)context.getSOAPMessage().getSOAPPart());
            } else {
                tokenElement = SAMLUtil.locateSamlAssertion(assertionId, (Document)context.getSOAPMessage().getSOAPPart());
                if (!"true".equals(context.getExtraneousProperty("Saml_Signature_resolved")) || "false".equals(context.getExtraneousProperty("Saml_Signature_resolved"))) {
                    context.setExtraneousProperty("Saml_Signature_resolved", "false");
                }
            }
        }
        KeyResolver.addAuthorityId(tokenElement, context);
        try {
            if ("EncryptedData".equals(tokenElement.getLocalName())) {
                return null;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0238_FAILED_RESOLVE_SAML_ASSERTION(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        return tokenElement;
    }

    private static void addAuthorityId(Element assertion, FilterProcessingContext fp) {
        EncryptionPolicy ep = (EncryptionPolicy)fp.getInferredPolicy();
        if (ep != null) {
            AuthenticationTokenPolicy.SAMLAssertionBinding kb = (AuthenticationTokenPolicy.SAMLAssertionBinding)ep.newSAMLAssertionKeyBinding();
            String issuer = assertion.getAttribute("Issuer");
            kb.setAuthorityIdentifier(issuer);
        }
    }

    private static byte[] resolveSCT(FilterProcessingContext context, SecurityContextTokenImpl token, boolean sig) throws XWSSecurityException {
        context.setExtraneousProperty("Incoming_SCT", token);
        String scId = token.getSCId();
        IssuedTokenContext ctx = null;
        String protocol = context.getWSSCVersion(context.getSecurityPolicyVersion());
        if (context.isClient()) {
            DefaultSCTokenConfiguration config = new DefaultSCTokenConfiguration(protocol, scId, !context.isExpired(), !context.isInboundMessage());
            ctx = IssuedTokenManager.getInstance().createIssuedTokenContext((IssuedTokenConfiguration)config, null);
            try {
                IssuedTokenManager.getInstance().getIssuedToken(ctx);
            }
            catch (WSTrustException e) {
                throw new XWSSecurityException((Throwable)e);
            }
        } else {
            ctx = ((SessionManager)context.getExtraneousProperty("SessionManager")).getSecurityContext(scId, !context.isExpired());
            URI sctId = null;
            String sctIns = null;
            String wsuId = null;
            SecurityContextToken sct = (SecurityContextToken)ctx.getSecurityToken();
            if (sct != null) {
                sctId = sct.getIdentifier();
                sctIns = sct.getInstance();
                wsuId = sct.getWsuId();
            } else {
                SecurityContextTokenInfo sctInfo = ctx.getSecurityContextTokenInfo();
                sctId = URI.create(sctInfo.getIdentifier());
                sctIns = sctInfo.getInstance();
                wsuId = sctInfo.getExternalId();
            }
            ctx.setSecurityToken((Token)WSTrustElementFactory.newInstance((String)protocol).createSecurityContextToken(sctId, sctIns, wsuId));
        }
        if (ctx == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0246_UNABLETO_LOCATE_SECURE_CONVERSATION_SESSION());
            throw new XWSSecurityException("Could not locate SecureConversation session for Id:" + scId);
        }
        Subject subj = ctx.getRequestorSubject();
        if (subj != null && context.getExtraneousProperty("SCBOOTSTRAP_CRED_IN_SUBJ") == null) {
            context.getSecurityEnvironment().updateOtherPartySubject(SecurityUtil.getSubject(context.getExtraneousProperties()), subj);
            context.getExtraneousProperties().put("SCBOOTSTRAP_CRED_IN_SUBJ", "true");
        }
        byte[] proofKey = null;
        String instance = null;
        SecurityContextToken scToken = (SecurityContextToken)ctx.getSecurityToken();
        instance = scToken != null ? scToken.getInstance() : ctx.getSecurityContextTokenInfo().getInstance();
        if (instance != null) {
            if (context.isExpired()) {
                proofKey = ctx.getProofKey();
            } else {
                SecurityContextTokenInfo sctInstanceInfo = ctx.getSecurityContextTokenInfo();
                proofKey = sctInstanceInfo.getInstanceSecret(scToken.getInstance());
            }
        } else {
            proofKey = ctx.getProofKey();
        }
        return proofKey;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Key resolveDKT(FilterProcessingContext context, DerivedKeyTokenHeaderBlock token) throws XWSSecurityException {
        byte[] secret;
        String dataEncAlgo;
        block36: {
            Key encKey;
            ReferenceElement refElement;
            SecurityTokenReference sectr;
            boolean isWSITRecipient;
            EncryptionPolicy inferredEncryptionPolicy;
            SecurableSoapMessage secureMsg;
            block37: {
                SecureConversationTokenKeyBinding sctBinding;
                MLSPolicy inferredKB;
                void var13_21;
                dataEncAlgo = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
                if (context.getAlgorithmSuite() != null) {
                    dataEncAlgo = context.getAlgorithmSuite().getEncryptionAlgorithm();
                }
                secureMsg = context.getSecurableSoapMessage();
                inferredEncryptionPolicy = null;
                isWSITRecipient = context.getMode() == 3;
                try {
                    if (isWSITRecipient) {
                        int i = context.getInferredSecurityPolicy().size() - 1;
                        inferredEncryptionPolicy = (EncryptionPolicy)context.getInferredSecurityPolicy().get(i);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0247_FAILED_RESOLVE_DERIVED_KEY_TOKEN());
                    throw new XWSSecurityException((Throwable)e);
                }
                sectr = token.getDerivedKeyElement();
                if (sectr == null) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0248_NULL_STR());
                    throw new XWSSecurityException("Invalid DerivedKey Token encountered, no STR found");
                }
                refElement = sectr.getReference();
                encKey = null;
                secret = null;
                if (!(refElement instanceof DirectReference)) break block37;
                String uri = ((DirectReference)refElement).getURI();
                String valueType = ((DirectReference)refElement).getValueType();
                String wsuId = SecurableSoapMessage.getIdFromFragmentRef(uri);
                SecurityContextTokenImpl securityContextTokenImpl = SecurityUtil.locateBySCTId(context, wsuId);
                if (securityContextTokenImpl == null) {
                    SecurityToken securityToken = KeyResolver.resolveToken(wsuId, context, secureMsg);
                    if (valueType == null && securityToken instanceof EncryptedKeyToken) {
                        valueType = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey";
                    }
                }
                if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(valueType)) {
                    try {
                        Element cipherData = (Element)((EncryptedKeyToken)var13_21).getAsSoapElement().getChildElements(new QName("http://www.w3.org/2001/04/xmlenc#", "CipherData", "xenc")).next();
                        String cipherValue = cipherData.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0).getTextContent();
                        byte[] decodedCipher = Base64.decode(cipherValue);
                        byte[] ekSha1 = MessageDigest.getInstance("SHA-1").digest(decodedCipher);
                        String encEkSha1 = Base64.encode(ekSha1);
                        context.setExtraneousProperty("EKSHA1Value", encEkSha1);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, LogStringsMessages.WSS_0241_UNABLETO_SET_EKSHA_1_ON_CONTEXT(), e);
                        throw new XWSSecurityException((Throwable)e);
                    }
                    if (isWSITRecipient) {
                        inferredKB = inferredEncryptionPolicy.getKeyBinding();
                        SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                        AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                        skBinding.setKeyBinding(x509Binding);
                        if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                            ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                        }
                    }
                    KeyInfoHeaderBlock kiHB = ((EncryptedKeyToken)var13_21).getKeyInfo();
                    encKey = ((EncryptedKeyToken)var13_21).getSecretKey(KeyResolver.getKey(kiHB, false, context), dataEncAlgo);
                    secret = encKey.getEncoded();
                    context.setExtraneousProperty("SecretKeyValue", encKey);
                    break block36;
                } else if ("http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(valueType) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct".equals(valueType)) {
                    if (!(var13_21 instanceof SecurityContextToken)) {
                        log.log(Level.SEVERE, LogStringsMessages.WSS_0243_INVALID_VALUE_TYPE_NON_SCT_TOKEN());
                        throw new XWSSecurityException("Incorrect ValueType: http://schemas.xmlsoap.org/ws/2005/02/sc/sct, specified for a Non SCT Token");
                    }
                    if (isWSITRecipient) {
                        inferredKB = inferredEncryptionPolicy.getKeyBinding();
                        sctBinding = new SecureConversationTokenKeyBinding();
                        if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                            ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(sctBinding);
                        }
                    }
                    secret = KeyResolver.resolveSCT(context, (SecurityContextTokenImpl)var13_21, false);
                    break block36;
                } else {
                    if (null != valueType) {
                        log.log(Level.SEVERE, LogStringsMessages.WSS_0249_UNSUPPORTED_TOKEN_TYPE_DKT());
                        throw new XWSSecurityException("Unsupported TokenType " + (SecurityToken)var13_21 + " under DerivedKeyToken");
                    }
                    if (!(var13_21 instanceof SecurityContextToken)) {
                        log.log(Level.SEVERE, LogStringsMessages.WSS_0249_UNSUPPORTED_TOKEN_TYPE_DKT());
                        throw new XWSSecurityException("Unsupported TokenType " + (SecurityToken)var13_21 + " under DerivedKeyToken");
                    }
                    if (isWSITRecipient) {
                        inferredKB = inferredEncryptionPolicy.getKeyBinding();
                        sctBinding = new SecureConversationTokenKeyBinding();
                        if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                            ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(sctBinding);
                        }
                    }
                    secret = KeyResolver.resolveSCT(context, (SecurityContextTokenImpl)var13_21, false);
                }
                break block36;
            }
            if (!(refElement instanceof KeyIdentifier)) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0283_UNSUPPORTED_REFERENCE_TYPE_DKT());
                throw new XWSSecurityException("Unsupported ReferenceType " + refElement + " under DerivedKeyToken");
            }
            KeyIdentifier keyId = (KeyIdentifier)refElement;
            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(keyId.getValueType())) {
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                    SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509CertificateBinding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    x509CertificateBinding.setReferenceType("Identifier");
                    skBinding.setKeyBinding(x509CertificateBinding);
                    if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                    }
                }
                String ekSha1RefValue = (String)context.getExtraneousProperty("EncryptedKeySHA1");
                Key secretKey = (Key)context.getExtraneousProperty("SecretKey");
                String string = keyId.getReferenceValue();
                if (ekSha1RefValue != null && secretKey != null) {
                    if (!ekSha1RefValue.equals(string)) {
                        log.log(Level.SEVERE, LogStringsMessages.WSS_0240_INVALID_ENCRYPTED_KEY_SHA_1_REFERENCE());
                        throw new XWSSecurityException("EncryptedKeySHA1 reference not correct");
                    }
                    encKey = secretKey;
                    secret = encKey.getEncoded();
                    break block36;
                } else {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0240_INVALID_ENCRYPTED_KEY_SHA_1_REFERENCE());
                    String message = "EncryptedKeySHA1 reference not correct";
                    throw new XWSSecurityException(message);
                }
            }
            if (!"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(keyId.getValueType()) && !"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(keyId.getValueType())) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0282_UNSUPPORTED_KEY_IDENTIFIER_REFERENCE_DKT());
                throw new XWSSecurityException("Unsupported KeyIdentifier Reference " + keyId + " under DerivedKeyToken");
            }
            if (isWSITRecipient) {
                MLSPolicy inferredKB = inferredEncryptionPolicy.getKeyBinding();
                IssuedTokenKeyBinding itkBinding = new IssuedTokenKeyBinding();
                if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                    ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(itkBinding);
                }
            }
            String asId = keyId.getReferenceValue();
            Element assertion = KeyResolver.resolveSAMLToken(sectr, asId, context);
            encKey = KeyResolver.resolveSamlAssertion(secureMsg, assertion, true, context, asId);
            if (context.hasIssuedToken() && encKey != null) {
                SecurityUtil.initInferredIssuedTokenContext(context, (Token)sectr, encKey);
            }
            secret = encKey.getEncoded();
        }
        long length = token.getLength();
        long offset = token.getOffset();
        byte[] nonce = token.getNonce();
        String label = token.getLabel();
        DerivedKeyTokenImpl dkt = new DerivedKeyTokenImpl(offset, length, secret, nonce, label);
        String jceAlgo = SecurityUtil.getSecretKeyAlgorithm(dataEncAlgo);
        SecretKey returnKey = null;
        try {
            return dkt.generateSymmetricKey(jceAlgo);
        }
        catch (InvalidKeyException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0247_FAILED_RESOLVE_DERIVED_KEY_TOKEN());
            throw new XWSSecurityException((Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0247_FAILED_RESOLVE_DERIVED_KEY_TOKEN());
            throw new XWSSecurityException((Throwable)ex);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Key processSTR(KeyInfoHeaderBlock keyInfo, boolean sig, FilterProcessingContext context) throws XWSSecurityException {
        void var3_27;
        Object var3_3 = null;
        HashMap tokenCache = context.getTokenCache();
        SecurableSoapMessage secureMsg = context.getSecurableSoapMessage();
        SecurityTokenReference str = keyInfo.getSecurityTokenReference(0);
        ReferenceElement refElement = str.getReference();
        SignaturePolicy policy = (SignaturePolicy)context.getInferredPolicy();
        SignaturePolicy inferredSignaturePolicy = null;
        boolean isWSITRecipient = context.getMode() == 3;
        try {
            if (isWSITRecipient) {
                int i = context.getInferredSecurityPolicy().size() - 1;
                inferredSignaturePolicy = (SignaturePolicy)context.getInferredSecurityPolicy().get(i);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0250_FAILED_PROCESS_STR(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        if (refElement instanceof KeyIdentifier) {
            KeyIdentifier keyId = (KeyIdentifier)refElement;
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(keyId.getValueType()) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3SubjectKeyIdentifier".equals(keyId.getValueType())) {
                if (policy != null) {
                    AuthenticationTokenPolicy.X509CertificateBinding keyBinding = null;
                    keyBinding = (AuthenticationTokenPolicy.X509CertificateBinding)policy.newX509CertificateKeyBinding();
                    keyBinding.setReferenceType("Identifier");
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    x509Binding.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier");
                    x509Binding.setReferenceType("Identifier");
                    if (inferredKB == null) {
                        inferredSignaturePolicy.setKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                    }
                }
                if (sig) {
                    PublicKey publicKey = context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                    return var3_27;
                }
                PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                return var3_27;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(keyId.getValueType())) {
                if (policy != null) {
                    AuthenticationTokenPolicy.X509CertificateBinding keyBinding = null;
                    keyBinding = (AuthenticationTokenPolicy.X509CertificateBinding)policy.newX509CertificateKeyBinding();
                    keyBinding.setReferenceType("Thumbprint");
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    x509Binding.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1");
                    x509Binding.setReferenceType("Identifier");
                    if (inferredKB == null) {
                        inferredSignaturePolicy.setKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                    }
                }
                if (sig) {
                    PublicKey publicKey = context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()), "Thumbprint");
                    return var3_27;
                }
                PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()), "Thumbprint");
                return var3_27;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(keyId.getValueType())) {
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                    SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    skBinding.setKeyBinding(x509Binding);
                    if (inferredKB == null) {
                        inferredSignaturePolicy.setKeyBinding(skBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                    }
                }
                String ekSha1RefValue = (String)context.getExtraneousProperty("EncryptedKeySHA1");
                Key secretKey = (Key)context.getExtraneousProperty("SecretKey");
                String keyRefValue = keyId.getReferenceValue();
                if (ekSha1RefValue != null && secretKey != null) {
                    if (!ekSha1RefValue.equals(keyRefValue)) return var3_27;
                    Key key = secretKey;
                    return var3_27;
                }
                log.log(Level.SEVERE, LogStringsMessages.WSS_0240_INVALID_ENCRYPTED_KEY_SHA_1_REFERENCE());
                String string = "EncryptedKeySHA1 reference not correct";
                throw new XWSSecurityException(string);
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(keyId.getValueType()) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(keyId.getValueType())) {
                if (policy != null) {
                    AuthenticationTokenPolicy.SAMLAssertionBinding keyBinding = null;
                    keyBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)policy.newSAMLAssertionKeyBinding();
                    keyBinding.setReferenceType(keyId.getValueType());
                }
                String assertionID = keyId.getDecodedReferenceValue();
                Element samlAssertion = KeyResolver.resolveSAMLToken(str, assertionID, context);
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                    IssuedTokenKeyBinding issuedTokenKeyBinding = new IssuedTokenKeyBinding();
                    if (inferredKB == null) {
                        if (context.hasIssuedToken()) {
                            inferredSignaturePolicy.setKeyBinding(issuedTokenKeyBinding);
                        } else {
                            inferredSignaturePolicy.setKeyBinding(new AuthenticationTokenPolicy.SAMLAssertionBinding());
                        }
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(issuedTokenKeyBinding);
                    }
                }
                Key key = KeyResolver.resolveSamlAssertion(secureMsg, samlAssertion, sig, context, assertionID);
                if (!context.hasIssuedToken()) return var3_27;
                if (key == null) return var3_27;
                SecurityUtil.initInferredIssuedTokenContext(context, (Token)str, key);
                return var3_27;
            }
            if (policy != null) {
                AuthenticationTokenPolicy.SAMLAssertionBinding keyBinding = null;
                keyBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)policy.newSAMLAssertionKeyBinding();
            }
            Element samlAssertion = null;
            String assertionID = keyId.getDecodedReferenceValue();
            try {
                samlAssertion = KeyResolver.resolveSAMLToken(str, assertionID, context);
            }
            catch (Exception inferredKB) {
                // empty catch block
            }
            if (samlAssertion != null) {
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                    IssuedTokenKeyBinding issuedTokenKeyBinding = new IssuedTokenKeyBinding();
                    if (inferredKB == null) {
                        if (context.hasIssuedToken()) {
                            inferredSignaturePolicy.setKeyBinding(issuedTokenKeyBinding);
                        } else {
                            inferredSignaturePolicy.setKeyBinding(new AuthenticationTokenPolicy.SAMLAssertionBinding());
                        }
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(issuedTokenKeyBinding);
                    }
                }
                Key key = KeyResolver.resolveSamlAssertion(secureMsg, samlAssertion, sig, context, assertionID);
                if (!context.hasIssuedToken()) return var3_27;
                if (key == null) return var3_27;
                SecurityUtil.initInferredIssuedTokenContext(context, (Token)str, key);
                return var3_27;
            }
            if (isWSITRecipient) {
                MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                AuthenticationTokenPolicy.X509CertificateBinding x509CertificateBinding = new AuthenticationTokenPolicy.X509CertificateBinding();
                x509CertificateBinding.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier");
                x509CertificateBinding.setReferenceType("Identifier");
                if (inferredKB == null) {
                    inferredSignaturePolicy.setKeyBinding(x509CertificateBinding);
                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                    ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509CertificateBinding);
                }
            }
            if (sig) {
                PublicKey publicKey = context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                return var3_27;
            }
            PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()));
            return var3_27;
        }
        if (refElement instanceof DirectReference) {
            void var15_79;
            String uri = ((DirectReference)refElement).getURI();
            AuthenticationTokenPolicy.X509CertificateBinding keyBinding = null;
            String valueType = ((DirectReference)refElement).getValueType();
            if ("http://schemas.xmlsoap.org/ws/2005/02/sc/dk".equals(valueType) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk".equals(valueType)) {
                valueType = null;
            }
            if (policy != null) {
                keyBinding = (AuthenticationTokenPolicy.X509CertificateBinding)policy.newX509CertificateKeyBinding();
                keyBinding.setReferenceType("Direct");
                keyBinding.setValueType(valueType);
            }
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(valueType) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1".equals(valueType)) {
                String string;
                HashMap insertedX509Cache = context.getInsertedX509Cache();
                X509SecurityToken token = (X509SecurityToken)insertedX509Cache.get(string = SecurableSoapMessage.getIdFromFragmentRef(uri));
                if (token == null) {
                    token = (X509SecurityToken)KeyResolver.resolveToken(string, context, secureMsg);
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    x509Binding.setReferenceType("Direct");
                    x509Binding.setValueType(valueType);
                    if (inferredKB == null) {
                        inferredSignaturePolicy.setKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                    }
                }
                Key key = KeyResolver.resolveX509Token(secureMsg, token, sig, context);
                return var3_27;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(valueType)) {
                String wsuId = SecurableSoapMessage.getIdFromFragmentRef(uri);
                SecurityToken securityToken = KeyResolver.resolveToken(wsuId, context, secureMsg);
                KeyInfoHeaderBlock kiHB = ((EncryptedKeyToken)securityToken).getKeyInfo();
                SecurityTokenReference sectr = kiHB.getSecurityTokenReference(0);
                String dataEncAlgo = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
                if (context.getAlgorithmSuite() != null) {
                    dataEncAlgo = context.getAlgorithmSuite().getEncryptionAlgorithm();
                } else if (context.getDataEncryptionAlgorithm() != null) {
                    dataEncAlgo = context.getDataEncryptionAlgorithm();
                }
                try {
                    Element cipherData = (Element)((EncryptedKeyToken)securityToken).getAsSoapElement().getChildElements(new QName("http://www.w3.org/2001/04/xmlenc#", "CipherData", "xenc")).next();
                    String cipherValue = cipherData.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0).getTextContent();
                    byte[] decodedCipher = Base64.decode(cipherValue);
                    byte[] ekSha1 = MessageDigest.getInstance("SHA-1").digest(decodedCipher);
                    String encEkSha1 = Base64.encode(ekSha1);
                    context.setExtraneousProperty("EKSHA1Value", encEkSha1);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0241_UNABLETO_SET_EKSHA_1_ON_CONTEXT(), e);
                    throw new XWSSecurityException((Throwable)e);
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                    SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    skBinding.setKeyBinding(x509Binding);
                    if (inferredKB == null) {
                        inferredSignaturePolicy.setKeyBinding(skBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                    }
                }
                Key key = ((EncryptedKeyToken)securityToken).getSecretKey(KeyResolver.getKey(kiHB, sig, context), dataEncAlgo);
                context.setExtraneousProperty("SecretKeyValue", key);
                return var3_27;
            }
            if ("http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(valueType) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct".equals(valueType)) {
                void var15_76;
                String sctId = SecurableSoapMessage.getIdFromFragmentRef(uri);
                SecurityToken securityToken = (SecurityToken)tokenCache.get(sctId);
                if (securityToken == null) {
                    void var15_75;
                    SecurityContextTokenImpl securityContextTokenImpl = SecurityUtil.locateBySCTId(context, uri);
                    if (securityContextTokenImpl == null) {
                        SecurityToken securityToken2 = KeyResolver.resolveToken(sctId, context, secureMsg);
                    }
                    if (var15_75 == null) {
                        log.log(Level.SEVERE, LogStringsMessages.WSS_0242_UNABLETO_LOCATE_SCT());
                        throw new XWSSecurityException("SCT Token with Id " + sctId + "not found");
                    }
                    tokenCache.put(sctId, var15_75);
                }
                if (!(var15_76 instanceof SecurityContextToken)) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0243_INVALID_VALUE_TYPE_NON_SCT_TOKEN());
                    throw new XWSSecurityException("Incorrect ValueType: http://schemas.xmlsoap.org/ws/2005/02/sc/sct, specified for a Non SCT Token");
                }
                byte[] proofKey = KeyResolver.resolveSCT(context, (SecurityContextTokenImpl)var15_76, sig);
                String encAlgo = "AES";
                if (context.getAlgorithmSuite() != null) {
                    encAlgo = SecurityUtil.getSecretKeyAlgorithm(context.getAlgorithmSuite().getEncryptionAlgorithm());
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                    SecureConversationTokenKeyBinding sctBinding = new SecureConversationTokenKeyBinding();
                    if (inferredKB == null) {
                        inferredSignaturePolicy.setKeyBinding(sctBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(sctBinding);
                    }
                }
                SecretKeySpec secretKeySpec = new SecretKeySpec(proofKey, encAlgo);
                return var3_27;
            }
            if (null != valueType) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0337_UNSUPPORTED_DIRECTREF_MECHANISM(((DirectReference)refElement).getValueType()), new Object[]{((DirectReference)refElement).getValueType()});
                XWSSecurityException xwsse = new XWSSecurityException("unsupported directreference ValueType " + ((DirectReference)refElement).getValueType());
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
            }
            String wsuId = SecurableSoapMessage.getIdFromFragmentRef(uri);
            SecurityContextTokenImpl securityContextTokenImpl = SecurityUtil.locateBySCTId(context, wsuId);
            if (securityContextTokenImpl == null) {
                SecurityToken securityToken = KeyResolver.resolveToken(wsuId, context, secureMsg);
            }
            if (var15_79 instanceof X509SecurityToken) {
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    x509Binding.setReferenceType("Direct");
                    if (inferredKB == null) {
                        inferredSignaturePolicy.setKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                    }
                }
                Key key = KeyResolver.resolveX509Token(secureMsg, (X509SecurityToken)var15_79, sig, context);
                return var3_27;
            }
            if (var15_79 instanceof EncryptedKeyToken) {
                KeyInfoHeaderBlock kiHB = ((EncryptedKeyToken)var15_79).getKeyInfo();
                SecurityTokenReference sectr = kiHB.getSecurityTokenReference(0);
                ReferenceElement refElem = sectr.getReference();
                String dataEncAlgo = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
                if (context.getAlgorithmSuite() != null) {
                    dataEncAlgo = context.getAlgorithmSuite().getEncryptionAlgorithm();
                } else if (context.getDataEncryptionAlgorithm() != null) {
                    dataEncAlgo = context.getDataEncryptionAlgorithm();
                }
                try {
                    Element cipherData = (Element)((EncryptedKeyToken)var15_79).getAsSoapElement().getChildElements(new QName("http://www.w3.org/2001/04/xmlenc#", "CipherData", "xenc")).next();
                    String cipherValue = cipherData.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0).getTextContent();
                    byte[] decodedCipher = Base64.decode(cipherValue);
                    byte[] ekSha1 = MessageDigest.getInstance("SHA-1").digest(decodedCipher);
                    String encEkSha1 = Base64.encode(ekSha1);
                    context.setExtraneousProperty("EKSHA1Value", encEkSha1);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0241_UNABLETO_SET_EKSHA_1_ON_CONTEXT(), e);
                    throw new XWSSecurityException((Throwable)e);
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                    SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    skBinding.setKeyBinding(x509Binding);
                    if (inferredKB == null) {
                        inferredSignaturePolicy.setKeyBinding(skBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                    }
                }
                Key key = ((EncryptedKeyToken)var15_79).getSecretKey(KeyResolver.getKey(kiHB, sig, context), dataEncAlgo);
                context.setExtraneousProperty("SecretKeyValue", key);
                return var3_27;
            }
            if (var15_79 instanceof SecurityContextToken) {
                byte[] proofKey = KeyResolver.resolveSCT(context, (SecurityContextTokenImpl)var15_79, sig);
                String encAlgo = "AES";
                if (context.getAlgorithmSuite() != null) {
                    encAlgo = SecurityUtil.getSecretKeyAlgorithm(context.getAlgorithmSuite().getEncryptionAlgorithm());
                }
                if (isWSITRecipient) {
                    MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                    SecureConversationTokenKeyBinding sctBinding = new SecureConversationTokenKeyBinding();
                    if (inferredKB == null) {
                        inferredSignaturePolicy.setKeyBinding(sctBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(sctBinding);
                    }
                }
                SecretKeySpec secretKeySpec = new SecretKeySpec(proofKey, encAlgo);
                return var3_27;
            }
            if (!(var15_79 instanceof DerivedKeyTokenHeaderBlock)) {
                String message = " Cannot Resolve URI " + uri;
                log.log(Level.SEVERE, LogStringsMessages.WSS_0337_UNSUPPORTED_DIRECTREF_MECHANISM(message), new Object[]{message});
                XWSSecurityException xwsse = new XWSSecurityException(message);
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, xwsse.getMessage(), xwsse);
            }
            if (isWSITRecipient) {
                MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
                DerivedTokenKeyBinding dtkBinding = new DerivedTokenKeyBinding();
                if (inferredKB != null) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0244_INVALID_LEVEL_DKT());
                    throw new XWSSecurityException("A derived Key Token should be a top level key binding");
                }
                inferredSignaturePolicy.setKeyBinding(dtkBinding);
            }
            Key key = KeyResolver.resolveDKT(context, (DerivedKeyTokenHeaderBlock)var15_79);
            return var3_27;
        }
        if (!(refElement instanceof X509IssuerSerial)) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0338_UNSUPPORTED_REFERENCE_MECHANISM());
            XWSSecurityException xwsse = new XWSSecurityException("Key reference mechanism not supported");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
        }
        BigInteger serialNumber = ((X509IssuerSerial)refElement).getSerialNumber();
        String issuerName = ((X509IssuerSerial)refElement).getIssuerName();
        if (isWSITRecipient) {
            MLSPolicy inferredKB = inferredSignaturePolicy.getKeyBinding();
            AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
            x509Binding.setReferenceType("IssuerSerialNumber");
            if (inferredKB == null) {
                inferredSignaturePolicy.setKeyBinding(x509Binding);
            } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
            }
        }
        if (sig) {
            PublicKey publicKey = context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), serialNumber, issuerName);
            return var3_27;
        }
        PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), serialNumber, issuerName);
        return var3_27;
    }
}

