/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.ws.security.opt.api.NamespaceContextInfo;
import com.sun.xml.ws.security.opt.api.PolicyBuilder;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.enc.CryptoProcessor;
import com.sun.xml.ws.security.opt.impl.incoming.processor.CipherDataProcessor;
import com.sun.xml.ws.security.opt.impl.incoming.processor.KeyInfoProcessor;
import com.sun.xml.ws.security.opt.impl.incoming.processor.ReferenceListProcessor;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.KeySelector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class EncryptedKey
implements SecurityHeaderElement,
NamespaceContextInfo,
SecurityElementWriter,
PolicyBuilder {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.crypto", "com.sun.xml.wss.logging.impl.opt.crypto.LogStrings");
    private static final String ENCRYPTION_METHOD = "EncryptionMethod".intern();
    private static final String REFERENCE_LIST = "ReferenceList".intern();
    private static final String CIPHER_DATA = "CipherData".intern();
    private static final String KEYINFO = "KeyInfo".intern();
    private static final String DIGEST_METHOD = "DigestMethod".intern();
    private static final String KEY_SIZE = "KeySize".intern();
    private static final int KEYINFO_ELEMENT = 1;
    private static final int ENCRYPTIONMETHOD_ELEMENT = 2;
    private static final int REFERENCE_LIST_ELEMENT = 4;
    private static final int CIPHER_DATA_ELEMENT = 5;
    private static final int KEY_SIZE_ELEMENT = 6;
    private static final int DIGEST_METHOD_ELEMENT = 7;
    private String id = "";
    private String namespaceURI = "";
    private String localName = "";
    private String encryptionMethod = "";
    private Key keyEncKey = null;
    private ArrayList<String> referenceList = null;
    private JAXBFilterProcessingContext pc = null;
    private Key dataEncKey = null;
    private ArrayList<String> pendingRefList = null;
    private HashMap<String, String> nsDecls;
    private CryptoProcessor cp = null;
    private CipherDataProcessor cdp = null;
    private EncryptionPolicy encPolicy = null;
    private WSSPolicy inferredKB = null;
    private boolean ignoreEKSHA1 = false;
    private boolean emPresent = false;

    public EncryptedKey(XMLStreamReader reader, JAXBFilterProcessingContext pc, HashMap nsDecls) throws XMLStreamException, XWSSecurityException {
        this.pc = pc;
        this.nsDecls = nsDecls;
        this.process(reader);
    }

    public EncryptedKey(XMLStreamReader reader, JAXBFilterProcessingContext pc, HashMap nsDecls, boolean ignoreEKSHA1) throws XMLStreamException, XWSSecurityException {
        this.pc = pc;
        this.ignoreEKSHA1 = ignoreEKSHA1;
        this.nsDecls = nsDecls;
        this.process(reader);
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalPart() {
        return this.localName;
    }

    @Override
    public XMLStreamReader readHeader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(OutputStream os) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) {
        throw new UnsupportedOperationException();
    }

    private void process(XMLStreamReader reader) throws XMLStreamException, XWSSecurityException {
        this.id = reader.getAttributeValue(null, "Id");
        if (this.pc.isBSP()) {
            String tmp = reader.getAttributeValue(null, "Recipient");
            if (tmp != null) {
                logger.log(Level.SEVERE, LogStringsMessages.BSP_5602_ENCRYPTEDKEY_RECIPIENT(this.id));
                throw new XWSSecurityException(LogStringsMessages.BSP_5602_ENCRYPTEDKEY_RECIPIENT(this.id));
            }
            String mt = reader.getAttributeValue(null, "MimeType");
            if (mt != null) {
                logger.log(Level.SEVERE, LogStringsMessages.BSP_5622_ENCRYPTEDKEY_MIMETYPE(this.id));
                throw new XWSSecurityException(LogStringsMessages.BSP_5622_ENCRYPTEDKEY_MIMETYPE(this.id));
            }
            String et = reader.getAttributeValue(null, "Encoding");
            if (et != null) {
                logger.log(Level.SEVERE, LogStringsMessages.BSP_5623_ENCRYPTEDKEY_ENCODING(this.id));
                throw new XWSSecurityException(LogStringsMessages.BSP_5623_ENCRYPTEDKEY_ENCODING(this.id));
            }
        }
        this.namespaceURI = reader.getNamespaceURI();
        this.localName = reader.getLocalName();
        if (StreamUtil.moveToNextElement(reader)) {
            int refElement = this.getEventType(reader);
            while (reader.getEventType() != 8) {
                switch (refElement) {
                    case 2: {
                        this.processEncryptionMethod(reader);
                        reader.next();
                        this.emPresent = true;
                        break;
                    }
                    case 1: {
                        this.pc.getSecurityContext().setInferredKB(null);
                        this.pc.setExtraneousProperty("EncryptedKey", "true");
                        KeyInfoProcessor kip = new KeyInfoProcessor(this.pc, KeySelector.Purpose.DECRYPT);
                        this.keyEncKey = kip.getKey(reader);
                        this.pc.removeExtraneousProperty("EncryptedKey");
                        this.inferredKB = (WSSPolicy)this.pc.getSecurityContext().getInferredKB();
                        this.pc.getSecurityContext().setInferredKB(null);
                        break;
                    }
                    case 4: {
                        this.encPolicy = new EncryptionPolicy();
                        this.encPolicy.setFeatureBinding(new EncryptionPolicy.FeatureBinding());
                        ReferenceListProcessor rlp = new ReferenceListProcessor(this.encPolicy);
                        rlp.process(reader);
                        this.referenceList = rlp.getReferences();
                        this.pendingRefList = (ArrayList)this.referenceList.clone();
                        break;
                    }
                    case 5: {
                        this.cdp = new CipherDataProcessor(this.pc);
                        this.cdp.process(reader);
                        if (!this.ignoreEKSHA1) {
                            try {
                                byte[] decodedCipher = this.cdp.readAsBytes();
                                byte[] ekSha1 = MessageDigest.getInstance("SHA-1").digest(decodedCipher);
                                String encEkSha1 = Base64.encode(ekSha1);
                                if (!this.pc.isSAMLEK() && this.pc.getExtraneousProperty("EKSHA1Value") == null) {
                                    this.pc.setExtraneousProperty("EKSHA1Value", encEkSha1);
                                }
                            }
                            catch (NoSuchAlgorithmException nsae) {
                                throw new XWSSecurityException((Throwable)nsae);
                            }
                        }
                        this.cp = new CryptoProcessor(4, this.encryptionMethod, this.keyEncKey);
                        break;
                    }
                    default: {
                        if (!StreamUtil.isStartElement(reader)) break;
                        throw new XWSSecurityException("Element name " + reader.getName() + " is not recognized under EncryptedKey");
                    }
                }
                if (this.shouldBreak(reader)) break;
                if (reader.getEventType() == 1) {
                    if (this.getEventType(reader) == -1) {
                        reader.next();
                    }
                } else {
                    reader.next();
                }
                refElement = this.getEventType(reader);
            }
        }
        if (this.pc.isBSP() && this.emPresent) {
            logger.log(Level.SEVERE, LogStringsMessages.BSP_5603_ENCRYPTEDKEY_ENCRYPTIONMEHOD(this.id));
            throw new XWSSecurityException(LogStringsMessages.BSP_5603_ENCRYPTEDKEY_ENCRYPTIONMEHOD(this.id));
        }
    }

    private boolean shouldBreak(XMLStreamReader reader) throws XMLStreamException {
        if (StreamUtil._break(reader, "EncryptedKey", "http://www.w3.org/2001/04/xmlenc#")) {
            return true;
        }
        return reader.getEventType() == 8;
    }

    private void processEncryptionMethod(XMLStreamReader reader) throws XMLStreamException, XWSSecurityException {
        this.encryptionMethod = reader.getAttributeValue(null, "Algorithm");
        if (this.encryptionMethod == null || this.encryptionMethod.length() == 0) {
            logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1925_EMPTY_ENCMETHOD_ED());
            throw new XWSSecurityException(com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1925_EMPTY_ENCMETHOD_ED());
        }
        while (reader.getEventType() != 8) {
            int eventType = this.getEventType(reader);
            switch (eventType) {
                case 7: {
                    break;
                }
                case 6: {
                    break;
                }
            }
            if (reader.getEventType() == 2 && reader.getLocalName() == ENCRYPTION_METHOD) break;
            reader.next();
        }
    }

    private int getEventType(XMLStreamReader reader) {
        if (reader.getEventType() == 1) {
            if (reader.getLocalName() == ENCRYPTION_METHOD) {
                return 2;
            }
            if (reader.getLocalName() == CIPHER_DATA) {
                return 5;
            }
            if (reader.getLocalName() == REFERENCE_LIST) {
                return 4;
            }
            if (reader.getLocalName() == KEYINFO) {
                return 1;
            }
            if (reader.getLocalName() == DIGEST_METHOD) {
                return 7;
            }
            if (reader.getLocalName() == KEY_SIZE) {
                return 6;
            }
        }
        return -1;
    }

    public List<String> getReferenceList() {
        return this.referenceList;
    }

    public List<String> getPendingReferenceList() {
        return this.pendingRefList;
    }

    public Key getKey(String encAlgo) throws XWSSecurityException {
        if (this.dataEncKey == null) {
            try {
                this.dataEncKey = this.cp.decryptKey(this.cdp.readAsBytes(), encAlgo);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1927_ERROR_DECRYPT_ED("EncryptedKey"));
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages.WSS_1927_ERROR_DECRYPT_ED("EncryptedKey"), ex);
            }
            if (!this.ignoreEKSHA1 && this.pc.getExtraneousProperty("SecretKeyValue") == null) {
                this.pc.setExtraneousProperty("SecretKeyValue", this.dataEncKey);
            }
        }
        return this.dataEncKey;
    }

    @Override
    public HashMap<String, String> getInscopeNSContext() {
        return this.nsDecls;
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WSSPolicy getPolicy() {
        return this.encPolicy;
    }

    public WSSPolicy getInferredKB() {
        return this.inferredKB;
    }
}

